/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.SeqRange;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;

public final class UtilInit
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Iter iter = this.exprs[0].iter(qc);
        final long size = iter.size();
        if (size == 0L || size == 1L) {
            return Empty.ITER;
        }
        Value value = iter.iterValue();
        if (value != null) {
            return value.subsequence(0L, size - 1L, qc).iter();
        }
        if (size != -1L) {
            return new Iter(){
                int n;

                @Override
                public Item next() throws QueryException {
                    return (long)(++this.n) < size ? qc.next(iter) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return iter.get(i);
                }

                @Override
                public long size() {
                    return size - 1L;
                }
            };
        }
        return new Iter(){
            Item last;
            {
                this.last = iter.next();
            }

            @Override
            public Item next() throws QueryException {
                Item item = this.last;
                if (item != null) {
                    this.last = qc.next(iter);
                    if (this.last == null) {
                        return null;
                    }
                }
                return item;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.exprs[0].value(qc);
        long size = value.size();
        return size < 1L ? value : value.subsequence(0L, size - 1L, qc);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr last;
        Expr[] args;
        SeqRange r;
        Expr expr = this.exprs[0];
        if (expr instanceof Value) {
            return this.value(cc.qc);
        }
        SeqType st = expr.seqType();
        if (st.zeroOrOne()) {
            return Empty.VALUE;
        }
        long size = expr.size();
        if (size != -1L) {
            if (size == 2L) {
                return cc.function(Function.HEAD, this.info, expr);
            }
            if (Function._UTIL_INIT.is(expr)) {
                return cc.function(Function.SUBSEQUENCE, this.info, expr.arg(0), Int.ONE, Int.get(size - 1L));
            }
        }
        if ((Function.SUBSEQUENCE.is(expr) || Function._UTIL_RANGE.is(expr)) && (r = SeqRange.get(expr, cc)) != null) {
            return cc.function(Function.SUBSEQUENCE, this.info, expr.arg(0), Int.get(r.start + 1L), Int.get(r.length - 1L));
        }
        if (Function._UTIL_REPLICATE.is(expr) && (args = expr.args())[1] instanceof Int && args[0].seqType().zeroOrOne()) {
            args[1] = Int.get(((Int)args[1]).itr() - 1L);
            return cc.function(Function._UTIL_REPLICATE, this.info, args);
        }
        if (expr instanceof List && (last = (args = expr.args())[args.length - 1]).seqType().oneOrMore()) {
            args[args.length - 1] = cc.function(Function._UTIL_INIT, this.info, last);
            return List.get(cc, this.info, args);
        }
        this.exprType.assign(st.union(Occ.ZERO), size - 1L);
        this.data(expr.data());
        return this;
    }
}

