/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.basex.core.users.Perm;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.java.DynJavaConstr;
import org.basex.query.func.java.DynJavaFunc;
import org.basex.query.func.java.JavaMapping;
import org.basex.query.func.java.StaticJavaCall;
import org.basex.query.iter.Iter;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Jav;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;
import org.basex.util.similarity.Levenshtein;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class JavaCall
extends Arr {
    final StaticContext sc;
    final Perm perm;
    final boolean updating;

    JavaCall(Expr[] args, Perm perm, boolean updating, StaticContext sc, InputInfo info) {
        super(info, SeqType.ITEM_ZM, args);
        this.updating = updating;
        this.sc = sc;
        this.perm = perm;
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        if (!qc.context.user().has(this.perm)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(this.info, new Object[]{this.perm, this});
        }
        Value value = JavaCall.toValue(this.eval(qc), qc, this.sc);
        if (!this.updating) {
            return value;
        }
        qc.updates().addOutput(value, qc);
        return Empty.VALUE;
    }

    protected abstract Object eval(QueryContext var1) throws QueryException;

    public static Value toValue(Object object, QueryContext qc, StaticContext sc) throws QueryException {
        if (object == null) {
            return Empty.VALUE;
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Iter) {
            return ((Iter)object).value(qc, null);
        }
        Type type = JavaCall.type(object);
        if (type != null) {
            return type.cast(object, qc, sc, null);
        }
        if (object instanceof byte[]) {
            return BytSeq.get((byte[])object);
        }
        if (object instanceof long[]) {
            return IntSeq.get((long[])object);
        }
        if (object instanceof char[]) {
            return Str.get(new String((char[])object));
        }
        if (object instanceof boolean[]) {
            return BlnSeq.get((boolean[])object);
        }
        if (object instanceof double[]) {
            return DblSeq.get((double[])object);
        }
        if (object instanceof float[]) {
            return FltSeq.get((float[])object);
        }
        if (!object.getClass().isArray()) {
            return new Jav(object, qc);
        }
        int s = Array.getLength(object);
        if (s == 0) {
            return Empty.VALUE;
        }
        if (object instanceof String[]) {
            String[] r = (String[])object;
            byte[][] b = new byte[r.length][];
            for (int v = 0; v < s; ++v) {
                b[v] = Token.token(r[v]);
            }
            return StrSeq.get(b);
        }
        if (object instanceof char[][]) {
            char[][] r = (char[][])object;
            byte[][] b = new byte[r.length][];
            for (int v = 0; v < s; ++v) {
                b[v] = Token.token(new String(r[v]));
            }
            return StrSeq.get(b);
        }
        if (object instanceof short[]) {
            short[] r = (short[])object;
            long[] b = new long[r.length];
            for (int v = 0; v < s; ++v) {
                b[v] = r[v];
            }
            return IntSeq.get(b, AtomType.SHORT);
        }
        if (object instanceof int[]) {
            int[] r = (int[])object;
            long[] b = new long[r.length];
            for (int v = 0; v < s; ++v) {
                b[v] = r[v];
            }
            return IntSeq.get(b, AtomType.INT);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Object obj : (Object[])object) {
            vb.add(JavaCall.toValue(obj, qc, sc));
        }
        return vb.value();
    }

    public static JavaCall get(QNm qname, Expr[] args, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        String uri;
        boolean enforce;
        String name = Strings.camelCase(Token.string(qname.local()));
        String[] types = null;
        int n = name.indexOf(183);
        if (n != -1) {
            types = Strings.split(name.substring(n + 1), '\u00b7');
            name = name.substring(0, n);
        }
        String className = (enforce = (uri = Token.string(qname.uri())).startsWith("java:")) ? uri.substring("java:".length()) : Strings.className(Strings.uri2path(uri));
        ModuleLoader modules = qc.resources.modules();
        Object module = modules.findModule(className);
        if (module != null) {
            boolean updating;
            Method meth = JavaCall.moduleMethod(module, name, args.length, types, qname, qc, ii);
            QueryModule.Requires req = meth.getAnnotation(QueryModule.Requires.class);
            Perm perm = req == null ? Perm.ADMIN : Perm.get(req.value().name().toLowerCase(Locale.ENGLISH));
            boolean bl = updating = meth.getAnnotation(QueryModule.Updating.class) != null;
            if (updating) {
                qc.updating();
            }
            return new StaticJavaCall(module, meth, args, perm, updating, sc, ii);
        }
        if (enforce || (sc.module == null || !Token.eq(sc.module.uri(), qname.uri())) && NSGlobal.prefix(qname.uri()).length == 0) {
            Class<?> clazz = null;
            try {
                clazz = modules.findClass(className);
            }
            catch (ClassNotFoundException ex) {
                if (enforce) {
                    Util.debug(ex);
                }
            }
            catch (Throwable th) {
                throw QueryError.JAVAINIT_X_X.get(ii, Util.className(th), th);
            }
            if (clazz == null) {
                if (enforce) {
                    throw QueryError.WHICHCLASS_X.get(ii, className);
                }
            } else {
                DynJavaConstr djc;
                if (name.equals("new") && (djc = new DynJavaConstr(clazz, types, args, sc, ii)).init(enforce)) {
                    return djc;
                }
                DynJavaFunc djf = new DynJavaFunc(clazz, name, types, args, sc, ii);
                if (djf.init(enforce)) {
                    return djf;
                }
            }
        }
        return null;
    }

    private static Method moduleMethod(Object module, String name, int arity, String[] types, QNm qname, QueryContext qc, InputInfo ii) throws QueryException {
        Method[] methods;
        Method method = null;
        IntList arities = new IntList();
        for (Method m : methods = module.getClass().getMethods()) {
            if (!m.getName().equals(name)) continue;
            Class<?>[] pTypes = m.getParameterTypes();
            int mArity = pTypes.length;
            if (mArity == arity) {
                if (!JavaCall.typesMatch(pTypes, types)) continue;
                if (method != null) {
                    throw QueryError.JAVAMULTIFUNC_X_X.get(ii, qname.string(), QueryError.arguments(arity));
                }
                method = m;
                continue;
            }
            if (types != null) continue;
            arities.add(mArity);
        }
        if (method != null) {
            QueryModule.Lock lock = method.getAnnotation(QueryModule.Lock.class);
            if (lock != null) {
                qc.locks.add("basex:" + lock.value());
            }
            return method;
        }
        TokenList names = new TokenList();
        for (Method m : methods) {
            names.add(m.getName());
        }
        throw JavaCall.noFunction(name, arity, Token.string(qname.string()), arities, types, ii, (byte[][])names.finish());
    }

    static QueryException noFunction(String name, int arity, String full, IntList arities, String[] types, InputInfo ii, byte[][] names) {
        if (!arities.isEmpty()) {
            return Functions.wrongArity(full, arity, arities, ii);
        }
        byte[] nm = Token.token(name);
        Object similar = Levenshtein.similar(nm, (Object[])names);
        if (similar != null && Token.eq(nm, (byte[])similar)) {
            TokenBuilder tb = new TokenBuilder();
            for (String type : types) {
                if (!tb.isEmpty()) {
                    tb.add(", ");
                }
                tb.add(type.replaceAll("^.*\\.", ""));
            }
            return QueryError.JAVAARGS_X_X.get(ii, full, tb);
        }
        return QueryError.WHICHFUNC_X.get(ii, new Object[]{QueryError.similar(full, similar)});
    }

    protected static boolean typesMatch(Class<?>[] pTypes, String[] qTypes) {
        if (qTypes == null) {
            return true;
        }
        int pl = pTypes.length;
        if (pl != qTypes.length) {
            return false;
        }
        for (int p = 0; p < pl; ++p) {
            if (qTypes[p].equals(pTypes[p].getName())) continue;
            return false;
        }
        return true;
    }

    private static Type type(Object object) {
        Type type = JavaMapping.type(object.getClass(), true);
        if (type != null) {
            return type;
        }
        if (object instanceof Element) {
            return NodeType.ELEMENT;
        }
        if (object instanceof Document) {
            return NodeType.DOCUMENT_NODE;
        }
        if (object instanceof DocumentFragment) {
            return NodeType.DOCUMENT_NODE;
        }
        if (object instanceof Attr) {
            return NodeType.ATTRIBUTE;
        }
        if (object instanceof Comment) {
            return NodeType.COMMENT;
        }
        if (object instanceof ProcessingInstruction) {
            return NodeType.PROCESSING_INSTRUCTION;
        }
        if (object instanceof Text) {
            return NodeType.TEXT;
        }
        if (object instanceof Duration) {
            Duration d = (Duration)object;
            return !d.isSet(DatatypeConstants.YEARS) && !d.isSet(DatatypeConstants.MONTHS) ? AtomType.DAY_TIME_DURATION : (!d.isSet(DatatypeConstants.HOURS) && !d.isSet(DatatypeConstants.MINUTES) && !d.isSet(DatatypeConstants.SECONDS) ? AtomType.YEAR_MONTH_DURATION : AtomType.DURATION);
        }
        if (object instanceof XMLGregorianCalendar) {
            QName qnm = ((XMLGregorianCalendar)object).getXMLSchemaType();
            if (qnm == DatatypeConstants.DATE) {
                return AtomType.DATE;
            }
            if (qnm == DatatypeConstants.DATETIME) {
                return AtomType.DATE_TIME;
            }
            if (qnm == DatatypeConstants.TIME) {
                return AtomType.TIME;
            }
            if (qnm == DatatypeConstants.GYEARMONTH) {
                return AtomType.G_YEAR_MONTH;
            }
            if (qnm == DatatypeConstants.GMONTHDAY) {
                return AtomType.G_MONTH_DAY;
            }
            if (qnm == DatatypeConstants.GYEAR) {
                return AtomType.G_YEAR;
            }
            if (qnm == DatatypeConstants.GMONTH) {
                return AtomType.G_MONTH;
            }
            if (qnm == DatatypeConstants.GDAY) {
                return AtomType.G_DAY;
            }
        }
        return null;
    }

    abstract String desc();

    abstract String name();

    @Override
    public final String description() {
        return this.desc() + "(...)";
    }

    @Override
    public final void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name()), this.exprs);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.desc()).params(this.exprs);
    }
}

