/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.FnSubsequence;
import org.basex.util.Util;

public final class SeqRange {
    public long start;
    public long end;
    public long length;

    SeqRange(long start, long end) {
        this.assign(start, end);
    }

    public static SeqRange get(Expr expr, CompileContext cc) throws QueryException {
        return expr instanceof FnSubsequence ? ((FnSubsequence)expr).range(cc) : null;
    }

    long adjust(long size) {
        if (size != -1L && size < this.end) {
            this.assign(Math.min(this.start, size), size);
        }
        return size;
    }

    private void assign(long s, long e) {
        boolean max = e == Long.MAX_VALUE;
        this.start = s;
        this.end = max ? Long.MAX_VALUE : Math.max(s, e);
        this.length = max ? Long.MAX_VALUE : this.end - s;
    }

    public String toString() {
        return Util.className(this) + "[start: " + this.start + ", end: " + this.end + ", length: " + this.length + ']';
    }
}

