/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileReadTextLines;
import org.basex.query.func.fn.SeqRange;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.Checks;

public class FnSubsequence
extends StandardFunc {
    private static final SeqRange ALL = new SeqRange(0L, Long.MAX_VALUE);
    private static final SeqRange EMPTY = new SeqRange(0L, 0L);

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final SeqRange sr = this.range(qc);
        if (sr == EMPTY) {
            return Empty.ITER;
        }
        final Iter iter = this.exprs[0].iter(qc);
        if (sr == ALL) {
            return iter;
        }
        long size = sr.adjust(iter.size());
        if (sr.length == 0L) {
            return Empty.ITER;
        }
        if (size != -1L) {
            Value value = iter.iterValue();
            if (value != null) {
                return value.subsequence(sr.start, sr.length, qc).iter();
            }
            if (sr.length == size) {
                return iter;
            }
            return new Iter(){
                long c;
                {
                    this.c = sr.start;
                }

                @Override
                public Item next() throws QueryException {
                    qc.checkStop();
                    return this.c < sr.end ? iter.get(this.c++) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return iter.get(sr.start + i);
                }

                @Override
                public long size() {
                    return sr.length;
                }
            };
        }
        return new Iter(){
            long c;

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.c < sr.end && (item = qc.next(iter)) != null) {
                    if (++this.c <= sr.start) continue;
                    return item;
                }
                return null;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item item;
        SeqRange sr = this.range(qc);
        if (sr == EMPTY) {
            return Empty.VALUE;
        }
        Expr expr = this.exprs[0];
        if (sr == ALL) {
            return expr.value(qc);
        }
        Iter iter = expr.iter(qc);
        long size = sr.adjust(iter.size());
        if (sr.length == 0L) {
            return Empty.VALUE;
        }
        if (size != -1L) {
            Value value = iter.iterValue();
            if (value != null) {
                return value.subsequence(sr.start, sr.length, qc);
            }
            if (sr.length == size) {
                return iter.value(qc, this);
            }
            ValueBuilder vb = new ValueBuilder(qc);
            for (long i = sr.start; i < sr.end; ++i) {
                vb.add(iter.get(i));
            }
            return vb.value(this);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (long c = 0L; c < sr.end && (item = qc.next(iter)) != null; ++c) {
            if (c < sr.start) continue;
            vb.add(item);
        }
        return vb.value(this);
    }

    SeqRange range(CompileContext cc) throws QueryException {
        return this.exprs[1] instanceof Value && (this.exprs.length < 3 || this.exprs[2] instanceof Value) ? this.range(cc.qc) : null;
    }

    private SeqRange range(QueryContext qc) throws QueryException {
        double d = this.toDouble(this.exprs[1], qc);
        if (Double.isNaN(d)) {
            return EMPTY;
        }
        long start = this.start(d);
        long end = Long.MAX_VALUE;
        if (this.exprs.length > 2) {
            d = this.toDouble(this.exprs[2], qc);
            if (Double.isNaN(d) || start == Long.MIN_VALUE && d == Double.POSITIVE_INFINITY) {
                return EMPTY;
            }
            end = this.end(start, d);
        }
        if (end == Long.MAX_VALUE && start <= 1L) {
            return ALL;
        }
        if (start == Long.MIN_VALUE) {
            return EMPTY;
        }
        SeqRange sr = new SeqRange(Math.max(0L, start - 1L), end);
        return sr.length == 0L ? EMPTY : sr;
    }

    public long start(double value) {
        return StrictMath.round(value);
    }

    public long end(long first, double second) {
        long l = StrictMath.round(second);
        return l == Long.MAX_VALUE ? l : l + first - 1L;
    }

    @Override
    protected final Expr opt(CompileContext cc) throws QueryException {
        Expr expr = this.exprs[0];
        SeqType st = expr.seqType();
        if (st.zero()) {
            return expr;
        }
        long sz = -1L;
        SeqRange sr = this.range(cc);
        if (sr != null) {
            Expr[] args;
            if (sr == EMPTY) {
                return Empty.VALUE;
            }
            if (sr == ALL) {
                return expr;
            }
            if (expr instanceof Value) {
                return this.value(cc.qc);
            }
            long size = sr.adjust(expr.size());
            if (size != -1L) {
                if (sr.length == size) {
                    return expr;
                }
                if (sr.start == size - 1L) {
                    return cc.function(Function._UTIL_LAST, this.info, expr);
                }
                if (sr.start == 1L && sr.end == size) {
                    return cc.function(Function.TAIL, this.info, expr);
                }
                if (sr.start == 0L && sr.end == size - 1L) {
                    return cc.function(Function._UTIL_INIT, this.info, expr);
                }
                sz = sr.length;
            } else if (st.zeroOrOne()) {
                return sr.start == 0L ? expr : Empty.VALUE;
            }
            if (sr.length == 1L) {
                return sr.start == 0L ? cc.function(Function.HEAD, this.info, expr) : cc.function(Function._UTIL_ITEM, this.info, expr, Int.get(sr.start + 1L));
            }
            if (sr.length == Long.MAX_VALUE && sr.start == 1L) {
                return cc.function(Function.TAIL, this.info, expr);
            }
            if (Function._FILE_READ_TEXT_LINES.is(expr)) {
                return FileReadTextLines.opt(this, sr.start, sr.length, cc);
            }
            if (Function._UTIL_REPLICATE.is(expr) && (args = expr.args())[0].size() == 1L && args[1] instanceof Int) {
                args[1] = Int.get(sr.length);
                return cc.function(Function._UTIL_REPLICATE, this.info, args);
            }
            if (expr instanceof List && ((Checks<Expr>)ex -> ex.seqType().one()).all((Expr[])(args = expr.args()))) {
                return List.get(cc, this.info, Arrays.copyOfRange(args, (int)sr.start, (int)sr.end));
            }
        } else if (this.exprs[1] == Int.ONE && this.exprs[2] instanceof Arith && !this.exprs[0].has(Flag.NDT)) {
            Arith ar = (Arith)this.exprs[2];
            if (Function.COUNT.is(ar.exprs[0]) && ar.calc == Calc.MINUS && ar.exprs[1] == Int.ONE && this.exprs[0].equals(ar.exprs[0].arg(0))) {
                return cc.function(Function._UTIL_INIT, this.info, expr);
            }
        }
        this.exprType.assign(st.union(Occ.ZERO), sz);
        this.data(expr.data());
        return this;
    }

    @Override
    public final boolean ddo() {
        return this.exprs[0].ddo();
    }
}

