/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;

public final class FnSort
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Value value = this.exprs[0].value(qc);
        Value v = this.quickValue(value);
        return v != null ? v.iter() : this.iter(value, qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.exprs[0].value(qc);
        Value v = this.quickValue(value);
        return v != null ? v : this.iter(value, qc).value(qc, this);
    }

    private Iter iter(final Value value, QueryContext qc) throws QueryException {
        Item item;
        byte[] token;
        Collation coll = this.sc.collation;
        if (this.exprs.length > 1 && (token = this.toTokenOrNull(this.exprs[1], qc)) != null) {
            coll = Collation.get(token, qc, this.sc, this.info, QueryError.WHICHCOLL_X);
        }
        FItem key = this.exprs.length > 2 ? this.checkArity(this.exprs[2], 1, qc) : null;
        long size = value.size();
        ValueList values = new ValueList(size);
        BasicIter<Item> iter = value.iter();
        while ((item = qc.next(iter)) != null) {
            values.add((key == null ? item : key.invoke(qc, this.info, item)).atomValue(qc, this.info));
        }
        final Integer[] order = FnSort.sort(values, this, coll, qc);
        return new BasicIter<Item>(size){

            @Override
            public Item get(long i) {
                return value.itemAt(order[(int)i].intValue());
            }
        };
    }

    public static Integer[] sort(ValueList values, StandardFunc sf, Collation coll, QueryContext qc) throws QueryException {
        int al = values.size();
        Integer[] order = new Integer[al];
        for (int o = 0; o < al; ++o) {
            order[o] = o;
        }
        try {
            Arrays.sort(order, (i1, i2) -> {
                qc.checkStop();
                try {
                    Value value1 = (Value)values.get((int)i1);
                    Value value2 = (Value)values.get((int)i2);
                    long size1 = value1.size();
                    long size2 = value2.size();
                    long il = Math.min(size1, size2);
                    int i = 0;
                    while ((long)i < il) {
                        int diff;
                        Item item1 = value1.itemAt(i);
                        Item item2 = value2.itemAt(i);
                        if (item1 == Dbl.NAN || item1 == Flt.NAN) {
                            item1 = null;
                        }
                        if (item2 == Dbl.NAN || item2 == Flt.NAN) {
                            item2 = null;
                        }
                        if (item1 != null && item2 != null && !item1.comparable(item2)) {
                            throw QueryError.diffError(item1, item2, sf.info);
                        }
                        int n = item1 == null ? (item2 == null ? 0 : -1) : (diff = item2 == null ? 1 : item1.diff(item2, coll, sf.info));
                        if (diff != 0 && diff != Integer.MIN_VALUE) {
                            return diff;
                        }
                        ++i;
                    }
                    return (int)(size1 - size2);
                }
                catch (QueryException ex) {
                    throw new QueryRTException(ex);
                }
            });
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        return order;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        SeqType st;
        Value value;
        Expr expr1 = this.exprs[0];
        SeqType st1 = expr1.seqType();
        if (st1.zero()) {
            return expr1;
        }
        if (expr1 instanceof Value && (value = this.quickValue((Value)expr1)) != null) {
            return value;
        }
        if (Function._UTIL_REPLICATE.is(expr1) && (st = expr1.arg(0).seqType()).zeroOrOne() && st.type.isSortable()) {
            return expr1;
        }
        if (this.exprs.length == 3) {
            this.exprs[2] = this.coerceFunc(this.exprs[2], cc, SeqType.ANY_ATOMIC_TYPE_ZM, st1.with(Occ.EXACTLY_ONE));
        }
        return this.adoptType(expr1);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode == CompileContext.Simplify.DISTINCT && this.seqType().type.isSortable()) {
            expr = cc.simplify(this, this.exprs[0]);
        }
        return expr == this ? super.simplifyFor(mode, cc) : ((Expr)expr).simplifyFor(mode, cc);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.HOF.in(flags) && this.exprs.length > 2 || super.has(flags);
    }

    private Value quickValue(Value value) {
        if (this.exprs.length < 2) {
            if (value instanceof RangeSeq) {
                RangeSeq seq = (RangeSeq)value;
                return seq.asc ? seq : seq.reverse(null);
            }
            SeqType st = value.seqType();
            if (st.type.isSortable() && (st.one() || value instanceof SingletonSeq && ((SingletonSeq)value).singleItem())) {
                return value;
            }
        }
        return null;
    }
}

