/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import java.util.Collections;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.util.Checks;

public final class FnReverse
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        Item item;
        final Iter iter = this.exprs[0].iter(qc);
        final long size = iter.size();
        if (size == 0L) {
            return Empty.ITER;
        }
        if (size == 1L) {
            return iter;
        }
        Value value = iter.iterValue();
        if (value != null) {
            return value.reverse(qc).iter();
        }
        if (size > -1L) {
            return new Iter(){
                long c;
                {
                    this.c = size;
                }

                @Override
                public Item next() throws QueryException {
                    qc.checkStop();
                    return --this.c >= 0L ? iter.get(this.c) : null;
                }

                @Override
                public Item get(long i) throws QueryException {
                    return iter.get(size - i - 1L);
                }

                @Override
                public long size() {
                    return size;
                }
            };
        }
        ValueBuilder vb = new ValueBuilder(qc);
        while ((item = qc.next(iter)) != null) {
            vb.addFront(item);
        }
        return vb.value(this).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.exprs[0].value(qc).reverse(qc);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr[] args;
        Expr expr = this.exprs[0];
        if (expr.seqType().zeroOrOne() || expr instanceof SingletonSeq && ((SingletonSeq)expr).singleItem()) {
            return expr;
        }
        if (expr instanceof RangeSeq) {
            return ((RangeSeq)expr).reverse(cc.qc);
        }
        if (Function.TAIL.is(expr) && Function.REVERSE.is(expr.arg(0))) {
            return cc.function(Function._UTIL_INIT, this.info, expr.arg(0).args());
        }
        if (Function._UTIL_INIT.is(expr) && Function.REVERSE.is(expr.arg(0))) {
            return cc.function(Function.TAIL, this.info, expr.arg(0).args());
        }
        if (Function._UTIL_REPLICATE.is(expr) && !expr.has(Flag.NDT) && expr.arg(0).seqType().zeroOrOne()) {
            return expr;
        }
        if (expr instanceof List && ((Checks<Expr>)ex -> ex.seqType().zeroOrOne()).all((Expr[])(args = expr.args()))) {
            Collections.reverse(Arrays.asList(args));
            return expr;
        }
        return this.adoptType(expr);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode == CompileContext.Simplify.DISTINCT) {
            expr = cc.simplify(this, this.exprs[0]);
        }
        return expr == this ? super.simplifyFor(mode, cc) : ((Expr)expr).simplifyFor(mode, cc);
    }
}

