/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.file.FileFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;

public class FileWrite
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        this.write(false, qc);
        return Empty.VALUE;
    }

    final synchronized void write(boolean append, QueryContext qc) throws QueryException, IOException {
        Path path = this.checkParentDir(this.toPath(0, qc));
        Empty opts = this.exprs.length > 2 ? this.exprs[2].item(qc, this.info) : Empty.VALUE;
        SerializerOptions sopts = FuncOptions.serializer(opts, this.info);
        try (PrintOutput out = PrintOutput.get(new FileOutputStream(path.toFile(), append));
             Serializer ser = Serializer.get(out, sopts);){
            Item item;
            Iter iter = this.exprs[1].iter(qc);
            while ((item = iter.next()) != null) {
                ser.serialize(item);
            }
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
    }
}

