/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.Databases;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.node.FElem;
import org.basex.util.DateTime;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class DbBackups
extends StandardFunc {
    private static final String BACKUP = "backup";
    private static final String SIZE = "size";
    private static final String DATE = "date";
    private static final String DATABASE = "database";

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        String name = this.exprs.length == 0 ? null : Token.string(this.toToken(this.exprs[0], qc));
        final StringList backups = name == null ? qc.context.databases.backups() : qc.context.databases.backups(name);
        return new BasicIter<FElem>((long)backups.size()){
            final IOFile dbPath;
            {
                super(size);
                this.dbPath = qc.context.soptions.dbPath();
            }

            @Override
            public FElem get(long i) {
                String backup = (String)backups.get((int)i);
                long length = new IOFile(this.dbPath, backup + ".zip").length();
                String db = Databases.name(backup);
                Dtm dtm = Dtm.get(DateTime.parse(Databases.date(backup)).getTime());
                return new FElem(DbBackups.BACKUP).add(backup).add(DbBackups.DATABASE, db).add(DbBackups.DATE, dtm.string(DbBackups.this.info)).add(DbBackups.SIZE, Token.token(length));
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }
}

