/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.ArrayInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.bin.BinFn;
import org.basex.query.func.convert.ConvertFn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public final class BinDecodeString
extends BinFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Long len;
        B64 b64 = this.toB64(this.exprs[0], qc, true);
        String encoding = this.toEncodingOrNull(1, QueryError.BIN_UE_X, qc);
        Long off = this.exprs.length > 2 ? Long.valueOf(this.toLong(this.exprs[2], qc)) : null;
        Long l = len = this.exprs.length > 3 ? Long.valueOf(this.toLong(this.exprs[3], qc)) : null;
        if (b64 == null) {
            return Empty.VALUE;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(off, len, bl);
        int o = bounds[0];
        int tl = bounds[1];
        if (o > 0 || tl < bl) {
            bytes = Arrays.copyOfRange(bytes, o, o + tl);
        }
        try {
            return Str.get(ConvertFn.toString(new ArrayInput(bytes), encoding, true));
        }
        catch (IOException ex) {
            throw QueryError.BIN_CE_X.get(this.info, ex);
        }
    }
}

