/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.ArchiveText;
import org.basex.query.func.archive.CreateOptions;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public class ArchiveCreate
extends ArchiveFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Map<String, Item[]> map = this.toMap(0, qc);
        CreateOptions opts = this.toOptions(2, new CreateOptions(), qc);
        String format = opts.get(CreateOptions.FORMAT);
        if (format.equals("gzip") && map.size() > 1) {
            throw QueryError.ARCHIVE_SINGLE_X.get(this.info, format);
        }
        int level = this.level(opts);
        try (ArchiveOut out = ArchiveOut.get(format.toLowerCase(Locale.ENGLISH), this.info);){
            out.level(level);
            try {
                for (Item[] entry : map.values()) {
                    this.add(entry, out, level, "", qc);
                }
            }
            catch (IOException ex) {
                throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
            }
            B64 b64 = B64.get(out.finish());
            return b64;
        }
    }

    protected int level(CreateOptions options) throws QueryException {
        int level = 8;
        String format = options.get(CreateOptions.FORMAT);
        String alg = options.get(CreateOptions.ALGORITHM);
        if (alg != null) {
            if (format.equals("zip") && !Strings.eq(alg, "stored", "deflate") || format.equals("gzip") && !Strings.eq(alg, "deflate")) {
                throw QueryError.ARCHIVE_FORMAT_X_X.get(this.info, CreateOptions.ALGORITHM.name(), alg);
            }
            if (Strings.eq(alg, "stored")) {
                level = 0;
            }
        }
        return level;
    }

    protected final void add(Item[] entry, ArchiveOut out, int level, String root, QueryContext qc) throws QueryException, IOException {
        Item header = entry[0];
        Item content = entry[1];
        String name = Token.string(header.string(this.info));
        if (name.isEmpty()) {
            throw QueryError.ARCHIVE_DESCRIPTOR1.get(this.info, new Object[0]);
        }
        if (Prop.WIN) {
            name = name.replace('\\', '/');
        }
        ZipEntry ze = new ZipEntry(root + name);
        String encoding = "UTF-8";
        byte[] lvl = null;
        if (header instanceof ANode) {
            byte[] ea;
            ANode el = (ANode)header;
            lvl = el.attribute(ArchiveText.LEVEL);
            byte[] mod = el.attribute(ArchiveText.LAST_MODIFIED);
            if (mod != null) {
                try {
                    ze.setTime(this.dateTimeToMs(new Dtm(mod, this.info), qc));
                }
                catch (QueryException qe) {
                    Util.debug(qe);
                    throw QueryError.ARCHIVE_DESCRIPTOR3_X.get(this.info, new Object[]{mod});
                }
            }
            if ((ea = el.attribute(ArchiveText.ENCODING)) != null && !Charset.isSupported(encoding = Strings.normEncoding(Token.string(ea)))) {
                throw QueryError.ARCHIVE_ENCODE1_X.get(this.info, new Object[]{ea});
            }
        }
        byte[] value = this.toBytes(content);
        if (!(content instanceof Bin) && encoding != "UTF-8") {
            value = this.encode(value, encoding, qc);
        }
        try {
            out.level(lvl == null ? level : Token.toInt(lvl));
        }
        catch (IllegalArgumentException ex) {
            Util.debug(ex);
            throw QueryError.ARCHIVE_DESCRIPTOR2_X.get(this.info, new Object[]{lvl});
        }
        out.write(ze, value);
    }

    final Map<String, Item[]> toMap(int i, QueryContext qc) throws QueryException {
        Iter entries = this.exprs[i].iter(qc);
        Iter contents = this.exprs[i + 1].iter(qc);
        LinkedHashMap<String, Item[]> map = new LinkedHashMap<String, Item[]>();
        int e = 0;
        int c = 0;
        while (true) {
            Item en = qc.next(entries);
            Item cn = contents.next();
            if (en == null || cn == null) {
                if (cn != null) {
                    do {
                        ++c;
                    } while (contents.next() != null);
                }
                if (en != null) {
                    do {
                        ++e;
                    } while (entries.next() != null);
                }
                if (e == c) break;
                throw QueryError.ARCHIVE_NUMBER_X_X.get(this.info, e, c);
            }
            map.put(Token.string(this.checkElemToken(en).string(this.info)), new Item[]{en, cn});
            ++e;
            ++c;
        }
        return map;
    }
}

