/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.admin;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.basex.core.users.UserText;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.admin.AdminFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.server.Log;
import org.basex.server.LogEntry;
import org.basex.server.LogFile;
import org.basex.util.Strings;
import org.basex.util.Token;

public final class AdminLogs
extends AdminFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        this.checkAdmin(qc);
        return this.exprs.length == 0 ? this.list(qc).iter() : this.logs(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        this.checkAdmin(qc);
        return this.exprs.length == 0 ? this.list(qc) : this.logs(qc).value(qc, this);
    }

    private Value list(QueryContext qc) {
        ValueBuilder vb = new ValueBuilder(qc);
        for (IOFile file : qc.context.log.files()) {
            String date = file.name().replace(".log", "");
            vb.add(new FElem("file").add(date).add("size", Token.token(file.length())));
        }
        return vb.value(this);
    }

    private Iter logs(QueryContext qc) throws QueryException {
        String name = Token.string(this.toToken(this.exprs[0], qc));
        final boolean merge = this.exprs.length > 1 && this.toBoolean(this.exprs[1], qc);
        final LinkedList<LogEntry> list = this.logs(name, qc);
        final HashMap<String, LinkedList> map = new HashMap<String, LinkedList>();
        if (merge) {
            for (LogEntry entry : list) {
                map.computeIfAbsent(entry.address, address -> new LinkedList()).add(entry);
            }
        }
        return new Iter(){

            @Override
            public Item next() {
                LogEntry entry;
                while ((entry = (LogEntry)list.pollFirst()) != null) {
                    if (merge) {
                        LinkedList entries = (LinkedList)map.get(entry.address);
                        if (entries.peekFirst() != entry) continue;
                        entries.removeFirst();
                        if (entry.type.equals(Log.LogType.REQUEST.name())) {
                            Iterator iter = entries.iterator();
                            while (iter.hasNext()) {
                                LogEntry next = (LogEntry)iter.next();
                                String t = next.type;
                                if (t.equals(Log.LogType.REQUEST.name())) break;
                                if (!t.matches("^\\d+$") && !Strings.eq(t, Log.LogType.OK.name(), Log.LogType.ERROR.name())) continue;
                                entry.type = t;
                                entry.user = next.user;
                                entry.ms = entry.ms.add(next.ms);
                                String msg1 = entry.message;
                                String msg2 = next.message;
                                if (!msg2.isEmpty()) {
                                    entry.message = msg1.isEmpty() ? msg2 : msg1 + "; " + msg2;
                                }
                                iter.remove();
                                break;
                            }
                        }
                    }
                    FElem elem = new FElem("entry");
                    if (entry.message != null) {
                        elem.add(entry.message);
                    }
                    if (entry.address != null) {
                        elem.add("time", entry.time).add("address", entry.address).add(UserText.USER, entry.user);
                        if (entry.type != null) {
                            elem.add("type", entry.type);
                        }
                        if (entry.ms != BigDecimal.ZERO) {
                            elem.add("ms", entry.ms.toString());
                        }
                    }
                    return elem;
                }
                return null;
            }
        };
    }

    private LinkedList<LogEntry> logs(String name, QueryContext qc) throws QueryException {
        Log log = qc.context.log;
        LogFile file = log.file(name);
        if (file == null) {
            throw QueryError.WHICHRES_X.get(this.info, name);
        }
        try {
            LinkedList<LogEntry> logs = new LinkedList<LogEntry>();
            for (String line : file.read()) {
                qc.checkStop();
                LogEntry entry = new LogEntry();
                String[] cols = line.split("\t");
                if (cols.length > 2) {
                    int i;
                    entry.time = cols[0];
                    entry.address = cols[1];
                    entry.user = cols[2];
                    entry.type = cols.length > 3 ? cols[3] : "";
                    entry.message = cols.length > 4 ? cols[4] : "";
                    entry.ms = BigDecimal.ZERO;
                    if (cols.length > 5 && (i = cols[5].indexOf(" ms")) > -1) {
                        entry.ms = new BigDecimal(cols[5].substring(0, i));
                    }
                } else {
                    entry.message = line;
                }
                logs.add(entry);
            }
            return logs;
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }
}

