/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.basex.core.Databases;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInput;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncDefinition;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.xquery.XQueryEval;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;
import org.basex.util.options.Options;
import org.basex.util.similarity.Levenshtein;

public abstract class StandardFunc
extends Arr {
    public static final int UNROLL_LIMIT = 5;
    public FuncDefinition definition;
    public StaticContext sc;
    private Data data;

    protected StandardFunc() {
        super(null, SeqType.ITEM_ZM, new Expr[0]);
    }

    final void init(StaticContext sctx, InputInfo ii, FuncDefinition df, Expr[] args) {
        this.sc = sctx;
        this.info = ii;
        this.definition = df;
        this.exprs = args;
        this.exprType.assign(df.seqType);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        this.simplifyArgs(cc);
        Expr expr = this.opt(cc);
        return expr != this ? cc.replaceWith(this, expr) : (this.allAreValues(this.definition.seqType.occ.max > 1L) && this.isSimple() ? cc.preEval(this) : this);
    }

    protected void simplifyArgs(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            int p = Math.min(e, this.definition.params.length - 1);
            Type type = this.definition.params[p].type;
            if (!type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) continue;
            CompileContext.Simplify mode = type.instanceOf(AtomType.NUMERIC) ? CompileContext.Simplify.NUMBER : CompileContext.Simplify.STRING;
            this.exprs[e] = this.exprs[e].simplifyFor(mode, cc);
        }
    }

    protected Expr opt(CompileContext cc) throws QueryException {
        return this;
    }

    @Override
    public final StandardFunc copy(CompileContext cc, IntObjMap<Var> vm) {
        int el = this.exprs.length;
        Expr[] arg = new Expr[el];
        for (int e = 0; e < el; ++e) {
            arg[e] = this.exprs[e].copy(cc, vm);
        }
        return this.copyType(this.definition.get(this.sc, this.info, arg));
    }

    protected final Expr optFirst() {
        return this.optFirst(true, true, null);
    }

    protected final Expr optFirst(boolean occ, boolean atom, Value value) {
        Value expr;
        Expr expr2 = expr = this.exprs.length > 0 ? this.exprs[0] : value;
        if (expr != null) {
            SeqType st = expr.seqType();
            if (st.zero()) {
                return expr;
            }
            if (occ && st.oneOrMore() && (!atom || !st.mayBeArray())) {
                this.exprType.assign(Occ.EXACTLY_ONE);
            }
        }
        return this;
    }

    protected final byte[] serialize(Iter iter, SerializerOptions opts, QueryError err, QueryContext qc) throws QueryException {
        try {
            ArrayOutput ao = new ArrayOutput();
            try (Serializer ser = Serializer.get(ao, opts);){
                Item item;
                while ((item = qc.next(iter)) != null) {
                    ser.serialize(item);
                }
            }
            return new TokenBuilder(ao.finish()).normalize().finish();
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        catch (IOException ex) {
            throw err.get(this.info, ex);
        }
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Flag flag : flags) {
            if (!this.definition.has(flag)) continue;
            return true;
        }
        if (Flag.UPD.in(flags) && this.sc.mixUpdates && this.definition.has(Flag.HOF)) {
            return true;
        }
        Flag[] flgs = Flag.HOF.remove(flags);
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public boolean vacuous() {
        return this.size() == 0L && !this.has(Flag.UPD);
    }

    public final Expr coerceFunc(Expr expr, CompileContext cc, SeqType declType, SeqType ... argTypes) throws QueryException {
        if (!(expr instanceof FuncItem)) {
            return expr;
        }
        FuncItem func = (FuncItem)expr;
        int al = argTypes.length;
        int fargs = func.arity();
        if (fargs != al) {
            return expr;
        }
        FuncType oldType = func.funcType();
        SeqType[] oldArgs = oldType.argTypes;
        SeqType[] newArgs = new SeqType[al];
        for (int a = 0; a < al; ++a) {
            newArgs[a] = argTypes[a].instanceOf(oldArgs[a]) ? argTypes[a] : oldArgs[a];
        }
        SeqType newDecl = declType.instanceOf(oldType.declType) ? declType : oldType.declType;
        FuncType newType = FuncType.get(newDecl, newArgs);
        return !newType.eq(oldType) ? func.coerceTo(newType, cc.qc, this.info, true) : expr;
    }

    protected final Expr compileData(CompileContext cc) throws QueryException {
        if (this.exprs.length > 0 && this.exprs[0] instanceof Value) {
            this.data = this.checkData(cc.qc);
            cc.info("open database \"%\"", this.data.meta.name);
        }
        return this;
    }

    @Override
    public final Data data() {
        return this.data;
    }

    @Override
    public final void data(Data dt) {
        this.data = dt;
    }

    protected final ADate toDate(Item item, AtomType type, QueryContext qc) throws QueryException {
        return (ADate)(item.type.isUntyped() ? type.cast(item, qc, this.sc, this.info) : this.checkType(item, type));
    }

    protected final DBNode toDBNode(Item item) throws QueryException {
        if (this.checkNoEmpty(item, NodeType.NODE) instanceof DBNode) {
            return (DBNode)item;
        }
        throw QueryError.DB_NODE_X.get(this.info, item);
    }

    protected final Collation toCollation(int i, QueryContext qc) throws QueryException {
        byte[] coll = i >= this.exprs.length ? null : this.toToken(this.exprs[i], qc);
        return Collation.get(coll, qc, this.sc, this.info, QueryError.WHICHCOLL_X);
    }

    protected final Path toPath(int i, QueryContext qc) throws QueryException {
        return this.toPath(this.toToken(this.exprs[i], qc));
    }

    protected final Path toPath(byte[] path) throws QueryException {
        try {
            String p = Token.string(path);
            return p.startsWith("file:/") ? Paths.get(new URI(p)) : Paths.get(p, new String[0]);
        }
        catch (URISyntaxException | InvalidPathException ex) {
            Util.debug(ex);
            throw QueryError.FILE_INVALID_PATH_X.get(this.info, new Object[]{QueryError.normalize(path, this.info)});
        }
    }

    protected final IO checkPath(int i, QueryContext qc) throws QueryException {
        return this.checkPath(this.toToken(this.exprs[i], qc));
    }

    protected final IO checkPath(byte[] uri) throws QueryException {
        QueryInput qi = new QueryInput(Token.string(uri), this.sc);
        if (qi.io.exists()) {
            return qi.io;
        }
        throw QueryError.WHICHRES_X.get(this.info, new Object[]{QueryError.normalize(uri, this.info)});
    }

    protected final IOContent toQuery(int i, QueryContext qc) throws QueryException {
        Item item = this.toItem(this.exprs[i], qc);
        return item instanceof Uri ? this.toQuery(item.string(this.info), qc) : new IOContent(this.toToken(item));
    }

    protected final IOContent toQuery(byte[] uri, QueryContext qc) throws QueryException {
        this.checkAdmin(qc);
        IO io = this.checkPath(uri);
        try {
            return new IOContent(io.read(), io.url());
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    protected final String toBaseUri(String path, Options options) {
        String base = options.get(XQueryEval.XQueryOptions.BASE_URI);
        return base != null && !base.isEmpty() ? base : (path != null && !path.isEmpty() ? path : Token.string(this.sc.baseURI().string()));
    }

    protected final String toEncodingOrNull(int i, QueryError err, QueryContext qc) throws QueryException {
        if (i >= this.exprs.length) {
            return null;
        }
        byte[] encoding = this.toToken(this.exprs[i], qc);
        try {
            String enc = Token.string(this.toToken(this.exprs[i], qc));
            if (Charset.isSupported(enc)) {
                return Strings.normEncoding(enc);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw err.get(this.info, new Object[]{QueryError.similar(encoding, Levenshtein.similar(encoding, Strings.encodings()))});
    }

    protected final Item toNodeOrAtomItem(int i, QueryContext qc) throws QueryException {
        Item item = this.toItem(this.exprs[i], qc);
        return item instanceof ANode ? item : item.atomItem(qc, this.info);
    }

    protected final <E extends Options> E toOptions(int i, E opts, QueryContext qc) throws QueryException {
        return i >= this.exprs.length ? opts : new FuncOptions(this.info).assign(this.exprs[i].item(qc, this.info), opts);
    }

    protected final HashMap<String, Value> toBindings(int i, QueryContext qc) throws QueryException {
        HashMap<String, Value> hm = new HashMap<String, Value>();
        int el = this.exprs.length;
        if (i < el) {
            Item item = this.exprs[i].item(qc, this.info);
            XQMap map = item == Empty.VALUE ? XQMap.EMPTY : this.toMap(item);
            for (Item it : map.keys()) {
                byte[] key;
                if (it.type.isStringOrUntyped()) {
                    key = it.string(null);
                } else {
                    QNm qnm = this.toQNm(it, false);
                    TokenBuilder tb = new TokenBuilder();
                    if (qnm.uri() != null) {
                        tb.add(123).add(qnm.uri()).add(125);
                    }
                    key = tb.add(qnm.local()).finish();
                }
                hm.put(Token.string(key), map.get(it, this.info));
            }
        }
        return hm;
    }

    protected final Data checkData(QueryContext qc) throws QueryException {
        if (this.data != null) {
            return this.data;
        }
        String name = Token.string(this.toToken(this.exprs[0], qc));
        if (!Databases.validName(name)) {
            throw QueryError.INVDB_X.get(this.info, name);
        }
        return qc.resources.database(name, this.info);
    }

    protected final void checkAdmin(QueryContext qc) throws QueryException {
        this.checkPerm(qc, Perm.ADMIN);
    }

    protected final void checkCreate(QueryContext qc) throws QueryException {
        this.checkPerm(qc, Perm.CREATE);
    }

    private void checkPerm(QueryContext qc, Perm perm) throws QueryException {
        if (!qc.context.user().has(perm)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(this.info, new Object[]{perm, this});
        }
    }

    protected final FItem checkArity(Expr expr, int nargs, QueryContext qc) throws QueryException {
        return this.checkArity(expr, nargs, false, qc);
    }

    protected final FItem checkArity(Expr expr, int nargs, boolean updating, QueryContext qc) throws QueryException {
        FItem func = this.checkUp(this.toFunc(expr, qc), updating, this.sc);
        int fargs = func.arity();
        if (fargs == nargs) {
            return func;
        }
        throw QueryError.FUNARITY_X_X.get(this.info, QueryError.arguments(fargs), nargs);
    }

    protected final long dateTimeToMs(Expr expr, QueryContext qc) throws QueryException {
        Dtm dtm = (Dtm)this.checkType(expr, qc, AtomType.DATE_TIME);
        if (dtm.yea() > 292278993L) {
            throw QueryError.INTRANGE_X.get(this.info, dtm.yea());
        }
        return dtm.toJava().toGregorianCalendar().getTimeInMillis();
    }

    protected final boolean dataLock(ASTVisitor visitor, int i) {
        String db = this.exprs[i] instanceof Str ? Token.string(((Str)this.exprs[i]).string()) : null;
        return visitor.lock(db, false);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof StandardFunc && this.definition == ((StandardFunc)obj).definition && super.equals(obj);
    }

    @Override
    public final String description() {
        return this.definition.toString();
    }

    @Override
    public final void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.definition.id()), this.exprs);
    }

    @Override
    public final void plan(QueryString qs) {
        qs.token(this.definition.id()).params(this.exprs);
    }
}

