/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.data.Data;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class NameTest
extends Test {
    public final QNm qname;
    public final NamePart part;
    public final byte[] local;
    private final byte[] defaultNs;
    private boolean simple;

    public NameTest(QNm name) {
        this(name, NamePart.FULL, NodeType.ELEMENT, null);
    }

    public NameTest(QNm qname, NamePart part, NodeType type, byte[] defaultNs) {
        super(type);
        this.qname = qname;
        this.part = part;
        this.defaultNs = defaultNs != null ? defaultNs : Token.EMPTY;
        this.local = qname.local();
    }

    @Override
    public boolean noMatches(Data data) {
        if (data == null) {
            return false;
        }
        byte[] dataNs = data.defaultNs();
        if (dataNs == null) {
            return false;
        }
        if (this.part == NamePart.FULL && !this.qname.hasURI()) {
            if (this.type != NodeType.ATTRIBUTE && !Token.eq(dataNs, this.defaultNs)) {
                return true;
            }
            this.simple = true;
        }
        return this.type != NodeType.PROCESSING_INSTRUCTION && this.part() == NamePart.LOCAL && !(this.type == NodeType.ELEMENT ? data.elemNames : data.attrNames).contains(this.local);
    }

    @Override
    public Test copy() {
        return this;
    }

    @Override
    public boolean matches(ANode node) {
        if (node.type != this.type) {
            return false;
        }
        switch (this.part()) {
            case LOCAL: {
                return Token.eq(this.local, Token.local(node.name()));
            }
            case URI: {
                return Token.eq(this.qname.uri(), node.qname().uri());
            }
        }
        return this.qname.eq(node.qname());
    }

    public boolean matches(QNm qName) {
        switch (this.part()) {
            case LOCAL: {
                return Token.eq(this.local, qName.local());
            }
            case URI: {
                return Token.eq(this.qname.uri(), qName.uri());
            }
        }
        return this.qname.eq(qName);
    }

    public NamePart part() {
        return this.simple ? NamePart.LOCAL : this.part;
    }

    @Override
    public boolean instanceOf(Test test) {
        if (test instanceof NameTest) {
            NameTest nt = (NameTest)test;
            return this.type == nt.type && this.part == nt.part && this.qname.eq(nt.qname);
        }
        return super.instanceOf(test);
    }

    @Override
    public Test intersect(Test test) {
        if (test instanceof NameTest) {
            NameTest nt = (NameTest)test;
            return this.type == nt.type && this.qname.eq(nt.qname) ? this : null;
        }
        if (test instanceof KindTest) {
            return this.type.instanceOf(test.type) ? this : null;
        }
        if (test instanceof UnionTest) {
            return test.intersect(this);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NameTest)) {
            return false;
        }
        NameTest nt = (NameTest)obj;
        return this.type == nt.type && this.part == nt.part && this.qname.eq(nt.qname);
    }

    @Override
    public String toString(boolean full) {
        boolean pi = this.type == NodeType.PROCESSING_INSTRUCTION;
        TokenBuilder tb = new TokenBuilder();
        byte[] prefix = this.qname.prefix();
        byte[] uri = this.qname.uri();
        if (this.part == NamePart.LOCAL && !pi) {
            if (!full || this.type != NodeType.ATTRIBUTE) {
                tb.add("*:");
            }
        } else if (prefix.length > 0) {
            tb.add(prefix).add(58);
        } else if (uri.length != 0) {
            tb.add("Q{").add(uri).add(125);
        }
        if (this.part == NamePart.URI) {
            tb.add(42);
        } else {
            tb.add(this.qname.local());
        }
        String test = tb.toString();
        return full || pi ? this.type.toString(test) : test;
    }
}

