/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.query.expr.path.DocTest;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Util;

public class KindTest
extends Test {
    public static final KindTest DOC = new KindTest(NodeType.DOCUMENT_NODE);
    public static final KindTest ELM = new KindTest(NodeType.ELEMENT){

        @Override
        public String toString(boolean full) {
            return full ? this.type.toString() : "*";
        }
    };
    public static final KindTest ATT = new KindTest(NodeType.ATTRIBUTE);
    public static final KindTest PI = new KindTest(NodeType.PROCESSING_INSTRUCTION);
    public static final KindTest TXT = new KindTest(NodeType.TEXT);
    public static final KindTest COM = new KindTest(NodeType.COMMENT);
    public static final KindTest NSP = new KindTest(NodeType.NAMESPACE_NODE);
    public static final KindTest NOD = new KindTest(NodeType.NODE){

        @Override
        public boolean matches(ANode node) {
            return true;
        }

        @Override
        public boolean instanceOf(Test test) {
            return false;
        }

        @Override
        public Test intersect(Test test) {
            return test;
        }
    };

    KindTest(NodeType type) {
        super(type);
    }

    public static KindTest get(NodeType type) {
        switch (type) {
            case TEXT: {
                return TXT;
            }
            case PROCESSING_INSTRUCTION: {
                return PI;
            }
            case ELEMENT: {
                return ELM;
            }
            case DOCUMENT_NODE: {
                return DOC;
            }
            case ATTRIBUTE: {
                return ATT;
            }
            case COMMENT: {
                return COM;
            }
            case NODE: {
                return NOD;
            }
            case NAMESPACE_NODE: {
                return NSP;
            }
        }
        throw Util.notExpected();
    }

    @Override
    public final KindTest copy() {
        return this;
    }

    @Override
    public boolean matches(ANode node) {
        return node.type == this.type;
    }

    @Override
    public boolean instanceOf(Test test) {
        return (test instanceof KindTest || test instanceof UnionTest) && super.instanceOf(test);
    }

    @Override
    public Test intersect(Test test) {
        if (test instanceof KindTest) {
            return this.instanceOf(test) ? this : (test.instanceOf(this) ? test : null);
        }
        if (test instanceof NameTest || test instanceof DocTest) {
            return test.instanceOf(this) ? test : null;
        }
        if (test instanceof UnionTest) {
            return test.intersect(this);
        }
        return null;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public String toString(boolean full) {
        return this.type.toString();
    }
}

