/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Union;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.PathCache;
import org.basex.query.expr.path.Step;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.util.InputInfo;

public abstract class AxisPath
extends Path {
    AxisPath(InputInfo info, Expr root, Expr ... steps) {
        super(info, NodeType.NODE, root, steps);
    }

    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        Value result = this.cache(qc);
        return result != null ? result.iter() : this.iterator(qc);
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        Value result = this.cache(qc);
        return result != null ? result : this.nodes(qc);
    }

    private Value cache(QueryContext qc) throws QueryException {
        PathCache cache = qc.threads.get(this).get();
        switch (cache.state) {
            case INIT: {
                cache.state = !this.hasFreeVars() && !this.has(Flag.NDT) ? PathCache.State.ENABLED : PathCache.State.DISABLED;
                return this.cache(qc);
            }
            case ENABLED: {
                Value value = qc.focus.value;
                cache.initial = value instanceof DBNode ? ((DBNode)value).finish() : value;
                cache.state = PathCache.State.READY;
                break;
            }
            case READY: {
                if (cache.sameContext(qc.focus.value, this.root)) {
                    cache.result = this.iterator(qc).value(qc, this);
                    cache.state = PathCache.State.CACHED;
                    break;
                }
                cache.state = PathCache.State.DISABLED;
                break;
            }
            case CACHED: {
                if (cache.sameContext(qc.focus.value, this.root)) break;
                cache.result = null;
                cache.state = PathCache.State.DISABLED;
                break;
            }
        }
        return cache.result;
    }

    protected abstract Iter iterator(QueryContext var1) throws QueryException;

    protected abstract Value nodes(QueryContext var1) throws QueryException;

    public final Step step(int index) {
        return (Step)this.steps[index];
    }

    public final Expr addPredicates(CompileContext cc, Expr ... preds) throws QueryException {
        ExprList list = (ExprList)new ExprList(this.steps.length).add(this.steps);
        Step step = ((Step)list.pop()).addPredicates(preds);
        list.add(cc.get(step, () -> step.optimize(this.root, cc)));
        this.exprType.assign(this.seqType().union(Occ.ZERO));
        return this.copyType(AxisPath.get(cc, this.info, this.root, (Expr[])list.finish()));
    }

    @Override
    public final Expr mergeEbv(Expr expr, boolean or, CompileContext cc) throws QueryException {
        return or && expr instanceof AxisPath ? new Union(this.info, this, expr).optimize(cc) : null;
    }

    @Override
    public final boolean ddo() {
        return true;
    }

    @Override
    public final Data data() {
        return this.data;
    }

    @Override
    public final void data(Data dt) {
        this.data = dt;
    }
}

