/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.type.NodeType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class IndexDynDb
extends IndexDb {
    private Expr expr;

    public IndexDynDb(Expr expr, InputInfo info) {
        super(info);
        this.expr = expr;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public Expr compile(CompileContext cc) {
        return this;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.expr.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.expr.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.expr.count(var);
    }

    @Override
    public IndexDb inline(InlineContext ic) throws QueryException {
        Expr inlined = this.expr.inline(ic);
        if (inlined == null) {
            return null;
        }
        this.expr = inlined;
        return this;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize() + 1;
    }

    @Override
    public IndexDynDb copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new IndexDynDb(this.expr.copy(cc, vm), this.info));
    }

    @Override
    Data data(QueryContext qc) throws QueryException {
        Value value = this.expr.value(qc);
        Data data = value.data();
        if (data == null || !value.seqType().type.instanceOf(NodeType.DOCUMENT_NODE)) {
            throw QueryError.DB_NODE_X.get(this.info, value);
        }
        return data;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IndexDynDb && this.expr.equals(((IndexDynDb)obj).expr) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        qs.function(Function._DB_NAME, this.expr);
    }
}

