/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class GroupSpec
extends Single {
    public final Var var;
    public boolean occluded;
    final Collation coll;

    public GroupSpec(InputInfo info, Var var, Expr expr, Collation coll) {
        super(info, expr, SeqType.ITEM_ZM);
        this.var = var;
        this.coll = coll;
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        return this.expr.atomItem(qc, ii);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        GroupSpec spec = new GroupSpec(this.info, cc.copy(this.var, vm), this.expr.copy(cc, vm), this.coll);
        spec.occluded = this.occluded;
        return this.copyType(spec);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public GroupSpec optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.DATA, cc);
        this.exprType.assign(this.expr);
        AtomType type = this.expr.seqType().type.atomic();
        if (type != null) {
            this.var.refineType(SeqType.get(type, this.seqType().occ), cc);
        }
        return this;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && visitor.declared(this.var);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupSpec)) {
            return false;
        }
        GroupSpec gs = (GroupSpec)obj;
        return this.var.equals(gs.var) && this.occluded == gs.occluded && Objects.equals(this.coll, gs.coll) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.attachVariable(plan.create(this, new Object[0]), this.var, false), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.var).token(":=").token(this.expr);
        if (this.coll != null) {
            qs.token("collation").token("\"").token(this.coll.uri()).token('\"');
        }
    }
}

