/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTAnd;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.util.index.IndexCosts;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class FTOr
extends FTExpr {
    public FTOr(InputInfo info, FTExpr[] exprs) {
        super(info, exprs);
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        super.compile(cc);
        boolean not = true;
        for (FTExpr expr : this.exprs) {
            not &= expr instanceof FTNot;
        }
        if (not) {
            int el = this.exprs.length;
            for (int e = 0; e < el; ++e) {
                this.exprs[e] = this.exprs[e].exprs[0];
            }
            return (FTExpr)cc.replaceWith(this, new FTNot(this.info, (FTExpr)new FTAnd(this.info, this.exprs)));
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        FTNode item = this.exprs[0].item(qc, this.info);
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            FTOr.or(item, this.exprs[e].item(qc, this.info));
        }
        return item;
    }

    @Override
    public FTIter iter(QueryContext qc) throws QueryException {
        final int el = this.exprs.length;
        final FTIter[] iters = new FTIter[el];
        final FTNode[] nodes = new FTNode[el];
        for (int e = 0; e < el; ++e) {
            iters[e] = this.exprs[e].iter(qc);
            nodes[e] = iters[e].next();
        }
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                int p = -1;
                for (int e = 0; e < el; ++e) {
                    if (nodes[e] == null || p != -1 && nodes[p].pre() <= nodes[e].pre()) continue;
                    p = e;
                }
                if (p == -1) {
                    return null;
                }
                FTNode item = nodes[p];
                for (int e = 0; e < el; ++e) {
                    if (nodes[e] == null || p == e || item.pre() != nodes[e].pre()) continue;
                    FTOr.or(item, nodes[e]);
                    nodes[e] = iters[e].next();
                }
                nodes[p] = iters[p].next();
                return item;
            }
        };
    }

    private static void or(FTNode i1, FTNode i2) {
        FTMatches all1 = i1.matches();
        FTMatches all2 = i2.matches();
        FTMatches all = new FTMatches((byte)Math.max(all1.pos, all2.pos));
        for (FTMatch m : all1) {
            all.add(m);
        }
        for (FTMatch m : all2) {
            all.add(m);
        }
        i1.score(Scoring.avg(i1.score() + i2.score(), 2));
        i1.matches(all);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        for (FTExpr expr : this.exprs) {
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            costs = IndexCosts.add(costs, ii.costs);
        }
        ii.costs = costs;
        return true;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new FTOr(this.info, (FTExpr[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTOr && super.equals(obj);
    }

    @Override
    public void plan(QueryString qs) {
        qs.tokens(this.exprs, " ftor ", true);
    }
}

