/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.Or;
import org.basex.query.expr.Set;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Union
extends Set {
    public Union(InputInfo info, Expr ... exprs) {
        super(info, exprs);
    }

    @Override
    Expr opt(CompileContext cc) throws QueryException {
        this.flatten(cc);
        SeqType st = null;
        for (Expr expr : this.exprs) {
            SeqType st2 = expr.seqType();
            if (st2.zero()) continue;
            st = st == null ? st2 : st.union(st2);
        }
        if (st == null) {
            st = SeqType.NODE_ZM;
        }
        if (st.type instanceof NodeType) {
            this.exprType.assign(st.union(Occ.ONE_OR_MORE));
            ExprList list = new ExprList(this.exprs.length);
            for (Expr expr : this.exprs) {
                if (expr == Empty.VALUE || list.contains(expr) && !expr.has(Flag.CNS, Flag.NDT)) {
                    cc.info("remove % from %", expr, this::description);
                    continue;
                }
                list.add(expr);
            }
            this.exprs = (Expr[])list.finish();
            Expr ex = this.rewrite(Intersect.class, (invert, ops) -> invert != false ? new Intersect(this.info, (Expr[])ops) : new Union(this.info, (Expr)ops), cc);
            if (ex != null) {
                cc.info("rewrite %: %", this::description, ex);
                return ex;
            }
        }
        return null;
    }

    @Override
    Or mergePredicates(Expr[] preds, CompileContext cc) {
        return new Or(this.info, preds);
    }

    @Override
    Value nodes(QueryContext qc) throws QueryException {
        ANodeBuilder nodes = new ANodeBuilder();
        for (Expr expr : this.exprs) {
            Item item;
            Iter iter = expr.iter(qc);
            while ((item = qc.next(iter)) != null) {
                nodes.add(this.toNode(item));
            }
        }
        return nodes.value(this);
    }

    @Override
    NodeIter iterate(QueryContext qc) throws QueryException {
        return new Set.SetIter(qc, this.iters(qc)){

            @Override
            public ANode next() throws QueryException {
                if (this.nodes == null) {
                    int il = this.iter.length;
                    this.nodes = new ANode[il];
                    for (int i = 0; i < il; ++i) {
                        this.next(i);
                    }
                }
                int m = -1;
                int il = this.nodes.length;
                for (int i = 0; i < il; ++i) {
                    int d;
                    if (this.nodes[i] == null) continue;
                    int n = d = m == -1 ? 1 : this.nodes[m].diff(this.nodes[i]);
                    if (d == 0) {
                        this.next(i--);
                        continue;
                    }
                    if (d <= 0) continue;
                    m = i;
                }
                if (m == -1) {
                    return null;
                }
                ANode node = this.nodes[m];
                this.next(m);
                return node;
            }
        };
    }

    @Override
    public Data data() {
        return Union.data(this.exprs);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        Union un = new Union(this.info, Union.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
        un.iterative = this.iterative;
        return this.copyType(un);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Union && super.equals(obj);
    }
}

