/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CachedMap;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cast;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.DualMap;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.ItemMap;
import org.basex.query.expr.IterMap;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.Path;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.func.fn.FnData;
import org.basex.query.func.util.UtilReplicate;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class SimpleMap
extends Arr {
    SimpleMap(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    public static Expr get(CompileContext cc, InputInfo ii, Expr ... exprs) throws QueryException {
        return exprs.length == 1 ? exprs[0] : new CachedMap(ii, exprs).optimize(cc);
    }

    @Override
    public final void checkUp() throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el - 1; ++e) {
            this.checkNoUp(this.exprs[e]);
        }
        this.exprs[el - 1].checkUp();
    }

    @Override
    public boolean vacuous() {
        return this.exprs[this.exprs.length - 1].vacuous();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            Expr expr = this.exprs[e];
            try {
                expr = expr.compile(cc);
            }
            catch (QueryException qe) {
                expr = cc.error(qe, expr);
            }
            if (e == 0) {
                cc.pushFocus(expr);
            } else {
                cc.updateFocus(expr);
            }
            this.exprs[e] = expr;
        }
        cc.removeFocus();
        return this.optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        boolean dual;
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (expr instanceof SimpleMap && !(expr instanceof CachedMap)) {
                list.add(expr.args());
                cc.info("flatten nested %: %", expr, this::description);
                continue;
            }
            list.add(expr);
        }
        if (list.size() != this.exprs.length) {
            return SimpleMap.get(cc, this.info, (Expr[])list.finish());
        }
        this.exprs = (Expr[])list.next();
        long min = 1L;
        long max = 1L;
        boolean item = true;
        for (Expr expr : this.exprs) {
            if (max == 0L) break;
            list.add(expr);
            long es = expr.size();
            if (es == 0L) {
                min = 0L;
                max = 0L;
                continue;
            }
            if (es > 0L) {
                min *= es;
                if (max != -1L) {
                    max *= es;
                }
                if (es <= 1L) continue;
                item = false;
                continue;
            }
            Occ o = expr.seqType().occ;
            if (o.min == 0L) {
                min = 0L;
            }
            if (o.max <= 1L) continue;
            max = -1L;
            item = false;
        }
        if (this.exprs.length != list.size()) {
            this.exprs = (Expr[])list.next();
            cc.info("simplify %: %", this::description, this);
        }
        this.exprType.assign(this.exprs[this.exprs.length - 1].seqType(), new long[]{min, max});
        if (this.size() == 0L && !this.has(Flag.NDT)) {
            return cc.emptySeq(this);
        }
        Expr ex = this.mergePaths(cc);
        if (ex != null) {
            return ex;
        }
        int el = this.exprs.length;
        int e = 0;
        boolean pushed = false;
        for (int n = 1; n < el; ++n) {
            Expr[] next = this.exprs[n];
            Expr merged = this.merge(this.exprs[e], (Expr)next, cc);
            if (merged != null) {
                cc.info("merge: %", merged);
                this.exprs[e] = merged;
            } else if (!(next instanceof ContextValue)) {
                this.exprs[++e] = next;
            }
            if (e <= 0) continue;
            if (pushed) {
                cc.updateFocus(this.exprs[e - 1]);
                continue;
            }
            cc.pushFocus(this.exprs[e - 1]);
            pushed = true;
        }
        if (pushed) {
            cc.removeFocus();
        }
        if (e == 0) {
            return this.exprs[0];
        }
        if (++e != el) {
            this.exprs = Arrays.copyOf(this.exprs, e);
        }
        boolean cached = false;
        for (Expr expr : this.exprs) {
            cached = cached || expr.has(Flag.POS);
        }
        boolean bl = dual = this.exprs.length == 2 && this.exprs[1].seqType().zeroOrOne();
        return this.copyType(cached ? new CachedMap(this.info, this.exprs) : (item ? new ItemMap(this.info, this.exprs) : (dual ? new DualMap(this.info, this.exprs) : new IterMap(this.info, this.exprs))));
    }

    private Expr merge(Expr expr, Expr next, CompileContext cc) throws QueryException {
        if (next instanceof Filter) {
            Filter filter = (Filter)next;
            if (filter.root instanceof ContextValue && !filter.mayBePositional()) {
                return Filter.get(cc, this.info, expr, ((Filter)next).exprs);
            }
        }
        if (!expr.has(Flag.NDT) && !next.has(Flag.POS)) {
            InlineContext ic;
            if (!next.has(Flag.CTX)) {
                Expr count = null;
                if (expr.size() != -1L) {
                    count = Int.get(expr.size());
                } else if (expr instanceof Range && expr.arg(0) == Int.ONE && expr.arg(1).seqType().instanceOf(SeqType.INTEGER_O)) {
                    count = expr.arg(1);
                }
                if (count != null) {
                    return cc.replicate(next, count, this.info);
                }
            }
            if (next instanceof StandardFunc && !next.has(Flag.NDT)) {
                Expr[] args = next.args();
                if (Function._UTIL_REPLICATE.is(next) && ((UtilReplicate)next).singleEval() && args[0] instanceof ContextValue && !args[1].has(Flag.CTX)) {
                    if (Function._UTIL_REPLICATE.is(expr) && ((UtilReplicate)expr).singleEval()) {
                        Expr cnt = new Arith(this.info, expr.arg(1), args[1], Calc.MULT).optimize(cc);
                        return cc.function(Function._UTIL_REPLICATE, this.info, expr.arg(0), cnt);
                    }
                    if (expr instanceof SingletonSeq && ((SingletonSeq)expr).singleItem()) {
                        return cc.function(Function._UTIL_REPLICATE, this.info, expr, args[1]);
                    }
                } else if (Function._UTIL_ITEM.is(next) && !args[0].has(Flag.CTX) && args[1] instanceof ContextValue) {
                    if (expr instanceof RangeSeq) {
                        RangeSeq seq = (RangeSeq)expr;
                        long[] range = seq.range(false);
                        Expr func = cc.function(Function._UTIL_RANGE, this.info, args[0], Int.get(range[0]), Int.get(range[1]));
                        return seq.asc ? func : cc.function(Function.REVERSE, this.info, func);
                    }
                    if (expr instanceof Range) {
                        return cc.function(Function._UTIL_RANGE, this.info, args[0], expr.arg(0), expr.arg(1));
                    }
                } else if (Function.DATA.is(next) && (((FnData)next).contextAccess() || args[0] instanceof ContextValue)) {
                    return cc.function(Function.DATA, this.info, expr);
                }
            }
            if (expr instanceof RangeSeq && next instanceof Arith) {
                boolean minus;
                Arith arith = (Arith)next;
                boolean plus = arith.calc == Calc.PLUS;
                boolean bl = minus = arith.calc == Calc.MINUS;
                if ((plus || minus) && next.arg(0) instanceof ContextValue && next.arg(1) instanceof Int) {
                    RangeSeq seq = (RangeSeq)expr;
                    long diff = ((Int)next.arg(1)).itr();
                    return RangeSeq.get(seq.range(true)[0] + (plus ? diff : -diff), seq.size(), seq.asc);
                }
            }
            Expr input = expr;
            if (Function._UTIL_REPLICATE.is(expr) && ((UtilReplicate)expr).singleEval()) {
                input = expr.arg(0);
            } else if (expr instanceof SingletonSeq && ((SingletonSeq)expr).singleItem()) {
                input = ((SingletonSeq)expr).itemAt(0L);
            }
            if (input.size() == 1L && (ic = new InlineContext(null, input, cc)).inlineable(next)) {
                Expr ex;
                try {
                    ex = ic.inline(next);
                }
                catch (QueryException qe) {
                    ex = cc.error(qe, next);
                }
                return expr == input ? ex : cc.replicate(ex, Int.get(expr.size()), this.info);
            }
        }
        if (expr.seqType().zeroOrOne()) {
            boolean inline = false;
            if (next instanceof Cast) {
                Cast cast = (Cast)next;
                inline = cast.expr instanceof ContextValue && cast.seqType.occ == Occ.ZERO_OR_ONE;
            } else if (next instanceof ContextFn) {
                inline = ((ContextFn)next).inlineable();
            }
            if (inline) {
                try {
                    InlineContext ic = new InlineContext(null, expr, cc);
                    return ic.inline(next);
                }
                catch (QueryException qe) {
                    return cc.error(qe, next);
                }
            }
        }
        return null;
    }

    private Expr mergePaths(CompileContext cc) throws QueryException {
        if (!this.exprs[0].ddo()) {
            return null;
        }
        Expr root = this.exprs[0];
        ExprList steps = (ExprList)new ExprList().add(new Expr[0]);
        if (root instanceof AxisPath) {
            AxisPath ap = (AxisPath)root;
            root = ap.root;
            steps.add(ap.steps);
        }
        int el = this.exprs.length;
        int e = 0;
        while (++e < el && this.exprs[e] instanceof AxisPath) {
            AxisPath path2 = (AxisPath)this.exprs[e];
            if (path2.root != null || !path2.simple()) break;
            steps.add(path2.steps);
        }
        if (e == 1) {
            return null;
        }
        Expr path = Path.get(cc, this.info, root, (Expr[])steps.finish());
        if (e == el) {
            return path;
        }
        ExprList list = (ExprList)((Object)new ExprList(el - e + 1).add(path));
        while (e < el) {
            list.add(this.exprs[e]);
            ++e;
        }
        return SimpleMap.get(cc, this.info, (Expr[])list.finish());
    }

    @Override
    public Data data() {
        return this.exprs[this.exprs.length - 1].data();
    }

    public Expr toPath(CompileContext cc) throws QueryException {
        Expr root = this.exprs[0];
        ExprList steps = new ExprList();
        if (root instanceof AxisPath) {
            AxisPath path = (AxisPath)root;
            root = path.root;
            steps.add(path.steps);
        }
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            if (!(this.exprs[e] instanceof AxisPath)) {
                return this;
            }
            AxisPath path = (AxisPath)this.exprs[e];
            if (path.root != null) {
                return this;
            }
            steps.add(path.steps);
        }
        return cc.replaceWith(this, Path.get(cc, this.info, root, (Expr[])steps.finish()));
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode == CompileContext.Simplify.EBV || mode == CompileContext.Simplify.PREDICATE || mode == CompileContext.Simplify.DISTINCT) {
            expr = this.toPath(cc);
        } else {
            int el = this.exprs.length;
            Expr old = this.exprs[el - 1];
            Expr ex = cc.get(this.exprs[el - 2], () -> old.simplifyFor(mode, cc));
            if (ex != old) {
                ExprList list = (ExprList)((ExprList)new ExprList(el).add(this.exprs)).set(el - 1, ex);
                expr = SimpleMap.get(cc, this.info, (Expr[])list.finish());
            }
        }
        return expr != this ? expr : super.simplifyFor(mode, cc);
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (Flag.CTX.in(flags) && this.exprs[0].has(Flag.CTX)) {
            return true;
        }
        if (Flag.POS.in(flags) && this.exprs[0].has(Flag.POS)) {
            return true;
        }
        Flag[] flgs = Flag.POS.remove(Flag.CTX.remove(flags));
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        visitor.enterFocus();
        if (!SimpleMap.visitAll(visitor, this.exprs)) {
            return false;
        }
        visitor.exitFocus();
        return true;
    }

    @Override
    public final VarUsage count(Var var) {
        VarUsage uses = VarUsage.NEVER;
        if (var != null) {
            int el = this.exprs.length;
            for (int e = 1; e < el && (uses = uses.plus(this.exprs[e].count(var))) != VarUsage.MORE_THAN_ONCE; ++e) {
            }
        }
        return uses == VarUsage.NEVER ? this.exprs[0].count(var) : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public final boolean inlineable(InlineContext ic) {
        if (ic.expr instanceof ContextValue && ic.var != null) {
            int el = this.exprs.length;
            for (int e = 1; e < el; ++e) {
                if (!this.exprs[e].uses(ic.var)) continue;
                return false;
            }
        }
        return this.exprs[0].inlineable(ic);
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        boolean changed = false;
        CompileContext cc = ic.cc;
        int el = ic.var == null ? 1 : this.exprs.length;
        for (int e = 0; e < el; ++e) {
            Expr inlined;
            try {
                inlined = this.exprs[e].inline(ic);
            }
            catch (QueryException qe) {
                inlined = cc.error(qe, this.exprs[e]);
            }
            if (inlined != null) {
                this.exprs[e] = inlined;
                changed = true;
            } else {
                inlined = this.exprs[e];
            }
            if (e == 0) {
                cc.pushFocus(inlined);
                continue;
            }
            cc.updateFocus(inlined);
        }
        cc.removeFocus();
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        int el = this.exprs.length - 1;
        for (int e = 0; e < el; ++e) {
            if (this.exprs[e].seqType().zeroOrOne()) continue;
            return;
        }
        this.exprs[el].markTailCalls(cc);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SimpleMap && super.equals(obj);
    }

    @Override
    public String description() {
        return "simple map";
    }

    @Override
    public void plan(QueryString qs) {
        qs.tokens(this.exprs, " ! ");
    }
}

