/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryFunction;
import org.basex.query.QueryString;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.ft.FTContains;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.SingleIterPath;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public abstract class Preds
extends Arr {
    protected Preds(InputInfo info, SeqType seqType, Expr ... preds) {
        super(info, seqType, preds);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.type(cc.qc.focus.value);
        int el = this.exprs.length;
        if (el != 0) {
            cc.get(this, () -> {
                QueryFocus focus = cc.qc.focus;
                Value init = focus.value;
                for (int e = 0; e < el; ++e) {
                    try {
                        this.exprs[e] = this.exprs[e].compile(cc);
                        continue;
                    }
                    catch (QueryException ex) {
                        this.exprs[e] = cc.error(ex, this.exprs[e]);
                    }
                }
                focus.value = init;
                return null;
            });
        }
        return this.optimize(cc);
    }

    protected abstract void type(Expr var1);

    private boolean exprType(Expr root) {
        boolean exact;
        long max = root.size();
        boolean bl = exact = max != -1L;
        if (!exact) {
            max = Long.MAX_VALUE;
        }
        for (Expr expr : this.exprs) {
            if (Function.LAST.is(expr)) {
                max = Math.min(max, 1L);
                continue;
            }
            if (expr instanceof ItrPos) {
                ItrPos pos = (ItrPos)expr;
                if (max != Long.MAX_VALUE) {
                    max = Math.max(0L, max - pos.min + 1L);
                }
                max = Math.min(max, pos.max - pos.min + 1L);
                continue;
            }
            exact = false;
        }
        this.exprType.assign(root.seqType().union(Occ.ZERO), exact || max == 0L ? max : -1L);
        return max == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean match(Item item, QueryContext qc) throws QueryException {
        QueryFocus qf = qc.focus;
        Value cv = qf.value;
        qf.value = item;
        try {
            for (Expr expr : this.exprs) {
                if (expr.test(qc, this.info) != null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            qf.value = cv;
        }
    }

    protected final boolean simplify(CompileContext cc, Expr root) throws QueryException {
        return cc.ok(root, () -> {
            ExprList list = new ExprList(this.exprs.length);
            for (Expr expr : this.exprs) {
                this.simplify(expr, list, root, cc);
            }
            this.exprs = (Expr[])list.finish();
            return this.optimizeEbv(false, true, cc);
        }) || this.exprType(root);
    }

    private void simplify(Expr pred, ExprList list, Expr root, CompileContext cc) throws QueryException {
        Axis axis;
        if (pred instanceof And && !pred.has(Flag.POS)) {
            cc.info("rewrite to predicate: %", pred);
            for (Expr expr : pred.args()) {
                this.simplify(expr.seqType().mayBeNumber() ? cc.function(Function.BOOLEAN, this.info, expr) : expr, list, root, cc);
            }
            return;
        }
        Expr expr = pred;
        if (expr instanceof CmpG || expr instanceof CmpV) {
            expr = ((Cmp)expr).optPred(root, cc);
        }
        SeqType rst = root.seqType();
        if (expr instanceof SimpleMap) {
            SimpleMap map = (SimpleMap)expr;
            Expr[] mexprs = map.exprs;
            Expr first = mexprs[0];
            Expr second = mexprs[1];
            if ((first instanceof ContextValue || root.equals(first) && root.isSimple() && rst.one()) && !second.has(Flag.POS)) {
                expr = SimpleMap.get(cc, map.info, Arrays.copyOfRange(mexprs, 1, mexprs.length));
            }
        }
        if (expr instanceof Path && rst.type instanceof NodeType) {
            Path path = (Path)expr;
            Expr first = path.root;
            if ((first instanceof ContextValue || root.equals(first) && root.isSimple() && rst.one()) && !path.steps[0].has(Flag.POS)) {
                expr = Path.get(cc, path.info, null, path.steps);
            }
        }
        if (root instanceof Item && !(rst.type instanceof NodeType)) {
            expr = new InlineContext(null, root, cc).inline(expr);
        }
        if ((expr = expr.simplifyFor(CompileContext.Simplify.PREDICATE, cc)) instanceof ANum) {
            expr = ItrPos.get(((ANum)expr).dbl(), this.info);
        }
        if (expr instanceof SingleIterPath) {
            Step predStep = (Step)((Path)expr).steps[0];
            if (predStep.axis == Axis.SELF && !predStep.mayBePositional()) {
                if (root instanceof Step && !this.mayBePositional()) {
                    Step rootStep = (Step)root;
                    Test test = rootStep.test.intersect(predStep.test);
                    if (test != null) {
                        cc.info("merge: %", predStep);
                        rootStep.test = test;
                        list.add(predStep.exprs);
                        return;
                    }
                }
                if (predStep.test instanceof KindTest && predStep.exprs.length == 0 && rst.type.instanceOf(predStep.test.type)) {
                    cc.info("remove % from %", expr, this::description);
                    return;
                }
            }
        }
        if (expr instanceof ContextValue && rst.type instanceof NodeType) {
            cc.info("remove % from %", expr, this::description);
            return;
        }
        if (root instanceof Step && expr instanceof ItrPos && ((axis = ((Step)root).axis) == Axis.SELF || axis == Axis.PARENT)) {
            expr = Bln.get(((ItrPos)expr).min == 1L);
        }
        if (expr instanceof Cmp) {
            Cmp cmp = (Cmp)expr;
            Expr ex = cmp.exprs[1];
            SeqType st = ex.seqType();
            if (cmp.positional() && cmp.opV() == CmpV.OpV.EQ && st.one()) {
                expr = new Cast(cc.sc(), this.info, ex, SeqType.NUMERIC_O).optimize(cc);
            }
        }
        if (Function.POSITION.is(expr)) {
            expr = Bln.TRUE;
        }
        list.add(cc.simplify(pred, expr));
    }

    public final Expr flattenEbv(Expr root, boolean ebv, CompileContext cc) throws QueryException {
        ParseExpr cmp;
        SeqType rst = root.seqType();
        int el = this.exprs.length;
        if (el == 0 || this.mayBePositional() || ebv && !(rst.type instanceof NodeType)) {
            return this;
        }
        Expr pred = this.exprs[el - 1];
        QueryFunction<Expr, Expr> createRoot = r -> el == 1 ? r : Filter.get(cc, this.info, r, Arrays.copyOfRange(this.exprs, 0, el - 1));
        QueryFunction<Expr, Expr> createExpr = e -> e instanceof ContextValue ? (Expr)createRoot.apply(root) : (e instanceof Path ? Path.get(cc, this.info, (Expr)createRoot.apply(root), e) : null);
        if (pred instanceof CmpG) {
            cmp = (CmpG)pred;
            Expr expr1 = createExpr.apply(cmp.exprs[0]);
            Expr expr2 = cmp.exprs[1];
            if (expr1 != null && !expr2.has(Flag.CTX)) {
                return new CmpG(expr1, expr2, cmp.op, cmp.coll, cmp.sc, cmp.info).optimize(cc);
            }
        }
        if (pred instanceof FTContains) {
            cmp = (FTContains)pred;
            Expr expr = createExpr.apply(((FTContains)cmp).expr);
            FTExpr ftexpr = ((FTContains)cmp).ftexpr;
            if (expr != null && !ftexpr.has(Flag.CTX)) {
                return new FTContains(expr, ftexpr, ((FTContains)cmp).info).optimize(cc);
            }
        }
        if (rst.type instanceof NodeType) {
            ContextFn func;
            Expr expr = createExpr.apply(pred);
            if (expr == null && (Function.DATA.is(pred) || Function.STRING.is(pred)) && (func = (ContextFn)pred).contextAccess()) {
                expr = func.simplifyEbv(root, cc);
            }
            if (expr != null) {
                return expr;
            }
        }
        if (rst.zeroOrOne()) {
            return SimpleMap.get(cc, this.info, createRoot.apply(root), pred);
        }
        return this;
    }

    protected static boolean numeric(Expr expr) {
        SeqType st = expr.seqType();
        return st.type.isNumber() && st.zeroOrOne() && expr.isSimple();
    }

    public boolean mayBePositional() {
        for (Expr expr : this.exprs) {
            if (!Preds.mayBePositional(expr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        if (ic.expr instanceof ContextValue && ic.var != null) {
            for (Expr expr : this.exprs) {
                if (!expr.uses(ic.var)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void plan(QueryString qs) {
        for (Expr expr : this.exprs) {
            qs.bracket(expr);
        }
    }
}

