/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.value.item.Bln;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public abstract class Logical
extends Arr {
    Logical(InputInfo info, Expr[] exprs) {
        super(info, SeqType.BOOLEAN_O, exprs);
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            try {
                this.exprs[e] = this.exprs[e].compile(cc);
                continue;
            }
            catch (QueryException qe) {
                if (e == 0) {
                    throw qe;
                }
                this.exprs[e] = cc.error(qe, this.exprs[e]);
            }
        }
        return this.optimize(cc);
    }

    final Expr optimize(CompileContext cc, boolean or) throws QueryException {
        this.simplifyAll(CompileContext.Simplify.EBV, cc);
        if (this.optimizeEbv(or, false, cc)) {
            return cc.replaceWith(this, Bln.get(or));
        }
        int el = this.exprs.length;
        if (el == 0) {
            return Bln.get(!or);
        }
        if (el == 1) {
            return cc.function(Function.BOOLEAN, this.info, this.exprs);
        }
        return this;
    }

    @Override
    public final void markTailCalls(CompileContext cc) {
        Expr last = this.exprs[this.exprs.length - 1];
        if (last.seqType().eq(SeqType.BOOLEAN_O)) {
            last.markTailCalls(cc);
        }
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = false;
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            try {
                Expr inlined = this.exprs[e].inline(ic);
                if (inlined == null) continue;
                this.exprs[e] = inlined;
                changed = true;
                continue;
            }
            catch (QueryException qe) {
                if (e == 0) {
                    throw qe;
                }
                Expr[] nw = new Expr[e + 1];
                Array.copy(this.exprs, e, nw);
                nw[e] = ic.cc.error(qe, this.exprs[e]);
                this.exprs = nw;
                changed = true;
                break;
            }
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.exprs);
    }
}

