/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Union;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.LongList;

public final class List
extends Arr {
    public List(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    public static Expr get(CompileContext cc, InputInfo ii, Expr ... exprs) throws QueryException {
        return exprs.length == 1 ? exprs[0] : new List(ii, exprs).optimize(cc);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkAllUp(this.exprs);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            this.exprs[e] = this.exprs[e].compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.flatten(cc);
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (expr == Empty.VALUE) {
                cc.info("remove % from %", Empty.VALUE, this::description);
                continue;
            }
            list.add(expr);
        }
        this.exprs = (Expr[])list.finish();
        int el = this.exprs.length;
        if (el == 0) {
            return Empty.VALUE;
        }
        int e = 0;
        while (++e < el && this.exprs[e].equals(this.exprs[0])) {
        }
        if (e == el) {
            return el == 1 ? this.exprs[0] : cc.replicate(this.exprs[0], Int.get(el), this.info);
        }
        SeqType st = null;
        Occ occ = Occ.ZERO;
        long size = 0L;
        for (Expr expr : this.exprs) {
            Expr[] st2 = expr.seqType();
            if (!st2.zero()) {
                st = st == null ? st2 : st.union((SeqType)st2);
            }
            long sz = expr.size();
            if (size != -1L) {
                size = sz == -1L ? -1L : size + sz;
            }
            occ = occ.add(st2.occ);
        }
        this.exprType.assign(st != null ? st : SeqType.EMPTY_SEQUENCE_Z, occ, size);
        if (this.allAreValues(true)) {
            Expr range = this.toRange();
            if (range != null) {
                return cc.replaceWith(this, range);
            }
            Type tp = null;
            Value[] values = new Value[el];
            int vl = 0;
            for (Expr expr : this.exprs) {
                cc.qc.checkStop();
                Value value = expr.value(cc.qc);
                if (vl == 0) {
                    tp = value.type;
                } else if (tp != null && !tp.eq(value.type)) {
                    tp = null;
                }
                values[vl++] = value;
            }
            Value value = Seq.get((int)size, tp, values);
            if (value == null) {
                ValueBuilder vb = new ValueBuilder(cc.qc);
                for (int v = 0; v < vl; ++v) {
                    vb.add(values[v]);
                }
                value = vb.value(this);
            }
            return cc.replaceWith(this, value);
        }
        return this;
    }

    private Expr toRange() {
        Long start = null;
        Long end = null;
        for (Expr expr : this.exprs) {
            long e;
            long s;
            if (expr instanceof Int && expr.seqType().type == AtomType.INTEGER) {
                s = ((Int)expr).itr();
                e = s + 1L;
            } else if (expr instanceof RangeSeq) {
                long[] range = ((RangeSeq)expr).range(true);
                e = range[1] + 1L;
                if (e <= (s = range[0])) {
                    return null;
                }
            } else {
                return null;
            }
            if (start == null) {
                start = s;
            } else if (end != s) {
                return null;
            }
            end = e;
        }
        return RangeSeq.get(start, end - start, true);
    }

    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){
            private final int el;
            private final Iter[] iters;
            private long[] offsets;
            private long size;
            private int e;
            {
                this.el = List.this.exprs.length;
                this.iters = new Iter[this.el];
            }

            @Override
            public Item next() throws QueryException {
                while (this.e < this.el) {
                    Item item = qc.next(this.iter(this.e));
                    if (item != null) {
                        return item;
                    }
                    ++this.e;
                }
                return null;
            }

            @Override
            public Item get(long i) throws QueryException {
                int o;
                for (o = 0; o < this.el - 1 && this.offsets[o + 1] <= i; ++o) {
                }
                return this.iter(o).get(i - this.offsets[o]);
            }

            @Override
            public long size() throws QueryException {
                if (this.offsets == null) {
                    this.offsets = new long[this.el];
                    for (int o = 0; o < this.el && this.size != -1L; ++o) {
                        this.offsets[o] = this.size;
                        long s = this.iter(o).size();
                        this.size = s == -1L || this.size + s < 0L ? -1L : this.size + s;
                    }
                }
                return this.size;
            }

            private Iter iter(int i) throws QueryException {
                Iter iter = this.iters[i];
                if (iter == null) {
                    this.iters[i] = iter = List.this.exprs[i].iter(qc);
                }
                return iter;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        if (this.exprs.length == 2) {
            return ValueBuilder.concat(this.exprs[0].value(qc), this.exprs[1].value(qc), qc);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Expr expr : this.exprs) {
            vb.add(expr.value(qc));
        }
        return vb.value(this);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr expr = this;
        if (mode == CompileContext.Simplify.EBV || mode == CompileContext.Simplify.PREDICATE) {
            expr = this.toUnion(cc);
        } else if (mode == CompileContext.Simplify.DISTINCT) {
            int el = this.exprs.length;
            ExprList list = new ExprList(el);
            for (Expr ex : this.exprs) {
                list.addUnique(ex.simplifyFor(mode, cc));
            }
            this.exprs = (Expr[])list.finish();
            expr = this.exprs.length != el ? cc.simplify(this, List.get(cc, this.info, this.exprs)) : (this.seqType().type == AtomType.INTEGER ? this.toDistinctRange() : this.toUnion(cc));
        } else if (this.simplifyAll(mode, cc)) {
            expr = this.optimize(cc);
        }
        return expr == this ? super.simplifyFor(mode, cc) : expr.simplifyFor(mode, cc);
    }

    public Expr toUnion(CompileContext cc) throws QueryException {
        return this.seqType().type instanceof NodeType ? cc.replaceWith(this, new Union(this.info, this.exprs)).optimize(cc) : this;
    }

    public Expr toDistinctRange() {
        long start = 0L;
        long end = 0L;
        LongList list = new LongList(2L);
        for (Expr ex : this.exprs) {
            if (ex instanceof Int) {
                list.add(((Int)ex).itr());
            } else if (ex instanceof RangeSeq) {
                list.add(((RangeSeq)ex).range(false));
            } else {
                return this;
            }
            long mn = list.get(0);
            long mx = list.peek() + 1L;
            if (start == end) {
                start = mn;
                end = mx;
            } else {
                if (mn < start - 1L || mx > end + 1L) {
                    return this;
                }
                if (mn == start - 1L) {
                    start = mn;
                }
                if (mx == end + 1L) {
                    end = mx;
                }
            }
            list.reset();
        }
        return RangeSeq.get(start, end - start, true);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new List(this.info, List.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public Data data() {
        return List.data(this.exprs);
    }

    @Override
    public boolean vacuous() {
        return ((Checks<Expr>)Expr::vacuous).all((Expr[])this.exprs);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof List && super.equals(obj);
    }

    @Override
    public String description() {
        return "list";
    }

    @Override
    public void plan(QueryString qs) {
        qs.params(this.exprs);
    }
}

