/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Set;
import org.basex.query.expr.Union;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Intersect
extends Set {
    public Intersect(InputInfo info, Expr[] exprs) {
        super(info, exprs);
    }

    @Override
    Expr opt(CompileContext cc) throws QueryException {
        this.flatten(cc);
        SeqType st = null;
        for (Expr expr : this.exprs) {
            SeqType st2 = expr.seqType();
            if (st2.zero()) continue;
            SeqType seqType = st = st == null ? st2 : st.intersect(st2);
            if (st != null) continue;
            return null;
        }
        if (st == null) {
            st = SeqType.NODE_ZM;
        }
        if (st.type instanceof NodeType) {
            this.exprType.assign(st.union(Occ.ZERO));
            ExprList list = new ExprList(this.exprs.length);
            for (Expr expr : this.exprs) {
                if (expr == Empty.VALUE) {
                    return cc.emptySeq(this);
                }
                if (!expr.has(Flag.CNS, Flag.NDT) && list.contains(expr)) {
                    cc.info("remove % from %", expr, this::description);
                    continue;
                }
                list.add(expr);
            }
            this.exprs = (Expr[])list.finish();
            Expr ex = this.rewrite(Union.class, (invert, ops) -> invert != false ? new Union(this.info, (Expr)ops) : new Intersect(this.info, (Expr[])ops), cc);
            if (ex != null) {
                cc.info("rewrite %: %", this::description, ex);
                return ex;
            }
        }
        return null;
    }

    @Override
    And mergePredicates(Expr[] preds, CompileContext cc) {
        return new And(this.info, preds);
    }

    @Override
    Value nodes(QueryContext qc) throws QueryException {
        Item item;
        ANodeBuilder nodes = new ANodeBuilder();
        Iter iter = this.exprs[0].iter(qc);
        while ((item = qc.next(iter)) != null) {
            nodes.add(this.toNode(item));
        }
        int el = this.exprs.length;
        for (int e = 1; e < el && !nodes.isEmpty(); ++e) {
            Item item2;
            nodes.ddo();
            ANodeBuilder tmp = new ANodeBuilder();
            iter = this.exprs[e].iter(qc);
            while ((item2 = qc.next(iter)) != null) {
                ANode node = this.toNode(item2);
                if (!nodes.contains(node)) continue;
                tmp.add(node);
            }
            nodes = tmp;
        }
        return nodes.value(this);
    }

    @Override
    NodeIter iterate(QueryContext qc) throws QueryException {
        return new Set.SetIter(qc, this.iters(qc)){

            @Override
            public ANode next() throws QueryException {
                int irl = this.iter.length;
                if (this.nodes == null) {
                    this.nodes = new ANode[irl];
                }
                for (int i = 0; i < irl; ++i) {
                    if (this.next(i)) continue;
                    return null;
                }
                int il = this.nodes.length;
                int i = 1;
                while (i < il) {
                    int d = this.nodes[0].diff(this.nodes[i]);
                    if (d > 0) {
                        if (this.next(i)) continue;
                        return null;
                    }
                    if (d < 0) {
                        if (!this.next(0)) {
                            return null;
                        }
                        i = 1;
                        continue;
                    }
                    ++i;
                }
                return this.nodes[0];
            }
        };
    }

    @Override
    public Data data() {
        return Intersect.data(this.exprs);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        Intersect is = new Intersect(this.info, Intersect.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
        is.iterative = this.iterative;
        return this.copyType(is);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Intersect && super.equals(obj);
    }
}

