/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Instance
extends Single {
    private final SeqType seqType;
    private int check;

    public Instance(InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, SeqType.BOOLEAN_O);
        this.seqType = seqType;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (this.expr instanceof Value) {
            return cc.preEval(this);
        }
        SeqType et = this.expr.seqType();
        if (!this.expr.has(Flag.NDT)) {
            if (et.instanceOf(this.seqType)) {
                return cc.replaceWith(this, Bln.TRUE);
            }
            if (et.intersect(this.seqType) == null) {
                return cc.replaceWith(this, Bln.FALSE);
            }
        }
        this.check = et.occ.instanceOf(this.seqType.occ) ? 1 : (et.type.instanceOf(this.seqType.type) && et.kindInstanceOf(this.seqType) ? 2 : 0);
        return this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Iter iter = this.expr.iter(qc);
        Value value = iter.iterValue();
        if (value != null) {
            return Bln.get(this.seqType.instance(value));
        }
        if (this.check == 1) {
            Item item2;
            while ((item2 = iter.next()) != null) {
                if (this.seqType.instance(item2)) continue;
                return Bln.FALSE;
            }
            return Bln.TRUE;
        }
        long max = this.seqType.occ.max;
        if (this.check == 2) {
            return Bln.get(iter.next() == null ? !this.seqType.oneOrMore() : max > 1L || max > 0L && iter.next() == null);
        }
        long c = 0L;
        while ((item = iter.next()) != null) {
            if (++c <= max && this.seqType.instance(item)) continue;
            return Bln.FALSE;
        }
        return Bln.get(c != 0L || !this.seqType.oneOrMore());
    }

    @Override
    public Instance copy(CompileContext cc, IntObjMap<Var> vm) {
        Instance ex = this.copyType(new Instance(this.info, this.expr.copy(cc, vm), this.seqType));
        ex.check = this.check;
        return ex;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Instance && this.seqType.eq(((Instance)obj).seqType) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "of", this.seqType), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.expr).token("instance").token("of").token(this.seqType);
    }
}

