/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Or;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class If
extends Arr {
    public Expr cond;

    public If(InputInfo info, Expr cond, Expr branch1) {
        this(info, cond, branch1, (Expr)Empty.VALUE);
    }

    public If(InputInfo info, Expr cond, Expr branch1, Expr branch2) {
        super(info, SeqType.ITEM_ZM, branch1, branch2);
        this.cond = cond;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        this.checkAllUp(this.exprs);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.cond = this.cond.compile(cc);
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            try {
                this.exprs[e] = this.exprs[e].compile(cc);
                continue;
            }
            catch (QueryException ex) {
                this.exprs[e] = cc.error(ex, this.exprs[e]);
            }
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (Function.EMPTY.is(this.cond)) {
            this.cond = cc.function(Function.EXISTS, this.info, this.cond.arg(0));
            this.swap();
            cc.info("swap operands: %", this);
        } else if (Function.NOT.is(this.cond)) {
            this.cond = this.cond.arg(0);
            this.swap();
            cc.info("swap operands: %", this);
        }
        this.cond = this.cond.simplifyFor(CompileContext.Simplify.EBV, cc);
        return cc.replaceWith(this, this.opt(cc));
    }

    private Expr opt(CompileContext cc) throws QueryException {
        Expr cmp;
        if (this.cond instanceof Value) {
            return this.expr(cc.qc);
        }
        Expr br1 = this.exprs[0];
        Expr br2 = this.exprs[1];
        SeqType ct = this.cond.seqType();
        boolean ndt = this.cond.has(Flag.NDT);
        if (ct.zero() && !ndt) {
            return br2;
        }
        Expr expr = Function.EXISTS.is(this.cond) ? this.cond.arg(0) : (cmp = ct.type instanceof NodeType ? this.cond : null);
        if (!ndt && cmp != null && cmp.equals(br1)) {
            return cc.function(Function._UTIL_OR, this.info, br1, br2);
        }
        if (br1.equals(br2)) {
            return cc.merge(this.cond, br1, this.info);
        }
        SeqType st1 = br1.seqType();
        SeqType st2 = br2.seqType();
        this.exprType.assign(st1.union(st2));
        if (st1.eq(SeqType.BOOLEAN_O) && st2.eq(SeqType.BOOLEAN_O)) {
            if (br1 == Bln.TRUE) {
                return br2 == Bln.FALSE ? cc.function(Function.BOOLEAN, this.info, this.cond) : new Or(this.info, this.cond, br2).optimize(cc);
            }
            if (br2 == Bln.TRUE) {
                return br1 == Bln.FALSE ? cc.function(Function.NOT, this.info, this.cond) : new Or(this.info, cc.function(Function.NOT, this.info, this.cond), br1).optimize(cc);
            }
            if (br1 == Bln.FALSE) {
                return new And(this.info, cc.function(Function.NOT, this.info, this.cond), br2).optimize(cc);
            }
            if (br2 == Bln.FALSE) {
                return new And(this.info, this.cond, br1).optimize(cc);
            }
            if (this.contradict(br1, br2, false)) {
                return new CmpG(cc.function(Function.BOOLEAN, this.info, this.cond), br1, CmpG.OpG.EQ, null, cc.sc(), this.info).optimize(cc);
            }
            if (this.contradict(br2, br1, false)) {
                return new CmpG(cc.function(Function.BOOLEAN, this.info, this.cond), br2, CmpG.OpG.NE, null, cc.sc(), this.info).optimize(cc);
            }
        }
        return this;
    }

    public void swap() {
        Expr tmp = this.exprs[0];
        this.exprs[0] = this.exprs[1];
        this.exprs[1] = tmp;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.expr(qc).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.expr(qc).value(qc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.expr(qc).item(qc, this.info);
    }

    private Expr expr(QueryContext qc) throws QueryException {
        return this.exprs[this.cond.ebv(qc, this.info).bool(this.info) ? 0 : 1];
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.cond.has(flags) || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.cond.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.cond.count(var).plus(VarUsage.maximum(var, this.exprs));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = ic.inline(this.exprs, true);
        Expr inlined = this.cond.inline(ic);
        if (inlined != null) {
            changed = true;
            this.cond = inlined;
        }
        return changed ? this.optimize(ic.cc) : null;
    }

    @Override
    public If copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new If(this.info, this.cond.copy(cc, vm), this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm)));
    }

    @Override
    public boolean vacuous() {
        return this.exprs[0].vacuous() && this.exprs[1].vacuous();
    }

    @Override
    public boolean ddo() {
        return this.exprs[0].ddo() && this.exprs[1].ddo();
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (Expr expr : this.exprs) {
            expr.markTailCalls(cc);
        }
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return this.simplifyAll(mode, cc) ? this.optimize(cc) : super.simplifyFor(mode, cc);
    }

    @Override
    public Data data() {
        return If.data(this.exprs);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = this.cond.exprSize();
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        boolean changed = false;
        for (Expr expr : this.exprs) {
            try {
                expr = tc.check(expr, cc);
            }
            catch (QueryException qe) {
                expr = cc.error(qe, expr);
            }
            if (expr == null) continue;
            changed = true;
            this.exprs[e] = expr;
        }
        return changed ? this.optimize(cc) : this;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof If && this.cond.equals(((If)obj).cond) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.cond, this.exprs});
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("(").token("if").paren(this.cond).token("then").token(this.exprs[0]);
        qs.token("else").token(this.exprs[1]).token(')');
    }
}

