/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpV
extends Cmp {
    private OpV opV;

    public CmpV(Expr expr1, Expr expr2, OpV opV, Collation coll, StaticContext sc, InputInfo info) {
        super(info, expr1, expr2, coll, SeqType.BOOLEAN_ZO, sc);
        this.opV = opV;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        this.simplifyAll(CompileContext.Simplify.STRING, cc);
        if (this.swap()) {
            cc.info("swap operands: %", this);
            this.opV = this.opV.swap();
        }
        if ((expr = this.emptyExpr()) == this) {
            if (this.allAreValues(false)) {
                return cc.preEval(this);
            }
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exprs[1];
            SeqType st1 = expr1.seqType();
            SeqType st2 = expr2.seqType();
            if (st1.oneOrMore() && !st1.mayBeArray() && st2.oneOrMore() && !st2.mayBeArray()) {
                this.exprType.assign(Occ.EXACTLY_ONE);
                Type type1 = st1.type;
                Type type2 = st2.type;
                if (st1.one() && st2.one() && (type1 == type2 && !AtomType.ANY_ATOMIC_TYPE.instanceOf(type1) && (type1.isSortable() || this.opV != OpV.EQ && this.opV != OpV.NE) || type1.isStringOrUntyped() && type2.isStringOrUntyped() || type1 == AtomType.QNAME && type2 == AtomType.QNAME || type1.instanceOf(AtomType.NUMERIC) && type2.instanceOf(AtomType.NUMERIC) || type1.instanceOf(AtomType.DURATION) && type2.instanceOf(AtomType.DURATION))) {
                    expr = new CmpG(expr1, expr2, CmpG.OpG.get(this.opV), this.coll, this.sc, this.info).optimize(cc);
                }
            }
        }
        if (expr == this) {
            expr = this.opt(cc);
        }
        return cc.replaceWith(this, expr);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == Empty.VALUE) {
            return Empty.VALUE;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        if (item2 == Empty.VALUE) {
            return Empty.VALUE;
        }
        if (item1.comparable(item2)) {
            return Bln.get(this.opV.eval(item1, item2, this.coll, this.sc, this.info));
        }
        throw QueryError.diffError(item1, item2, this.info);
    }

    @Override
    public Expr invert() {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        return st1.one() && !st1.mayBeArray() && st2.one() && !st2.mayBeArray() ? new CmpV(expr1, expr2, this.opV.invert(), this.coll, this.sc, this.info) : null;
    }

    @Override
    public OpV opV() {
        return this.opV;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CmpV(this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.opV, this.coll, this.sc, this.info));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CmpV && this.opV == ((CmpV)obj).opV && super.equals(obj);
    }

    @Override
    public String description() {
        return "'" + (Object)((Object)this.opV) + "' comparison";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.opV.name), this.exprs);
    }

    @Override
    public void plan(QueryString qs) {
        qs.tokens(this.exprs, " " + (Object)((Object)this.opV) + ' ', true);
    }

    public static enum OpV {
        LE("le"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                int v = item1.diff(item2, coll, ii);
                return v != Integer.MIN_VALUE && v <= 0;
            }

            @Override
            public OpV swap() {
                return GE;
            }

            @Override
            public OpV invert() {
                return GT;
            }
        }
        ,
        LT("lt"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                int v = item1.diff(item2, coll, ii);
                return v != Integer.MIN_VALUE && v < 0;
            }

            @Override
            public OpV swap() {
                return GT;
            }

            @Override
            public OpV invert() {
                return GE;
            }
        }
        ,
        GE("ge"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                return item1.diff(item2, coll, ii) >= 0;
            }

            @Override
            public OpV swap() {
                return LE;
            }

            @Override
            public OpV invert() {
                return LT;
            }
        }
        ,
        GT("gt"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                return item1.diff(item2, coll, ii) > 0;
            }

            @Override
            public OpV swap() {
                return LT;
            }

            @Override
            public OpV invert() {
                return LE;
            }
        }
        ,
        EQ("eq"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                return item1.eq(item2, coll, sc, ii);
            }

            @Override
            public OpV swap() {
                return EQ;
            }

            @Override
            public OpV invert() {
                return NE;
            }
        }
        ,
        NE("ne"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
                return !item1.eq(item2, coll, sc, ii);
            }

            @Override
            public OpV swap() {
                return NE;
            }

            @Override
            public OpV invert() {
                return EQ;
            }
        };

        public static final OpV[] VALUES;
        public final String name;

        private OpV(String name) {
            this.name = name;
        }

        public abstract boolean eval(Item var1, Item var2, Collation var3, StaticContext var4, InputInfo var5) throws QueryException;

        public abstract OpV swap();

        public abstract OpV invert();

        public String toString() {
            return this.name;
        }

        static {
            VALUES = OpV.values();
        }
    }
}

