/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import org.basex.core.Text;
import org.basex.query.QueryError;
import org.basex.query.QueryText;
import org.basex.query.expr.ExprInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public class QueryException
extends Exception {
    static final QueryException ERROR = new QueryException(""){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    private final ArrayList<InputInfo> stack = new ArrayList();
    private final QNm name;
    private Value value = Empty.VALUE;
    private QueryError error;
    private StringList suggest;
    private InputInfo info;
    private int markedCol;
    private boolean catchable = true;

    public QueryException(Throwable cause) {
        this(Util.message(cause));
        this.initCause(cause);
    }

    public QueryException(String message) {
        this(null, QueryError.BASEX_ERROR_X, message);
    }

    public QueryException(InputInfo info, QueryError error, Object ... ext) {
        this(info, error.qname(), error.message, ext);
        this.error = error;
    }

    public QueryException(InputInfo info, QNm name, String message, Object ... ext) {
        super(QueryException.message(message, ext));
        this.name = name;
        if (info != null) {
            this.info(info);
        }
        for (Object o : ext) {
            if (!(o instanceof Throwable)) continue;
            this.initCause((Throwable)o);
            break;
        }
    }

    public final int column() {
        return this.info == null ? 0 : this.info.column();
    }

    public final int markedColumn() {
        return this.markedCol;
    }

    public final int line() {
        return this.info == null ? 0 : this.info.line();
    }

    public final String file() {
        return this.info == null ? null : this.info.path();
    }

    public final StringList suggest() {
        return this.suggest == null ? new StringList() : this.suggest;
    }

    public final QueryException suggest(InputParser qp, StringList sug) {
        this.suggest = sug;
        this.pos(qp);
        return this;
    }

    public final QueryException add(InputInfo ii) {
        if (ii != null) {
            this.stack.add(ii);
        }
        return this;
    }

    public final QueryException info(InputInfo ii) {
        this.info = ii;
        return this;
    }

    public final InputInfo info() {
        return this.info;
    }

    public final QueryException value(Value val) {
        this.value = val;
        return this;
    }

    final QueryException error(QueryError err) {
        this.error = err;
        return this;
    }

    final void pos(InputParser parser) {
        this.markedCol = parser.mark;
        if (this.info != null) {
            return;
        }
        parser.pos = Math.min(parser.mark, parser.length);
        this.info = new InputInfo(parser);
    }

    public final QNm qname() {
        return this.name;
    }

    public final QueryError error() {
        return this.error;
    }

    public final Value value() {
        return this.value;
    }

    @Override
    public String getLocalizedMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        byte[] code;
        TokenBuilder tb = new TokenBuilder();
        if (this.info != null) {
            tb.add(Text.STOPPED_AT).add(this.info).add(":").add(Text.NL);
        }
        if ((code = this.name.local()).length != 0) {
            tb.add(91).add(this.name.prefixId(QueryText.ERROR_URI)).add("] ");
        }
        tb.add(this.getLocalizedMessage());
        if (!this.stack.isEmpty()) {
            tb.add(Text.NL).add(Text.NL).add("Stack Trace").add(":");
            for (InputInfo ii : this.stack) {
                tb.add(Text.NL).add("- ").add(ii);
            }
        }
        return tb.toString();
    }

    public boolean isCatchable() {
        return this.catchable;
    }

    public final QueryException notCatchable() {
        this.catchable = false;
        return this;
    }

    private static String message(String text, Object[] ext) {
        int el = ext.length;
        for (int e = 0; e < el; ++e) {
            if (!(ext[e] instanceof ExprInfo)) continue;
            ext[e] = QueryError.normalize(((ExprInfo)ext[e]).toErrorString(), null);
        }
        return Util.info(text, ext);
    }
}

