/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.basex.query.CompileContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.scope.MainModule;
import org.basex.query.scope.Scope;
import org.basex.query.scope.StaticDecl;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.FuncItem;
import org.basex.query.var.StaticVar;
import org.basex.util.Array;
import org.basex.util.list.IntList;

final class QueryCompiler {
    private static final int MAP_THRESHOLD = 16;
    private final CompileContext cc;
    private final ArrayList<Scope[]> result = new ArrayList();
    private final IntList stack = new IntList();
    private final IntList list = new IntList();
    private int next;
    private final ArrayList<int[]> adjacent = new ArrayList();
    private final ArrayList<Scope> scopes = new ArrayList();
    private IdentityHashMap<Scope, Integer> ids;

    private QueryCompiler(CompileContext cc, Scope root) {
        this.cc = cc;
        this.add(root);
    }

    public static List<StaticDecl> usedDecls(MainModule main) {
        final ArrayList<StaticDecl> scopes = new ArrayList<StaticDecl>();
        final IdentityHashMap map = new IdentityHashMap();
        main.visit(new ASTVisitor(){

            @Override
            public boolean staticVar(StaticVar var) {
                if (map.put(var, var) == null) {
                    var.visit(this);
                    scopes.add(var);
                }
                return true;
            }

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                StaticFunc f = call.func();
                if (map.put(f, f) == null) {
                    f.visit(this);
                    scopes.add(f);
                }
                return true;
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                if (map.put(scope, scope) == null) {
                    scope.visit(this);
                }
                return true;
            }

            @Override
            public boolean funcItem(FuncItem func) {
                if (map.put(func, func) == null) {
                    func.visit(this);
                }
                return true;
            }
        });
        return scopes;
    }

    public static void compile(CompileContext cc, MainModule root) throws QueryException {
        if (!root.compiled()) {
            new QueryCompiler(cc, root).compile();
        }
    }

    private void compile() throws QueryException {
        ArrayList<StaticFunc> funcs = new ArrayList<StaticFunc>();
        for (Scope[] scps : this.scopes(0)) {
            Scope scope = QueryCompiler.circCheck(scps);
            scope.comp(this.cc);
            if (!(scope instanceof StaticFunc)) continue;
            funcs.add((StaticFunc)scope);
        }
        for (StaticVar var : this.cc.qc.vars) {
            if (this.id(var) != -1) continue;
            for (Scope[] scope : this.scopes(this.add(var))) {
                QueryCompiler.circCheck(scope);
            }
        }
        for (StaticFunc func : funcs) {
            func.optimize(this.cc);
        }
    }

    private static Scope circCheck(Scope[] scopes) throws QueryException {
        if (scopes.length > 1) {
            for (Scope scope : scopes) {
                if (!(scope instanceof StaticVar)) continue;
                StaticVar var = (StaticVar)scope;
                throw QueryError.CIRCVAR_X.get(var.info, new Object[]{var.id()});
            }
        }
        return scopes[0];
    }

    private Iterable<Scope[]> scopes(int p) throws QueryException {
        this.result.clear();
        this.tarjan(p);
        return this.result;
    }

    private void tarjan(int v) throws QueryException {
        int ixv = 2 * v;
        int llv = ixv + 1;
        int idx = this.next++;
        while (this.list.size() <= llv) {
            this.list.add(-1);
        }
        this.list.set(ixv, idx);
        this.list.set(llv, idx);
        this.stack.push(v);
        for (int w : this.adjacentTo(v)) {
            int ixw = 2 * w;
            int llw = ixw + 1;
            if (this.list.size() <= ixw || this.list.get(ixw) < 0) {
                this.tarjan(w);
                this.list.set(llv, Math.min(this.list.get(llv), this.list.get(llw)));
                continue;
            }
            if (!this.stack.contains(w)) continue;
            this.list.set(llv, Math.min(this.list.get(llv), this.list.get(ixw)));
        }
        if (this.list.get(llv) == this.list.get(ixv)) {
            int w;
            Scope[] out = null;
            do {
                Scope[] scopeArray;
                w = this.stack.pop();
                Scope scp = this.scopes.get(w);
                if (out == null) {
                    Scope[] scopeArray2 = new Scope[1];
                    scopeArray = scopeArray2;
                    scopeArray2[0] = scp;
                    continue;
                }
                scopeArray = out = Array.add(out, scp);
            } while (w != v);
            this.result.add(out);
        }
    }

    private int id(Scope scp) {
        if (this.ids != null) {
            Integer id = this.ids.get(scp);
            return id == null ? -1 : id;
        }
        int ss = this.scopes.size();
        for (int s = 0; s < ss; ++s) {
            if (this.scopes.get(s) != scp) continue;
            return s;
        }
        return -1;
    }

    private int add(Scope scp) {
        int id = this.scopes.size();
        if (id == 16) {
            this.ids = new IdentityHashMap();
            for (Scope s : this.scopes) {
                this.ids.put(s, this.ids.size());
            }
        }
        this.scopes.add(scp);
        this.adjacent.add(null);
        if (this.ids != null) {
            this.ids.put(scp, id);
        }
        return id;
    }

    private int[] adjacentTo(int node) throws QueryException {
        int[] adj = this.adjacent.get(node);
        if (adj == null) {
            adj = this.neighbors(this.scopes.get(node));
            this.adjacent.set(node, adj);
        }
        return adj;
    }

    private int[] neighbors(final Scope curr) throws QueryException {
        final IntList adj = new IntList(0L);
        boolean ok = curr.visit(new ASTVisitor(){

            @Override
            public boolean staticVar(StaticVar var) {
                return var != curr && this.neighbor(var);
            }

            @Override
            public boolean staticFuncCall(StaticFuncCall call) {
                return this.neighbor(call.func());
            }

            @Override
            public boolean inlineFunc(Scope scope) {
                return scope.visit(this);
            }

            @Override
            public boolean funcItem(FuncItem func) {
                return this.neighbor(func);
            }

            private boolean neighbor(Scope scp) {
                int id;
                int old = QueryCompiler.this.id(scp);
                int n = id = old == -1 ? QueryCompiler.this.add(scp) : old;
                if (old == -1 || !adj.contains(id)) {
                    adj.add(id);
                }
                return true;
            }
        });
        if (!ok) {
            StaticVar var = (StaticVar)curr;
            throw QueryError.CIRCREF_X.get(var.info, "$" + var.name);
        }
        return adj.finish();
    }
}

