/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.csv.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;

public final class CsvXQueryConverter
extends CsvConverter {
    public static final Str NAMES = Str.get("names");
    public static final Str RECORDS = Str.get("records");
    private final ItemList rows = new ItemList();
    private ArrayBuilder row;

    CsvXQueryConverter(CsvParserOptions opts) {
        super(opts);
    }

    @Override
    protected void header(byte[] string) {
        this.headers.add(string);
    }

    @Override
    protected void record() {
        if (this.row != null) {
            this.rows.add(this.row.freeze());
        }
        this.row = new ArrayBuilder();
    }

    @Override
    protected void entry(byte[] value) {
        this.row.append(Str.get(value));
    }

    @Override
    protected void init(String uri) {
    }

    @Override
    protected XQMap finish() throws QueryIOException {
        if (this.row != null) {
            this.rows.add(this.row.freeze());
        }
        try {
            XQMap map = XQMap.EMPTY;
            if (!this.headers.isEmpty()) {
                ArrayBuilder names = new ArrayBuilder();
                for (byte[] header : this.headers) {
                    names.append(Str.get(header));
                }
                map = map.put(NAMES, names.freeze(), null);
            }
            return map.put(RECORDS, this.rows.value(), null);
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }
}

