/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.stats;

import java.io.IOException;
import org.basex.data.MetaData;
import org.basex.index.stats.StatsType;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.hash.TokenIntMap;

public final class Stats {
    public TokenIntMap values;
    public double min;
    public double max;
    public int count;
    public byte type;
    private boolean leaf;

    public Stats() {
        this.values = new TokenIntMap();
        this.type = (byte)4;
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.leaf = true;
    }

    public Stats(DataInput in) throws IOException {
        int t = in.readNum() & 0xF;
        this.type = (byte)t;
        if (StatsType.isInteger(t) || StatsType.isDouble(t)) {
            this.min = in.readDouble();
            this.max = in.readDouble();
        }
        if (StatsType.isCategory(t)) {
            this.values = new TokenIntMap(in);
        }
        this.count = in.readNum();
        this.leaf = in.readBool();
        in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        if (this.values != null) {
            if (this.values.isEmpty()) {
                this.values = null;
            } else if (!StatsType.isCategory(this.type)) {
                this.type = (byte)(this.type == 2 ? 5 : (this.type == 3 ? 6 : 1));
            }
        }
        out.writeNum(this.type);
        if (StatsType.isNumeric(this.type)) {
            out.writeDouble(this.min);
            out.writeDouble(this.max);
        }
        if (StatsType.isCategory(this.type)) {
            this.values.write(out);
        }
        out.writeNum(this.count);
        out.writeBool(this.leaf);
        out.writeDouble(0.0);
    }

    public void add(byte[] value, MetaData meta) {
        int t = this.type;
        int vl = value.length;
        if (vl > 0) {
            if (t == 4) {
                t = 2;
            }
            if (t == 2) {
                long d = Token.toLong(value);
                if (d == Long.MIN_VALUE) {
                    t = 3;
                } else {
                    if (this.min > (double)d) {
                        this.min = d;
                    }
                    if (this.max < (double)d) {
                        this.max = d;
                    }
                }
            }
            if (t == 3) {
                double d = Token.toDouble(value);
                if (Double.isNaN(d)) {
                    t = 0;
                } else {
                    if (this.min > d) {
                        this.min = d;
                    }
                    if (this.max < d) {
                        this.max = d;
                    }
                }
            }
        }
        this.type = t;
        if (this.values != null) {
            if (vl > meta.maxlen || vl > 0 && Token.ws(value)) {
                this.values = null;
            } else {
                this.values.put(value, Math.max(1, this.values.get(value) + 1));
                if (this.values.size() > meta.maxcats) {
                    this.values = null;
                }
            }
        }
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean l) {
        this.leaf = l;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.count + "x");
        if (!StatsType.isNone(this.type)) {
            int size;
            sb.append(", ");
            int n = size = this.values != null ? this.values.size() : 0;
            if (size > 1) {
                sb.append(size).append(" distinct ");
            }
            sb.append(StatsType.toString(this.type));
            if (size != 1) {
                sb.append('s');
            }
            if (StatsType.isNumeric(this.type)) {
                sb.append(" [");
                int mn = (int)this.min;
                int mx = (int)this.max;
                if ((double)mn == this.min) {
                    sb.append(mn);
                } else {
                    sb.append(this.min);
                }
                sb.append(", ");
                if ((double)mx == this.max) {
                    sb.append(mx);
                } else {
                    sb.append(this.max);
                }
                sb.append(']');
            }
        }
        if (this.leaf) {
            sb.append(", leaf");
        }
        return sb.toString();
    }
}

