/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.io.IOException;
import java.util.Arrays;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.Table;
import org.basex.util.list.TokenList;

public class IdPreMap {
    private static final int INV = -1;
    private int baseid;
    private int[] pres;
    private int[] fids;
    private int[] nids;
    private int[] incs;
    private int[] oids;
    private int rows;

    public IdPreMap(int id) {
        this.baseid = id;
        this.pres = new int[1];
        this.fids = new int[1];
        this.nids = new int[1];
        this.incs = new int[1];
        this.oids = new int[1];
    }

    public IdPreMap(IOFile f) throws IOException {
        try (DataInput in = new DataInput(f);){
            this.baseid = in.readNum();
            this.rows = in.readNum();
            this.pres = in.readNums();
            this.fids = in.readNums();
            this.nids = in.readNums();
            this.incs = in.readNums();
            this.oids = in.readNums();
        }
    }

    public final void write(IOFile file) throws IOException {
        try (DataOutput out = new DataOutput(file);){
            out.writeNum(this.baseid);
            out.writeNum(this.rows);
            out.writeNums(this.pres);
            out.writeNums(this.fids);
            out.writeNums(this.nids);
            out.writeNums(this.incs);
            out.writeNums(this.oids);
        }
    }

    public final void finish(int base) {
        this.baseid = base;
    }

    public int pre(int id) {
        if (this.rows == 0 || id < this.pres[0]) {
            return id;
        }
        if (id > this.baseid) {
            for (int i = 0; i < this.rows; ++i) {
                if (this.fids[i] > id || id > this.nids[i]) continue;
                return this.pres[i] + id - this.fids[i];
            }
        } else {
            int i = this.sortedLastIndexOf(this.oids, id);
            return id + this.incs[i < 0 ? -i - 2 : i];
        }
        return -1;
    }

    public void insert(int pre, int id, int c) {
        if (this.rows == 0 && pre == id && id == this.baseid + 1) {
            this.baseid += c;
            return;
        }
        int pos = 0;
        int inc = c;
        int oid = pre;
        if (this.rows > 0) {
            pos = Arrays.binarySearch(this.pres, 0, this.rows, pre);
            if (pos < 0) {
                if ((pos = -pos - 1) != 0) {
                    int prev = pos - 1;
                    int prevpre = this.pres[prev];
                    int prevcnt = this.nids[prev] - this.fids[prev] + 1;
                    if (pre < prevpre + prevcnt) {
                        int split = pre - prevpre;
                        int fid = this.fids[prev] + split;
                        this.add(pos, pre, fid, this.nids[prev], this.incs[prev], this.oids[prev]);
                        this.nids[prev] = fid - 1;
                        int n = prev;
                        this.incs[n] = this.incs[n] - (prevcnt - split);
                        oid = this.oids[prev];
                    } else {
                        oid = pre - this.incs[prev];
                    }
                    inc += this.incs[prev];
                }
            } else if (pos > 0) {
                oid = this.oids[pos];
                inc += this.incs[pos - 1];
            }
            this.increment(pos, c);
        }
        this.add(pos, pre, id, id + c - 1, inc, oid);
    }

    public void delete(int pre, int id, int c) {
        int endIndex;
        int oid;
        int inc;
        if (this.rows == 0 && pre == id && id - c == this.baseid + 1) {
            this.baseid += c;
            return;
        }
        if (this.rows == 0) {
            this.add(0, pre, -1, -1, c, id);
            return;
        }
        int end = pre - c - 1;
        int startIndex = this.findPre(pre);
        int removeStart = startIndex < this.rows && this.pres[startIndex] < pre ? startIndex + 1 : startIndex;
        int removeEnd = -1;
        int i = startIndex;
        while (i < this.rows && end >= this.pres[i] + this.nids[i] - this.fids[i]) {
            removeEnd = i++;
        }
        if (removeEnd >= 0) {
            inc = this.incs[removeEnd];
            oid = this.oids[removeEnd];
            endIndex = removeStart;
            this.remove(removeStart, removeEnd);
        } else {
            inc = startIndex > 0 ? this.incs[startIndex - 1] : 0;
            oid = id;
            endIndex = startIndex;
        }
        if (this.rows <= startIndex) {
            this.add(startIndex, pre, -1, -1, inc + c, oid);
            return;
        }
        int min = this.pres[startIndex];
        if (startIndex < endIndex) {
            if (endIndex < this.rows && this.pres[endIndex] <= end) {
                this.shrinkFromStart(endIndex, pre, c);
            } else {
                --endIndex;
            }
            this.shrinkFromEnd(startIndex, pre, inc + c);
        } else if (min < pre) {
            this.add(++endIndex, this.pres[startIndex], this.fids[startIndex], this.nids[startIndex], this.incs[startIndex], this.oids[startIndex]);
            this.shrinkFromStart(endIndex, pre, c);
            this.shrinkFromEnd(startIndex, pre, inc + c);
        } else if (end < min) {
            this.add(endIndex, pre, -1, -1, inc + c, oid);
        } else {
            this.shrinkFromStart(startIndex, pre, c);
        }
        this.increment(endIndex + 1, c);
    }

    private void shrinkFromStart(int i, int pre, int c) {
        int n = i;
        this.incs[n] = this.incs[n] + c;
        int n2 = i;
        this.fids[n2] = this.fids[n2] + (pre - c - this.pres[i]);
        this.pres[i] = pre;
    }

    private void shrinkFromEnd(int i, int pre, int inc) {
        this.nids[i] = this.fids[i] + pre - this.pres[i] - 1;
        this.incs[i] = inc;
    }

    private void increment(int from, int with) {
        int i = from;
        while (i < this.rows) {
            int n = i;
            this.pres[n] = this.pres[n] + with;
            int n2 = i++;
            this.incs[n2] = this.incs[n2] + with;
        }
    }

    public int size() {
        return this.rows;
    }

    private int findPre(int pre) {
        int low = 0;
        int high = this.rows - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValMin = this.pres[mid];
            int midValMax = midValMin + this.nids[mid] - this.fids[mid];
            if (midValMax < pre) {
                low = mid + 1;
                continue;
            }
            if (midValMin > pre) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    private int sortedLastIndexOf(int[] a, int e) {
        int i = Arrays.binarySearch(a, 0, this.rows, e);
        if (i >= 0) {
            while (++i < this.rows && a[i] == e) {
            }
            return i - 1;
        }
        return i;
    }

    private void add(int i, int pre, int fid, int nid, int inc, int oid) {
        if (this.rows == this.pres.length) {
            int s = Array.newCapacity(this.rows);
            this.pres = Arrays.copyOf(this.pres, s);
            this.fids = Arrays.copyOf(this.fids, s);
            this.nids = Arrays.copyOf(this.nids, s);
            this.incs = Arrays.copyOf(this.incs, s);
            this.oids = Arrays.copyOf(this.oids, s);
        }
        if (i < this.rows) {
            int destPos = i + 1;
            int length = this.rows - i;
            Array.copy(this.pres, i, length, this.pres, destPos);
            Array.copy(this.fids, i, length, this.fids, destPos);
            Array.copy(this.nids, i, length, this.nids, destPos);
            Array.copy(this.incs, i, length, this.incs, destPos);
            Array.copy(this.oids, i, length, this.oids, destPos);
        }
        this.pres[i] = pre;
        this.fids[i] = fid;
        this.nids[i] = nid;
        this.incs[i] = inc;
        this.oids[i] = oid;
        ++this.rows;
    }

    private void remove(int s, int e) {
        if (s <= e) {
            int last = e + 1;
            int length = this.rows - last;
            Array.copy(this.pres, last, length, this.pres, s);
            Array.copy(this.fids, last, length, this.fids, s);
            Array.copy(this.nids, last, length, this.nids, s);
            Array.copy(this.incs, last, length, this.incs, s);
            Array.copy(this.oids, last, length, this.oids, s);
            this.rows -= last - s;
        }
    }

    public String toString() {
        int i;
        Table t = new Table();
        t.header.add("PRE").add("FID").add("NID").add("INC").add("OID");
        for (i = 0; i < 5; ++i) {
            t.align.add(true);
        }
        for (i = 0; i < this.rows; ++i) {
            TokenList tl = new TokenList();
            tl.add(this.pres[i]).add(this.fids[i]).add(this.nids[i]).add(this.incs[i]).add(this.oids[i]);
            t.contents.add(tl);
        }
        return t + "\n- BaseID: " + this.baseid + '\n';
    }
}

