/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import org.basex.core.Text;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXSplit;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.GUIWorker;
import org.basex.gui.listener.FocusGainedListener;
import org.basex.gui.view.editor.EditorArea;
import org.basex.gui.view.editor.EditorView;
import org.basex.gui.view.project.ProjectDir;
import org.basex.gui.view.project.ProjectFiles;
import org.basex.gui.view.project.ProjectFilter;
import org.basex.gui.view.project.ProjectList;
import org.basex.gui.view.project.ProjectNode;
import org.basex.gui.view.project.ProjectTree;
import org.basex.io.IOFile;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Util;

public final class ProjectView
extends BaseXPanel {
    final ProjectFiles files;
    final ProjectDir root;
    final ProjectTree tree;
    final ProjectList list;
    private final ProjectFilter filter;
    private final BaseXCombo rootPath;
    private final BaseXSplit split;
    private Component last;
    private boolean parsed;
    final FocusGainedListener lastfocus = e -> {
        this.last = e.getComponent();
    };

    public ProjectView(EditorView view) {
        super(view.gui);
        this.setLayout(new BorderLayout());
        this.files = new ProjectFiles(this);
        String project = this.gui.gopts.get(GUIOptions.PROJECTPATH);
        IOFile dir = new IOFile(project.isEmpty() ? Prop.HOMEDIR : project).normalize();
        this.root = new ProjectDir(dir, this);
        this.tree = new ProjectTree(this);
        this.tree.init(this.root);
        this.filter = new ProjectFilter(this);
        this.list = new ProjectList(this);
        BaseXLayout.addInteraction(this.list, this.gui);
        BaseXBack back = new BaseXBack(new BorderLayout(2, 4));
        back.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, GUIConstants.gray), BaseXLayout.border(5, 3, 5, 4)));
        this.rootPath = new BaseXCombo((BaseXWindow)this.gui, true, new String[0]).history(GUIOptions.PROJECTS, this.gui.gopts);
        this.rootPath.setFocusable(false);
        this.rootPath.textField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProjectView.this.changeRoot();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        AbstractButton browse = BaseXButton.get("c_editopen", Text.OPEN, false, this.gui);
        browse.setToolTipText(Text.CHOOSE_DIR + "...");
        browse.addActionListener(e -> this.chooseRoot());
        back.add((Component)this.rootPath, "Center");
        back.add((Component)browse, "East");
        back.add((Component)this.filter, "South");
        JScrollPane lscroll = new JScrollPane(this.list);
        lscroll.setBorder(BaseXLayout.border(0, 0, 0, 0));
        JScrollPane tscroll = new JScrollPane(this.tree);
        tscroll.setBorder(BaseXLayout.border(0, 0, 0, 0));
        this.split = new BaseXSplit(false);
        this.split.setOpaque(false);
        this.split.add(lscroll);
        this.split.add(tscroll);
        this.split.init(new double[]{0.3, 0.7}, new double[]{0.0, 1.0});
        this.split.visible(false);
        this.showList(false);
        this.add((Component)back, "North");
        this.add((Component)this.split, "Center");
        this.last = this.tree;
        this.tree.addFocusListener(this.lastfocus);
        this.list.addFocusListener(this.lastfocus);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ProjectView.this.refresh(false, false);
            }
        });
        this.rootPath.setText(dir.path());
    }

    void showList(boolean vis) {
        this.split.visible(vis);
    }

    public void save(IOFile file, boolean rename, boolean xquery, boolean library) {
        SwingUtilities.invokeLater(() -> {
            IOFile io = file.normalize();
            if (io.path().startsWith(this.root.file.path())) {
                if (xquery) {
                    ProjectFiles.parse(file.path(), this.gui.context, this.files.errors());
                }
                this.refreshTree(io);
            }
            this.refresh(rename, library);
        });
    }

    public TreeMap<String, InputInfo> errors() {
        return this.files.errors();
    }

    void refreshHighlight(ProjectNode node) {
        Set<String> errPaths = this.errors().keySet();
        Enumeration<TreeNode> en = node.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            ProjectNode child = (ProjectNode)en.nextElement();
            IOFile file = child.file;
            if (file == null) continue;
            child.error = ProjectView.find(errPaths, file);
        }
        this.repaint();
    }

    private static boolean find(Set<String> errPaths, IOFile file) {
        String path = file.path();
        for (String errPath : errPaths) {
            if (!errPath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    void refresh() {
        this.refresh(true, true);
    }

    private void refresh(boolean reset, boolean enforce) {
        if (reset) {
            this.files.reset();
        }
        this.filter.refresh(true);
        if (!this.gui.gopts.get(GUIOptions.PARSEPROJ).booleanValue() || this.getWidth() == 0 || this.parsed && !enforce) {
            return;
        }
        this.parsed = false;
        new GUIWorker<Boolean>(){

            @Override
            protected Boolean doInBackground() throws InterruptedException {
                Performance perf = new Performance();
                ProjectView.this.files.parse(ProjectView.this.root.file, ProjectView.this.gui.context);
                ProjectView.this.parsed = true;
                ProjectView.this.gui.status.setText(Text.PARSING_CC + perf.getTime());
                return true;
            }

            @Override
            protected void done(Boolean refresh) {
                if (refresh.booleanValue()) {
                    ProjectView.this.refreshHighlight(ProjectView.this.root);
                }
            }
        }.execute();
    }

    public void jumpTo(IOFile file, boolean focus) {
        IOFile fl;
        if (this.getWidth() == 0) {
            return;
        }
        if (file != null && (fl = file.normalize()).path().startsWith(this.root.file.path())) {
            this.tree.expand(this.root, fl.path());
        }
        if (focus) {
            this.tree.requestFocusInWindow();
        }
    }

    private void refreshTree(IOFile file) {
        IOFile parent;
        ProjectNode node = this.find(file.path());
        if (node != null) {
            node.refresh();
        }
        if ((parent = file.parent()) != null) {
            this.refreshTree(parent);
        }
    }

    private ProjectNode find(String path) {
        Enumeration<TreeNode> en = this.root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            ProjectNode node = (ProjectNode)en.nextElement();
            if (node.file == null || !node.file.path().equals(path)) continue;
            return node;
        }
        return null;
    }

    public void refreshLayout() {
        this.filter.refreshLayout();
    }

    public void findFiles(EditorArea ea) {
        this.filter.find(ea);
    }

    public void focus() {
        this.last.requestFocusInWindow();
    }

    IOFile rename(ProjectNode node, String name) {
        if (IOFile.isValidName(name)) {
            IOFile old = node.file;
            IOFile updated = new IOFile(old.file().getParent(), name);
            if (old.rename(updated)) {
                this.gui.editor.rename(old, updated);
                return updated;
            }
            BaseXDialog.error(this.gui, Util.info(Text.FILE_NOT_RENAMED_X, old));
        }
        return null;
    }

    void open(IOFile file, String search) {
        EditorArea ea = this.gui.editor.open(file);
        if (ea != null && !search.isEmpty()) {
            SwingUtilities.invokeLater(() -> ea.jump(search));
        }
    }

    private void chooseRoot() {
        ProjectNode child;
        IOFile file = ((child = this.tree.selectedNode()) != null ? child : this.root).file;
        BaseXFileChooser fc = new BaseXFileChooser(this.gui, Text.CHOOSE_DIR, file.path());
        IOFile io = fc.select(BaseXFileChooser.Mode.DOPEN);
        if (io != null) {
            this.rootPath.setText(io.normalize().path());
            this.rootPath.updateHistory();
        }
    }

    private void changeRoot() {
        IOFile path = new IOFile(this.rootPath.getText());
        if (this.root.file.eq(path)) {
            return;
        }
        this.gui.gopts.setFile(GUIOptions.PROJECTPATH, path);
        this.gui.saveOptions();
        this.root.file = path;
        this.root.refresh();
        this.refresh();
    }
}

