/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.basex.core.Text;
import org.basex.core.cmd.Test;
import org.basex.gui.GUI;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.view.project.ProjectCellEditor;
import org.basex.gui.view.project.ProjectCellRenderer;
import org.basex.gui.view.project.ProjectDir;
import org.basex.gui.view.project.ProjectNode;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;
import org.basex.query.value.node.DBNode;
import org.basex.util.Util;

final class ProjectTree
extends BaseXTree
implements TreeWillExpandListener {
    private final ProjectView view;

    ProjectTree(ProjectView view) {
        super(view.gui, new DefaultMutableTreeNode());
        this.view = view;
        this.border(4, 4, 4, 4);
        this.setExpandsSelectedPaths(true);
        ProjectCellRenderer renderer = new ProjectCellRenderer();
        this.setCellRenderer(renderer);
        this.addTreeWillExpandListener(this);
        this.addMouseListener(e -> {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                new OpenCmd().execute(view.gui);
            }
        });
        this.setCellEditor(new ProjectCellEditor(this, renderer));
        this.setEditable(true);
        int h = this.getFontMetrics(this.getFont()).getHeight();
        if (h > 16) {
            this.setRowHeight(Math.max(32, h));
        }
        new BaseXPopup(this, view.gui, new OpenCmd(), new OpenExternalCmd(), new TestCmd(), new SetContextCmd(), null, new DeleteCmd(), new RenameCmd(), new NewDirCmd(), null, new RefreshCmd(), null, new CopyPathCmd());
    }

    void init(ProjectNode node) {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).add(node);
        for (int r = 0; r < 2; ++r) {
            this.expandRow(r);
        }
        this.setRootVisible(false);
        this.setSelectionRow(0);
    }

    boolean expand(ProjectNode node, String path) {
        TreePath tp = node.path();
        if (!this.isExpanded(tp)) {
            this.expandPath(tp);
        }
        int ns = node.getChildCount();
        for (int n = 0; n < ns; ++n) {
            ProjectNode ch = (ProjectNode)node.getChildAt(n);
            String np = ch.file.path();
            if (path.equals(np)) {
                TreePath cp = ch.path();
                this.setSelectionPath(cp);
                this.scrollPathToVisible(cp);
                return true;
            }
            if (!path.startsWith(np)) continue;
            return this.expand(ch, path);
        }
        return false;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) {
        Object obj = event.getPath().getLastPathComponent();
        if (obj instanceof ProjectNode) {
            ProjectNode node = (ProjectNode)obj;
            node.expand();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) {
        Object obj = event.getPath().getLastPathComponent();
        if (obj instanceof ProjectNode) {
            ProjectNode node = (ProjectNode)obj;
            node.collapse();
        }
    }

    ProjectNode selectedNode() {
        Object node;
        TreePath tp = this.selectedPath();
        if (tp != null && (node = tp.getLastPathComponent()) instanceof ProjectNode) {
            return (ProjectNode)node;
        }
        return null;
    }

    private ArrayList<ProjectNode> selectedNodes() {
        ArrayList<ProjectNode> nodes = new ArrayList<ProjectNode>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath tp : paths) {
                Object node = tp.getLastPathComponent();
                if (!(node instanceof ProjectNode)) continue;
                nodes.add((ProjectNode)node);
            }
        }
        return nodes;
    }

    private TreePath selectedPath() {
        TreePath[] tps = this.getSelectionPaths();
        return tps == null || tps.length > 1 ? null : tps[0];
    }

    private final class SetContextCmd
    extends GUIPopupCmd {
        SetContextCmd() {
            super(Text.SET_CONTEXT, new BaseXKeys[0]);
        }

        @Override
        public void execute() {
            try {
                ((ProjectTree)ProjectTree.this).view.gui.editor.setContext(new DBNode(ProjectTree.this.selectedNode().file));
            }
            catch (IOException ex) {
                Util.debug(ex);
                BaseXDialog.error(((ProjectTree)ProjectTree.this).view.gui, Util.info(ex, new Object[0]));
            }
        }

        @Override
        public boolean enabled(GUI main) {
            ProjectNode pn = ProjectTree.this.selectedNode();
            return pn != null && !pn.file.isDir() && pn.file.hasSuffix(((ProjectTree)ProjectTree.this).view.gui.gopts.xmlSuffixes());
        }
    }

    private final class CopyPathCmd
    extends GUIPopupCmd {
        CopyPathCmd() {
            super(Text.COPY_PATH, BaseXKeys.COPYPATH);
        }

        @Override
        public void execute() {
            BaseXLayout.copyPath(ProjectTree.this.selectedNode().file.path());
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectTree.this.selectedNode() != null;
        }
    }

    private final class TestCmd
    extends GUIPopupCmd {
        TestCmd() {
            super(Text.RUN_TESTS, BaseXKeys.UNIT);
        }

        @Override
        public void execute() {
            for (ProjectNode node : ProjectTree.this.selectedNodes()) {
                ((ProjectTree)ProjectTree.this).view.gui.execute(new Test(node.file.path()));
            }
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectTree.this.selectedNode() != null;
        }
    }

    private final class OpenExternalCmd
    extends GUIPopupCmd {
        OpenExternalCmd() {
            super(Text.OPEN_EXTERNALLY, BaseXKeys.SHIFT_ENTER);
        }

        @Override
        public void execute() {
            for (ProjectNode node : ProjectTree.this.selectedNodes()) {
                try {
                    node.file.open();
                }
                catch (IOException ex) {
                    Util.debug(ex);
                    BaseXDialog.error(((ProjectTree)ProjectTree.this).view.gui, Util.info(Text.FILE_NOT_OPENED_X, node.file));
                }
            }
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectTree.this.selectedNode() != null;
        }
    }

    private final class OpenCmd
    extends GUIPopupCmd {
        OpenCmd() {
            super(Text.OPEN, BaseXKeys.ENTER);
        }

        @Override
        public void execute() {
            for (ProjectNode node : ProjectTree.this.selectedNodes()) {
                ProjectTree.this.view.open(node.file, "");
            }
        }

        @Override
        public boolean enabled(GUI main) {
            for (ProjectNode node : ProjectTree.this.selectedNodes()) {
                if (!node.file.isDir()) continue;
                return false;
            }
            return true;
        }
    }

    private final class RenameCmd
    extends GUIPopupCmd {
        RenameCmd() {
            super(Text.RENAME, BaseXKeys.RENAME);
        }

        @Override
        public void execute() {
            ProjectTree.this.startEditingAtPath(ProjectTree.this.selectedNode().path());
            ProjectTree.this.view.refresh();
        }

        @Override
        public boolean enabled(GUI main) {
            ProjectNode node = ProjectTree.this.selectedNode();
            return node != null && !node.root();
        }
    }

    private final class DeleteCmd
    extends GUIPopupCmd {
        DeleteCmd() {
            super(Text.DELETE + "...", BaseXKeys.DELNEXT);
        }

        @Override
        public void execute() {
            ProjectNode node = ProjectTree.this.selectedNode();
            GUI gui = ((ProjectTree)ProjectTree.this).view.gui;
            if (BaseXDialog.confirm(gui, Util.info(Text.DELETE_FILE_X, node.file))) {
                ProjectNode parent = (ProjectNode)node.getParent();
                if (gui.editor.delete(node.file)) {
                    parent.refresh();
                    ProjectTree.this.setSelectionPath(parent.path());
                    ProjectTree.this.view.refresh();
                } else {
                    BaseXDialog.error(gui, Util.info(Text.FILE_NOT_DELETED_X, node.file));
                }
            }
        }

        @Override
        public boolean enabled(GUI main) {
            ProjectNode node = ProjectTree.this.selectedNode();
            return node != null && !node.root();
        }
    }

    private final class NewDirCmd
    extends GUIPopupCmd {
        NewDirCmd() {
            super(Text.NEW_DIR, BaseXKeys.NEWDIR);
        }

        @Override
        public void execute() {
            ProjectNode node = ProjectTree.this.selectedNode();
            ProjectNode dir = node instanceof ProjectDir ? node : (ProjectNode)node.getParent();
            String name = '(' + Text.NEW_DIR + ')';
            IOFile file = new IOFile(dir.file, name);
            int c = 1;
            while (file.exists()) {
                name = '(' + Text.NEW_DIR + ' ' + ++c + ')';
                file = new IOFile(dir.file, name);
            }
            if (file.md()) {
                dir.expand();
                String fn = name;
                new Thread(() -> {
                    Enumeration<TreeNode> children = dir.children();
                    while (children.hasMoreElements()) {
                        ProjectNode child = (ProjectNode)children.nextElement();
                        if (child.file == null || !child.file.name().equals(fn)) continue;
                        TreePath tp = child.path();
                        ProjectTree.this.setSelectionPath(tp);
                        ProjectTree.this.startEditingAtPath(tp);
                        break;
                    }
                }).start();
            }
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectTree.this.selectedNode() != null;
        }
    }

    private final class RefreshCmd
    extends GUIPopupCmd {
        RefreshCmd() {
            super(Text.REFRESH, BaseXKeys.REFRESH);
        }

        @Override
        public void execute() {
            ProjectTree.this.view.refresh();
            ProjectTree.this.selectedNode().refresh();
        }

        @Override
        public boolean enabled(GUI main) {
            return ProjectTree.this.selectedNode() != null;
        }
    }
}

