/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.basex.core.Text;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.io.serial.SerializerOptions;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;

public final class BaseXSerial
extends BaseXBack
implements ActionListener {
    private static final int COMPT = 150;
    private final BaseXDialog dialog;
    private SerializerOptions sopts;
    private final BaseXCombo params;
    private final BaseXBack panel;
    private final BaseXLabel info;

    public BaseXSerial(BaseXDialog dialog, SerializerOptions sopts) {
        super(new RowLayout());
        this.add(new BaseXLabel(Text.SERIALIZATION + ":", true, true));
        this.panel = new BaseXBack(new ColumnLayout(8));
        this.dialog = dialog;
        this.params = new BaseXCombo((BaseXWindow)dialog, sopts.names());
        this.panel.add(this.params);
        this.add(this.panel);
        this.info = new BaseXLabel(sopts + " ").border(4, 0, 8, 0);
        this.info.setForeground(GUIConstants.dgray);
        this.add(this.info);
        this.params.addActionListener(this);
        this.init(sopts);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.update(this.sopts.option(this.params.getSelectedItem()), this.sopts, this.panel);
    }

    public SerializerOptions options() {
        return this.sopts;
    }

    public void init(SerializerOptions so) {
        this.sopts = new SerializerOptions(so);
        this.params.setSelectedItem(SerializerOptions.METHOD.name());
    }

    private void update(Option<?> option, Options options, BaseXBack p) {
        Component comp;
        while (p.getComponentCount() > 1) {
            p.remove(1);
        }
        if (option == SerializerOptions.ENCODING) {
            BaseXCombo combo = new BaseXCombo((BaseXWindow)this.dialog, Strings.encodings());
            combo.setSelectedItem(options.get(option));
            combo.addActionListener(e -> {
                options.set((StringOption)option, combo.getSelectedItem());
                this.update();
            });
            comp = combo;
        } else if (option instanceof StringOption) {
            comp = this.addInput(new BaseXTextField(this.dialog, (StringOption)option, options));
        } else if (option instanceof NumberOption) {
            comp = this.addInput(new BaseXTextField(this.dialog, (NumberOption)option, options));
        } else if (option instanceof BooleanOption) {
            comp = this.addCombo(new BaseXCombo((BaseXWindow)this.dialog, (BooleanOption)option, options));
        } else if (option instanceof EnumOption) {
            comp = this.addCombo(new BaseXCombo((BaseXWindow)this.dialog, (EnumOption)option, options));
        } else if (option instanceof OptionsOption) {
            comp = this.addOption((OptionsOption)option, options);
        } else {
            throw Util.notExpected("Unknown option type: " + option, new Object[0]);
        }
        p.add(comp);
        p.revalidate();
        p.repaint();
    }

    private Component addInput(BaseXTextField text) {
        text.addKeyListener(e -> {
            text.assign();
            this.update();
        });
        BaseXLayout.setWidth(text, 150);
        this.panel.add(text);
        return text;
    }

    private Component addCombo(BaseXCombo combo) {
        combo.addActionListener(e -> {
            combo.assign();
            this.update();
        });
        this.panel.add(combo);
        return combo;
    }

    private Component addOption(OptionsOption<?> option, Options options) {
        BaseXBack p = new BaseXBack(new ColumnLayout(8));
        Object opts = options.get(option);
        options.put(option, opts);
        BaseXCombo combo = new BaseXCombo((BaseXWindow)this.dialog, ((Options)opts).names());
        combo.addActionListener(e -> this.update(opts.option(combo.getSelectedItem()), (Options)opts, p));
        p.add(combo);
        return p;
    }

    private void update() {
        this.info.setText(this.sopts.toString());
    }
}

