/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.users;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.core.users.UserText;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLAccess;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class Users {
    private final LinkedHashMap<String, User> users = new LinkedHashMap();
    private final IOFile file;
    private ANode info;

    public Users(StaticOptions sopts) {
        this.file = sopts.dbPath(Token.string(UserText.USERS) + ".xml");
        this.read();
        if (this.get("admin") == null) {
            this.add(new User("admin", "admin").perm(Perm.ADMIN));
        }
    }

    private void read() {
        if (!this.file.exists()) {
            return;
        }
        try {
            IOContent content = new IOContent(this.file.read(), this.file.path());
            MainOptions options = new MainOptions(false);
            options.set(MainOptions.INTPARSE, true);
            DBNode doc = new DBNode(Parser.singleParser(content, options, ""));
            ANode root = XMLAccess.children(doc, UserText.USERS).next();
            if (root == null) {
                Util.errln(this.file + ": No '%' root element.", new Object[]{UserText.USERS});
            } else {
                for (ANode child : XMLAccess.children(root)) {
                    byte[] qname = child.qname().id();
                    if (Token.eq(qname, UserText.USER)) {
                        try {
                            User user = new User(child);
                            String name = user.name();
                            if (this.users.get(name) != null) {
                                Util.errln(this.file + ": User '%' supplied more than once.", name);
                                continue;
                            }
                            this.users.put(name, user);
                        }
                        catch (BaseXException ex) {
                            Util.errln(this.file + ": " + ex.getLocalizedMessage(), new Object[0]);
                        }
                        continue;
                    }
                    if (Token.eq(qname, UserText.INFO)) {
                        if (this.info != null) {
                            Util.errln(this.file + ": occurs more than once: %.", new Object[]{qname});
                            continue;
                        }
                        this.info = child.finish();
                        continue;
                    }
                    Util.errln(this.file + ": invalid element: %.", new Object[]{qname});
                }
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() {
        LinkedHashMap<String, User> linkedHashMap = this.users;
        synchronized (linkedHashMap) {
            this.file.parent().md();
            FElem root = new FElem(UserText.USERS);
            for (User user : this.users.values()) {
                root.add(user.toXML(null));
            }
            if (this.info != null) {
                root.add(this.info);
                this.info.parent(null);
            }
            try {
                this.file.write(root.serialize().finish());
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(User user) {
        LinkedHashMap<String, User> linkedHashMap = this.users;
        synchronized (linkedHashMap) {
            this.users.put(user.name(), user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alter(User user, String name) {
        LinkedHashMap<String, User> linkedHashMap = this.users;
        synchronized (linkedHashMap) {
            this.users.remove(user.name());
            user.name(name);
            this.users.put(name, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(User user) {
        LinkedHashMap<String, User> linkedHashMap = this.users;
        synchronized (linkedHashMap) {
            return this.users.remove(user.name()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User get(String name) {
        LinkedHashMap<String, User> linkedHashMap = this.users;
        synchronized (linkedHashMap) {
            return this.users.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] find(Pattern pattern) {
        StringList sl = new StringList();
        LinkedHashMap<String, User> linkedHashMap = this.users;
        synchronized (linkedHashMap) {
            for (String name : this.users.keySet()) {
                if (!pattern.matcher(name).matches()) continue;
                sl.add(name);
            }
        }
        return (String[])sl.finish();
    }

    public Table info(String db, Context ctx) {
        Table table = new Table();
        table.description = Text.USERS_X;
        for (String user : UserText.S_USERINFO) {
            table.header.add(user);
        }
        for (User user : this.users(db, ctx)) {
            table.contents.add(new TokenList().add(user.name()).add(user.perm(db).toString()));
        }
        return table.sort().toTop(Token.token("admin"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<User> users(String db, Context ctx) {
        User curr = ctx.user();
        boolean admin = curr.has(Perm.ADMIN);
        ArrayList<User> list = new ArrayList<User>();
        LinkedHashMap<String, User> linkedHashMap = this.users;
        synchronized (linkedHashMap) {
            for (User user : this.users.values()) {
                if (!admin && curr != user) continue;
                if (db == null) {
                    list.add(user);
                    continue;
                }
                Map.Entry<String, Perm> entry = user.find(db);
                if (entry == null) continue;
                list.add(user);
            }
        }
        return list;
    }

    public ANode info() {
        return this.info;
    }

    public void info(ANode elem) {
        this.info = elem.hasChildren() || elem.attributeIter().size() != 0L ? elem : null;
    }
}

