/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.QueryJobResult;
import org.basex.core.jobs.QueryJobTask;
import org.basex.util.Performance;

public final class JobPool {
    static final int MAXQUERIES = 1000;
    public final Map<String, Job> active = new ConcurrentHashMap<String, Job>();
    public final Map<String, QueryJobResult> results = new ConcurrentHashMap<String, QueryJobResult>();
    public final Map<String, QueryJobTask> tasks = new ConcurrentHashMap<String, QueryJobTask>();
    final Timer timer = new Timer(true);
    private final long timeout;

    public JobPool(StaticOptions sopts) {
        this.timeout = (long)sopts.get(StaticOptions.CACHETIMEOUT).intValue() * 1000L;
    }

    public void register(Job job) {
        while (this.active.size() >= 1000) {
            Performance.sleep(1L);
        }
        this.active.put(job.jc().id(), job);
    }

    public void unregister(Job job) {
        this.active.remove(job.jc().id());
    }

    public synchronized void close() {
        this.timer.cancel();
        for (Job job : this.active.values()) {
            job.stop();
        }
        while (!this.active.isEmpty()) {
            Performance.sleep(1L);
        }
    }

    public void scheduleResult(final Job job) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                JobPool.this.results.remove(job.jc().id());
            }
        }, this.timeout);
    }
}

