/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.SingleParser;
import org.basex.build.xml.CatalogWrapper;
import org.basex.build.xml.SAXHandler;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.JobException;
import org.basex.io.IO;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.io.parse.xml.XmlParser;
import org.basex.util.Util;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SAXWrapper
extends SingleParser {
    private long bytes;
    private int lines;
    private SAXHandler saxh;
    private long length;

    public SAXWrapper(IO source, MainOptions opts) {
        super(source, opts);
    }

    @Override
    public void parse() throws IOException {
        InputSource is = this.inputSource();
        SAXSource saxs = new SAXSource(is);
        try {
            XMLReader reader = saxs.getXMLReader();
            if (reader == null) {
                reader = XmlParser.reader(this.options.get(MainOptions.DTD), this.options.get(MainOptions.XINCLUDE));
            }
            this.saxh = new SAXHandler(this.builder, this.options.get(MainOptions.CHOP), this.options.get(MainOptions.STRIPNS));
            CatalogWrapper cw = CatalogWrapper.get(this.options.get(MainOptions.CATFILE));
            if (cw != null) {
                reader.setEntityResolver(cw.getEntityResolver());
            }
            reader.setDTDHandler(this.saxh);
            reader.setContentHandler(this.saxh);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.saxh);
            reader.setErrorHandler(this.saxh);
            reader.parse(is);
        }
        catch (SAXParseException ex) {
            String msg = Util.info(Text.SCANPOS_X_X, this.source.path(), ex.getLineNumber(), ex.getColumnNumber()) + ": " + Util.message(ex);
            throw new IOException(msg, ex);
        }
        catch (JobException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException('\"' + this.source.path() + '\"' + Util.message(ex), ex);
        }
        finally {
            Reader r = is.getCharacterStream();
            Throwable throwable = null;
            if (r != null) {
                if (throwable != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    r.close();
                }
            }
            InputStream ist = is.getByteStream();
            throwable = null;
            if (ist != null) {
                if (throwable != null) {
                    try {
                        ist.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ist.close();
                }
            }
        }
    }

    private InputSource inputSource() throws IOException {
        final InputStream input = this.source.inputStream();
        this.length = this.source.length();
        try {
            if (this.length <= 0L) {
                this.length = input.available();
            }
        }
        catch (IOException ex) {
            input.close();
            throw ex;
        }
        InputStream wrapped = new InputStream(){
            final InputStream buffer;
            {
                this.buffer = input instanceof ByteArrayInputStream || input instanceof ArrayInput ? input : BufferInput.get(input);
            }

            @Override
            public int read() throws IOException {
                int i = this.buffer.read();
                if (i == 10) {
                    ++SAXWrapper.this.lines;
                }
                ++SAXWrapper.this.bytes;
                return i;
            }

            @Override
            public void close() throws IOException {
                this.buffer.close();
            }
        };
        InputSource is = new InputSource(wrapped);
        is.setSystemId(this.source.url());
        return is;
    }

    @Override
    public String detailedInfo() {
        return this.length == 0L ? super.detailedInfo() : Util.info(Text.SCANPOS_X_X, this.source.name(), this.lines + 1);
    }

    @Override
    public double progressInfo() {
        return this.length == 0L ? (this.saxh == null ? 0.0 : (double)this.saxh.nodes / 3000000.0 % 1.0) : (double)this.bytes / (double)this.length;
    }
}

