/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.csv;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.csv.CsvParserOptions;
import org.basex.core.Text;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.value.item.Str;
import org.basex.util.Atts;
import org.basex.util.Util;
import org.basex.util.XMLToken;

final class CsvBuilder
extends CsvConverter {
    private final Atts atts = new Atts();
    private final Atts nsp = new Atts();
    private boolean record;
    private final Builder builder;
    private int line;

    CsvBuilder(CsvParserOptions opts, Builder builder) throws IOException {
        super(opts);
        this.builder = builder;
        builder.openElem(CsvConverter.CSV, this.atts, this.nsp);
    }

    @Override
    public void record() throws IOException {
        if (this.record) {
            this.builder.closeElem();
        }
        this.builder.openElem(RECORD, this.atts, this.nsp);
        this.record = true;
        this.col = 0;
        ++this.line;
    }

    @Override
    public void header(byte[] value) {
        this.headers.add(this.ats ? value : XMLToken.encode(value, this.lax));
    }

    @Override
    public void entry(byte[] entry) throws IOException {
        byte[] elem = ENTRY;
        byte[] name = (byte[])this.headers.get(this.col++);
        if (this.ats) {
            if (name == null) {
                this.builder.openElem(elem, this.atts, this.nsp);
            } else {
                this.atts.add(NAME, name);
                this.builder.openElem(elem, this.atts, this.nsp);
                this.atts.reset();
            }
        } else {
            this.builder.openElem(name != null ? name : elem, this.atts, this.nsp);
        }
        this.builder.text(entry);
        this.builder.closeElem();
    }

    @Override
    protected void init(String uri) {
    }

    @Override
    protected Str finish() throws IOException {
        if (this.record) {
            this.builder.closeElem();
        }
        this.builder.closeElem();
        return null;
    }

    @Override
    public String detailedInfo() {
        return Util.info(Text.LINE_X, this.line);
    }

    @Override
    public double progressInfo() {
        return (double)this.nli.size() / (double)this.nli.length();
    }
}

