/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Check;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.io.IOFile;
import org.basex.util.Main;
import org.basex.util.MainParser;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class BaseXGUI
extends Main {
    private final Context context = new Context();
    private final StringList files = new StringList(0L);

    public static void main(String ... args) {
        try {
            new BaseXGUI(args);
        }
        catch (BaseXException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseXGUI(String ... args) throws BaseXException {
        super(args);
        this.parseArgs();
        JFrame splash = BaseXGUI.splash();
        GUIOptions gopts = new GUIOptions();
        BaseXGUI.init(gopts);
        GUIConstants.init(gopts);
        SwingUtilities.invokeLater(() -> {
            GUI gui = new GUI(this.context, gopts);
            splash.dispose();
            ArrayList<IOFile> xqfiles = new ArrayList<IOFile>();
            for (String file : (String[])this.files.finish()) {
                if (file.contains(".basex")) continue;
                IOFile io = new IOFile(file);
                boolean xml = file.endsWith(".xml");
                if (xml && BaseXDialog.confirm(gui, Util.info(Text.CREATE_DB_FILE, io))) {
                    gopts.setFile(GUIOptions.INPUTPATH, io);
                    gopts.set(GUIOptions.DBNAME, io.dbName());
                    DialogProgress.execute(gui, new Check(file));
                    continue;
                }
                xqfiles.add(io);
            }
            gui.editor.init(xqfiles);
        });
        Runtime.getRuntime().addShutdownHook(new Thread(this.context::close));
    }

    private static JFrame splash() {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        f.setAlwaysOnTop(true);
        f.setUndecorated(true);
        f.setIconImage(BaseXImages.get("logo_64"));
        f.add(new JLabel(BaseXImages.icon("logo_256")));
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
        return f;
    }

    private static void init(GUIOptions opts) {
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            String laf = opts.get(GUIOptions.LOOKANDFEEL);
            UIManager.setLookAndFeel(laf.isEmpty() ? UIManager.getSystemLookAndFeelClassName() : laf);
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
    }

    @Override
    protected void parseArgs() throws BaseXException {
        MainParser arg = new MainParser(this);
        while (arg.more()) {
            if (arg.dash()) {
                char c = arg.next();
                if (c == 'd') {
                    Prop.debug = true;
                    continue;
                }
                throw arg.usage();
            }
            this.files.add(arg.string());
        }
    }

    @Override
    public String header() {
        return Util.info(Text.S_CONSOLE_X, "GUI");
    }

    @Override
    public String usage() {
        return Text.S_GUIINFO;
    }
}

