
# Copyright (c) 2020-2021 CJ Kucera (cj@apocalyptech.com)
# 
# This software is provided 'as-is', without any express or implied warranty.
# In no event will the authors be held liable for any damages arising from
# the use of this software.
# 
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 
# 1. The origin of this software must not be misrepresented; you must not
#    claim that you wrote the original software. If you use this software in a
#    product, an acknowledgment in the product documentation would be
#    appreciated but is not required.
# 
# 2. Altered source versions must be plainly marked as such, and must not be
#    misrepresented as being the original software.
# 
# 3. This notice may not be removed or altered from any source distribution.

# Editor Version
__version__ = '1.14.0'

# Classes
(BEASTMASTER, GUNNER, OPERATIVE, SIREN) = range(4)
class_to_eng = {
        BEASTMASTER: 'Beastmaster',
        GUNNER: 'Gunner',
        OPERATIVE: 'Operative',
        SIREN: 'Siren',
        }
classobj_to_class = {
        '/Game/PlayerCharacters/Beastmaster/PlayerClassId_Beastmaster.PlayerClassId_Beastmaster': BEASTMASTER,
        '/Game/PlayerCharacters/Gunner/PlayerClassId_Gunner.PlayerClassId_Gunner': GUNNER,
        '/Game/PlayerCharacters/Operative/PlayerClassId_Operative.PlayerClassId_Operative': OPERATIVE,
        '/Game/PlayerCharacters/SirenBrawler/PlayerClassId_Siren.PlayerClassId_Siren': SIREN,
        }

# Pets
# TODO (ish): Looks like there's currently no support for renaming your Loader
# pet.  Make sure to add that in, if they ever get that in the game.  (I did try
# just injecting some data even though there's no in-game UI, and couldn't
# find a string that worked.)
(JABBER, SPIDERANT, SKAG) = range(3)
pet_to_eng = {
        JABBER: 'Jabber',
        SPIDERANT: 'Spiderant',
        SKAG: 'Skag',
        }
petkey_to_pet = {
        'petmonkey': JABBER,
        'petspiderant': SPIDERANT,
        'petskag': SKAG,
        }
pet_to_petkey = {v: k for k, v in petkey_to_pet.items()}

# Currencies
(MONEY, ERIDIUM) = range(2)
currency_to_eng = {
        MONEY: 'Money',
        ERIDIUM: 'Eridium',
        }
currency_to_curhash = {
        MONEY: 618814354,
        ERIDIUM: 3679636065
        }
curhash_to_currency = {v: k for k, v in currency_to_curhash.items()}

# Inventory Slots
(WEAPON1, WEAPON2, WEAPON3, WEAPON4, SHIELD, GRENADE, COM, ARTIFACT) = range(8)
slot_to_eng = {
        WEAPON1: 'Weapon 1',
        WEAPON2: 'Weapon 2',
        WEAPON3: 'Weapon 3',
        WEAPON4: 'Weapon 4',
        SHIELD: 'Shield',
        GRENADE: 'Grenade',
        COM: 'COM',
        ARTIFACT: 'Artifact',
}
slotobj_to_slot = {
        '/Game/Gear/Weapons/_Shared/_Design/InventorySlots/BPInvSlot_Weapon1.BPInvSlot_Weapon1': WEAPON1,
        '/Game/Gear/Weapons/_Shared/_Design/InventorySlots/BPInvSlot_Weapon2.BPInvSlot_Weapon2': WEAPON2,
        '/Game/Gear/Weapons/_Shared/_Design/InventorySlots/BPInvSlot_Weapon3.BPInvSlot_Weapon3': WEAPON3,
        '/Game/Gear/Weapons/_Shared/_Design/InventorySlots/BPInvSlot_Weapon4.BPInvSlot_Weapon4': WEAPON4,
        '/Game/Gear/Shields/_Design/A_Data/BPInvSlot_Shield.BPInvSlot_Shield': SHIELD,
        '/Game/Gear/GrenadeMods/_Design/A_Data/BPInvSlot_GrenadeMod.BPInvSlot_GrenadeMod': GRENADE,
        '/Game/Gear/ClassMods/_Design/_Data/BPInvSlot_ClassMod.BPInvSlot_ClassMod': COM,
        '/Game/Gear/Artifacts/_Design/_Data/BPInvSlot_Artifact.BPInvSlot_Artifact': ARTIFACT,
        }
slot_to_slotobj = {v: k for k, v in slotobj_to_slot.items()}

# SDUs
(SDU_BACKPACK, SDU_AR, SDU_PISTOL, SDU_SNIPER, SDU_SHOTGUN, SDU_GRENADE, SDU_SMG, SDU_HEAVY) = range(8)
ammo_sdus = [SDU_AR, SDU_PISTOL, SDU_SNIPER, SDU_SHOTGUN, SDU_GRENADE, SDU_SMG, SDU_HEAVY]
sdu_to_eng = {
        SDU_BACKPACK: 'Backpack',
        SDU_AR: 'AR',
        SDU_PISTOL: 'Pistol',
        SDU_SNIPER: 'Sniper',
        SDU_SHOTGUN: 'Shotgun',
        SDU_GRENADE: 'Grenade',
        SDU_SMG: 'SMG',
        SDU_HEAVY: 'Heavy',
        }
sduobj_to_sdu = {
        '/Game/Pickups/SDU/SDU_Backpack.SDU_Backpack': SDU_BACKPACK,
        '/Game/Pickups/SDU/SDU_AssaultRifle.SDU_AssaultRifle': SDU_AR,
        '/Game/Pickups/SDU/SDU_Pistol.SDU_Pistol': SDU_PISTOL,
        '/Game/Pickups/SDU/SDU_SniperRifle.SDU_SniperRifle': SDU_SNIPER,
        '/Game/Pickups/SDU/SDU_Shotgun.SDU_Shotgun': SDU_SHOTGUN,
        '/Game/Pickups/SDU/SDU_Grenade.SDU_Grenade': SDU_GRENADE,
        '/Game/Pickups/SDU/SDU_SMG.SDU_SMG': SDU_SMG,
        '/Game/Pickups/SDU/SDU_Heavy.SDU_Heavy': SDU_HEAVY,
        }
sdu_to_sduobj = {v: k for k, v in sduobj_to_sdu.items()}
sdu_to_max = {
        SDU_BACKPACK: 13,
        SDU_AR: 10,
        SDU_PISTOL: 10,
        SDU_SNIPER: 13,
        SDU_SHOTGUN: 10,
        SDU_GRENADE: 10,
        SDU_SMG: 10,
        SDU_HEAVY: 13,
        }

# Profile SDUs
(PSDU_LOSTLOOT, PSDU_BANK) = range(2)
psdu_to_eng = {
        PSDU_LOSTLOOT: 'Lost Loot',
        PSDU_BANK: 'Bank',
        }
psduobj_to_psdu = {
        '/Game/Pickups/SDU/SDU_LostLoot.SDU_LostLoot': PSDU_LOSTLOOT,
        '/Game/Pickups/SDU/SDU_Bank.SDU_Bank': PSDU_BANK,
        }
psdu_to_psduobj = {v: k for k, v in psduobj_to_psdu.items()}
psdu_to_max = {
        PSDU_LOSTLOOT: 10,
        PSDU_BANK: 23,
        }

# Ammo
(AMMO_AR, AMMO_GRENADE, AMMO_HEAVY, AMMO_PISTOL, AMMO_SMG, AMMO_SHOTGUN, AMMO_SNIPER) = range(7)
ammo_to_eng = {
        AMMO_AR: 'AR',
        AMMO_GRENADE: 'Grenade',
        AMMO_HEAVY: 'Heavy',
        AMMO_PISTOL: 'Pistol',
        AMMO_SMG: 'SMG',
        AMMO_SHOTGUN: 'Shotgun',
        AMMO_SNIPER: 'Sniper',
        }
ammoobj_to_ammo = {
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_AssaultRifle.Resource_Ammo_AssaultRifle': AMMO_AR,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Grenade.Resource_Ammo_Grenade': AMMO_GRENADE,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Heavy.Resource_Ammo_Heavy': AMMO_HEAVY,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Pistol.Resource_Ammo_Pistol': AMMO_PISTOL,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_SMG.Resource_Ammo_SMG': AMMO_SMG,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Shotgun.Resource_Ammo_Shotgun': AMMO_SHOTGUN,
        '/Game/GameData/Weapons/Ammo/Resource_Ammo_Sniper.Resource_Ammo_Sniper': AMMO_SNIPER,
        }
ammo_to_ammoobj = {v: k for k, v in ammoobj_to_ammo.items()}
ammo_to_max = {
        AMMO_AR: 1680,
        AMMO_GRENADE: 13,
        AMMO_HEAVY: 51,
        AMMO_PISTOL: 1200,
        AMMO_SMG: 2160,
        AMMO_SHOTGUN: 280,
        AMMO_SNIPER: 204,
        }

# Challenges
(ERIDIAN_ANALYZER,
        ERIDIAN_RESONATOR,
        MAYHEM,
        CHAL_ARTIFACT,
        COM_BEASTMASTER,
        COM_GUNNER,
        COM_OPERATIVE,
        COM_SIREN,
        ) = range(8)
challenge_to_eng = {
        ERIDIAN_ANALYZER: 'Eridian Analyzer',
        ERIDIAN_RESONATOR: 'Eridian Resonator',
        MAYHEM: 'Mayhem Mode',
        CHAL_ARTIFACT: 'Artifact Slot',
        COM_BEASTMASTER: 'Beastmaster COM Slot',
        COM_GUNNER: 'Gunner COM Slot',
        COM_OPERATIVE: 'Operative COM Slot',
        COM_SIREN: 'Siren COM Slot',
        }
challenge_char_lock = {
        COM_BEASTMASTER: BEASTMASTER,
        COM_GUNNER: GUNNER,
        COM_OPERATIVE: OPERATIVE,
        COM_SIREN: SIREN,
        }
challengeobj_to_challenge = {
        '/Game/GameData/Challenges/Account/Challenge_VaultReward_Analyzer.Challenge_VaultReward_Analyzer_C': ERIDIAN_ANALYZER,
        '/Game/GameData/Challenges/Account/Challenge_VaultReward_Resonator.Challenge_VaultReward_Resonator_C': ERIDIAN_RESONATOR,
        '/Game/GameData/Challenges/Account/Challenge_VaultReward_Mayhem.Challenge_VaultReward_Mayhem_C': MAYHEM,
        '/Game/GameData/Challenges/Account/Challenge_VaultReward_ArtifactSlot.Challenge_VaultReward_ArtifactSlot_C': CHAL_ARTIFACT,
        '/Game/GameData/Challenges/Character/Beastmaster/BP_Challenge_Beastmaster_ClassMod.BP_Challenge_Beastmaster_ClassMod_C': COM_BEASTMASTER,
        '/Game/GameData/Challenges/Character/Gunner/BP_Challenge_Gunner_ClassMod.BP_Challenge_Gunner_ClassMod_C': COM_GUNNER,
        '/Game/GameData/Challenges/Character/Operative/BP_Challenge_Operative_ClassMod.BP_Challenge_Operative_ClassMod_C': COM_OPERATIVE,
        '/Game/GameData/Challenges/Character/Siren/BP_Challenge_Siren_ClassMod.BP_Challenge_Siren_ClassMod_C': COM_SIREN,

        # This alone is not sufficient to unlock Sanctuary early
        #'/Game/GameData/Challenges/FastTravel/Challenge_FastTravel_Sanctuary3_2.Challenge_FastTravel_Sanctuary3_2_C': FOO,

        # Unlocking Fabricator really doesn't interest me; I think you'd need the item drop to go along with it, too.
        #'/Game/GameData/Challenges/Account/Challenge_VaultReward_Fabricator.Challenge_VaultReward_Fabricator_C': FOO,

        # Also, where are the other two gun slots?
        }
challenge_to_challengeobj = {v: k for k, v in challengeobj_to_challenge.items()}

# Level-based challenges (probably unimportant, but I've already started doing it,
# so here we go anyway)
level_stat = '/Game/PlayerCharacters/_Shared/_Design/Stats/Character/Stat_Character_Level.Stat_Character_Level'
level_challenges = [
        (2, '/Game/GameData/Challenges/System/BP_Challenge_Console_1.BP_Challenge_Console_1_C'),
        (10, '/Game/GameData/Challenges/System/BP_Challenge_Console_2.BP_Challenge_Console_2_C'),
        (25, '/Game/GameData/Challenges/System/BP_Challenge_Console_3.BP_Challenge_Console_3_C'),
        (50, '/Game/GameData/Challenges/System/BP_Challenge_Console_4.BP_Challenge_Console_4_C'),
        ]

# Borderlands Science
borderlands_science_levels = [
        (5, "Claptrap"),
        (10, "Brick"),
        (15, "Mordecai"),
        (20, "Torgue"),
        (25, "Marcus"),
        (30, "Ellie"),
        (35, "Lilith"),
        (40, "Mad Moxxi"),
        (50, "Tannis"),
        (0, "True Tannis")
        ]

# Vehicle info.  We're not doing as much object-to-english mapping stuff here, 'cause
# I don't care enough to code it into the editor.  Just doing some more general
# "unlock all" type activity.
(OUTRUNNER, TECHNICAL, CYCLONE, JETBEAST) = range(4)
vehicle_to_eng = {
        OUTRUNNER: 'Outrunner',
        TECHNICAL: 'Technical',
        CYCLONE: 'Cyclone',
        JETBEAST: 'Jetbeast',
        }
vehicle_chassis = {
        OUTRUNNER: set([
            '/Game/Vehicles/Outrunner/Design/WT_Outrunner_BuggyWheels.WT_Outrunner_BuggyWheels',
            '/Game/Vehicles/Outrunner/Design/WT_Outrunner_HoverWheels.WT_Outrunner_HoverWheels',
            '/Game/Vehicles/Outrunner/Design/WT_Outrunner_TwitchyWheels.WT_Outrunner_TwitchyWheels',
            '/Game/Vehicles/Outrunner/Design/WT_Outrunner_ZipWheels.WT_Outrunner_ZipWheels',
            ]),
        TECHNICAL: set([
            '/Game/Vehicles/Technical/Design/WT_Technical_AllTerrainWheels.WT_Technical_AllTerrainWheels',
            '/Game/Vehicles/Technical/Design/WT_Technical_BarbedWheels.WT_Technical_BarbedWheels',
            '/Game/Vehicles/Technical/Design/WT_Technical_HoverWheels.WT_Technical_HoverWheels',
            '/Game/Vehicles/Technical/Design/WT_Technical_MonsterWheels.WT_Technical_MonsterWheels',
            ]),
        CYCLONE: set([
            '/Game/Vehicles/Revolver/Design/WT_Revolver_DualWheel.WT_Revolver_DualWheel',
            '/Game/Vehicles/Revolver/Design/WT_Revolver_HoverWheel.WT_Revolver_HoverWheel',
            '/Game/Vehicles/Revolver/Design/WT_Revolver_MonoWheel.WT_Revolver_MonoWheel',
            '/Game/Vehicles/Revolver/Design/WT_Revolver_WIdeWheel.WT_Revolver_WIdeWheel',
            ]),
        JETBEAST: set([
            # This one's technically in the saves, but is there by default and isn't available on its own.
            #'/Geranium/Vehicles/Horse/Design/WT_Horse_Base.WT_Horse_Base',
            '/Geranium/Vehicles/Horse/Design/WT_Horse_Biobeast.WT_Horse_Biobeast',
            '/Geranium/Vehicles/Horse/Design/WT_Horse_Predator.WT_Horse_Predator',
            '/Geranium/Vehicles/Horse/Design/WT_Horse_Tyrant.WT_Horse_Tyrant',
            ]),
        }
# Chassis types to *not* unlock.  Added for DLC3 since the game is apparently hardcoded to
# unlock the main Jetbeast type, and will do so even if we've already unlocked it, which
# makes it show up in the list twice.  This doesn't actually seem to cause any problems, but
# it bothers me, so an `excluders` for unlocking it is.
jetbeast_main_chassis = '/Geranium/Vehicles/Horse/Design/WT_Horse_Biobeast.WT_Horse_Biobeast'
chassis_excluders = set([
    jetbeast_main_chassis,
    ])
chassis_to_vehicle = {}
for vehicle, chassislist in vehicle_chassis.items():
    for chassis in chassislist:
        chassis_to_vehicle[chassis] = vehicle
vehicle_parts = {
        OUTRUNNER: set([
            '/Game/Vehicles/Outrunner/Design/Parts/Armor/VehiclePart_Outrunner_Armor_BasicArmor.VehiclePart_Outrunner_Armor_BasicArmor',
            '/Game/Vehicles/Outrunner/Design/Parts/Armor/VehiclePart_Outrunner_Armor_HeavyArmor.VehiclePart_Outrunner_Armor_HeavyArmor',
            '/Game/Vehicles/Outrunner/Design/Parts/CoreMod/BlazeBooster/VehiclePart_CoreMod_BlazeBooster.VehiclePart_CoreMod_BlazeBooster',
            '/Game/Vehicles/Outrunner/Design/Parts/CoreMod/BoostCanisters/VehiclePart_CoreMod_BoostCanisters.VehiclePart_CoreMod_BoostCanisters',
            '/Game/Vehicles/Outrunner/Design/Parts/CoreMod/EnergyCells/VehiclePart_CoreMod_EnergyCells.VehiclePart_CoreMod_EnergyCells',
            '/Game/Vehicles/Outrunner/Design/Parts/CoreMod/RazerWings/VehiclePart_CoreMod_RazerWings.VehiclePart_CoreMod_RazerWings',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_FlameThrower/FlameThrower/VehiclePart_WeaponDriver_FlameThrower_Native.VehiclePart_WeaponDriver_FlameThrower_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_FlameThrower/TeslaCoil/VehiclePart_WeaponDriver_TeslaCoil_Native.VehiclePart_WeaponDriver_TeslaCoil_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MachineGun/OutrunnerMachineGun/VehiclePart_WeaponDriver_OutrunnerMachineGun_Native.VehiclePart_WeaponDriver_OutrunnerMachineGun_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_MissileLauncher/HeavyMissile/VehiclePart_Weapon_HeavyMissile_Native.VehiclePart_Weapon_HeavyMissile_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_MissileLauncher/ShotgunMissile/VehiclePart_Weapon_ShotgunMissile_Native.VehiclePart_Weapon_ShotgunMissile_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_MissileLauncher/SwarmerMissile/VehiclePart_Weapon_SwarmerMissile_Native.VehiclePart_Weapon_SwarmerMissile_Native',
            ]),
        TECHNICAL: set([
            '/Game/Vehicles/Technical/Design/Parts/Accessory/FlatBed/VehiclePart_CoreMod_Flatbed.VehiclePart_CoreMod_Flatbed',
            '/Game/Vehicles/Technical/Design/Parts/Accessory/FuelBarrels/VehiclePart_CoreMod_FuelBarrels.VehiclePart_CoreMod_FuelBarrels',
            '/Game/Vehicles/Technical/Design/Parts/Accessory/JetBooster/VehiclePart_CoreMod_JetBooster.VehiclePart_CoreMod_JetBooster',
            '/Game/Vehicles/Technical/Design/Parts/Accessory/ToxicBooster/VehiclePart_CoreMod_ToxicBooster.VehiclePart_CoreMod_ToxicBooster',
            '/Game/Vehicles/Technical/Design/Parts/Armor/VehiclePart_Techincal_Armor_BasicArmor.VehiclePart_Techincal_Armor_BasicArmor',
            '/Game/Vehicles/Technical/Design/Parts/Armor/VehiclePart_Technical_Armor_HeavyArmor.VehiclePart_Technical_Armor_HeavyArmor',
            '/Game/Vehicles/Technical/Design/Parts/Armor/VehiclePart_Technical_Armor_MeatGrinder.VehiclePart_Technical_Armor_MeatGrinder',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MachineGun/FlakCannon/VehiclePart_WeaponDriver_FlakCannon_Native.VehiclePart_WeaponDriver_FlakCannon_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MachineGun/MachineGun/VehiclePart_WeaponDriver_MachineGun_Native.VehiclePart_WeaponDriver_MachineGun_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_Catapult/BarrelLauncher/VehiclePart_Weapon_BarrelLauncher_Native.VehiclePart_Weapon_BarrelLauncher_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_Catapult/PropelledBombsLauncher/VehiclePart_Weapon_PropelledBombsLauncher_Native.VehiclePart_Weapon_PropelledBombsLauncher_Native',
            '/Game/Vehicles/VehicleWeapons/GunnerWeapons/Type_Catapult/StickyBombLauncher/VehiclePart_Weapon_StickyBombs_Native.VehiclePart_Weapon_StickyBombs_Native',
            ]),
        CYCLONE: set([
            '/Game/Vehicles/Revolver/Design/Parts/Armor/VehiclePart_Revolver_Armor_BasicArmor.VehiclePart_Revolver_Armor_BasicArmor',
            '/Game/Vehicles/Revolver/Design/Parts/Armor/VehiclePart_Revolver_Armor_HeavyArmor.VehiclePart_Revolver_Armor_HeavyArmor',
            '/Game/Vehicles/Revolver/Design/Parts/CoreMod/CryoBooster/VehiclePart_CryoBooster.VehiclePart_CryoBooster',
            '/Game/Vehicles/Revolver/Design/Parts/CoreMod/DigiThruster/VehiclePart_DigiThruster.VehiclePart_DigiThruster',
            '/Game/Vehicles/Revolver/Design/Parts/CoreMod/Firestarter/VehiclePart_FireStarter.VehiclePart_FireStarter',
            '/Game/Vehicles/Revolver/Design/Parts/CoreMod/HeavyBooster/VehiclePart_HeavyBooster.VehiclePart_HeavyBooster',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MechanicalLauncher/BlazeRodLancer/VehiclePart_WeaponDriver_BlazeRodLauncher_Native.VehiclePart_WeaponDriver_BlazeRodLauncher_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MechanicalLauncher/RevolverMachineGun/VehiclePart_WeaponDriver_RevolverMachineGun_Native.VehiclePart_WeaponDriver_RevolverMachineGun_Native',
            '/Game/Vehicles/VehicleWeapons/DriverWeapons/Type_MechanicalLauncher/SawBladeLancer/VehiclePart_WeaponDriver_SawBladeLauncher_Native.VehiclePart_WeaponDriver_SawBladeLauncher_Native',
            ]),
        JETBEAST: set([
            '/Geranium/Vehicles/Horse/Design/Parts/CoreMod/SingleEngine/VehiclePart_SingleBooster_Horse.VehiclePart_SingleBooster_Horse',
            '/Geranium/Vehicles/Horse/Design/Parts/CoreMod/TwinEngine/VehiclePart_TwinEngine_Horse.VehiclePart_TwinEngine_Horse',
            '/Geranium/Vehicles/Horse/Design/Parts/Armor/VehiclePart_Horse_Armor_SoftSaddleBags.VehiclePart_Horse_Armor_SoftSaddleBags',
            '/Geranium/Vehicles/Horse/Design/Parts/Armor/VehiclePart_Horse_Armor_HardSaddleBags.VehiclePart_Horse_Armor_HardSaddleBags',
            '/Geranium/Vehicles/VehicleWeapons/Type_Cannon/VehiclePart_WeaponDriver_Horse_Cannon.VehiclePart_WeaponDriver_Horse_Cannon',
            '/Geranium/Vehicles/VehicleWeapons/Type_DualMachineGun/VehiclePart_WeaponDriver_Horse_DualMachineGun.VehiclePart_WeaponDriver_Horse_DualMachineGun',
            '/Geranium/Vehicles/VehicleWeapons/Type_Mortar/VehiclePart_Weapon_Horse_Mortar.VehiclePart_Weapon_Horse_Mortar',
            ]),
        }
part_to_vehicle = {}
for vehicle, parts in vehicle_parts.items():
    for part in parts:
        part_to_vehicle[part] = vehicle
vehicle_skins = {
        OUTRUNNER: set([
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Atlas.VehiclePart_Mat_VehiclePart_Outrunner_Atlas',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Batmobile.VehiclePart_Mat_VehiclePart_Outrunner_Batmobile',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_COV.VehiclePart_Mat_VehiclePart_Outrunner_COV',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Dahl.VehiclePart_Mat_VehiclePart_Outrunner_Dahl',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Default.VehiclePart_Mat_VehiclePart_Outrunner_Default',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Ellie1.VehiclePart_Mat_VehiclePart_Outrunner_Ellie1',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_FF.VehiclePart_Mat_VehiclePart_Outrunner_FF',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Fire.VehiclePart_Mat_VehiclePart_Outrunner_Fire',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Forest.VehiclePart_Mat_VehiclePart_Outrunner_Forest',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_GBX.VehiclePart_Mat_VehiclePart_Outrunner_GBX',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Gold.VehiclePart_Mat_VehiclePart_Outrunner_Gold',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Grog.VehiclePart_Mat_VehiclePart_Outrunner_Grog',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Gulf.VehiclePart_Mat_VehiclePart_Outrunner_Gulf',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Herbie.VehiclePart_Mat_VehiclePart_Outrunner_Herbie',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Hexagon.VehiclePart_Mat_VehiclePart_Outrunner_Hexagon',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Houndstooth.VehiclePart_Mat_VehiclePart_Outrunner_Houndstooth',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_HubbaBubba.VehiclePart_Mat_VehiclePart_Outrunner_HubbaBubba',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Hyp.VehiclePart_Mat_VehiclePart_Outrunner_Hyp',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Hyp2.VehiclePart_Mat_VehiclePart_Outrunner_Hyp2',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Infection.VehiclePart_Mat_VehiclePart_Outrunner_Infection',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Jakobs.VehiclePart_Mat_VehiclePart_Outrunner_Jakobs',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Maliwan.VehiclePart_Mat_VehiclePart_Outrunner_Maliwan',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Maya.VehiclePart_Mat_VehiclePart_Outrunner_Maya',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Pirate.VehiclePart_Mat_VehiclePart_Outrunner_Pirate',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Prisa.VehiclePart_Mat_VehiclePart_Outrunner_Prisa',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_RedMachine.VehiclePart_Mat_VehiclePart_Outrunner_RedMachine',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_SDCC.VehiclePart_Mat_VehiclePart_Outrunner_SDCC',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Stealth.VehiclePart_Mat_VehiclePart_Outrunner_Stealth',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Torgue.VehiclePart_Mat_VehiclePart_Outrunner_Torgue',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Tri.VehiclePart_Mat_VehiclePart_Outrunner_Tri',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Vladof.VehiclePart_Mat_VehiclePart_Outrunner_Vladof',
            '/Game/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Wrap.VehiclePart_Mat_VehiclePart_Outrunner_Wrap',
            '/Game/PatchDLC/Hibiscus/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Fish.VehiclePart_Mat_VehiclePart_Outrunner_Fish',
            '/Game/PatchDLC/Hibiscus/Vehicles/Outrunner/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Outrunner_Tentacle.VehiclePart_Mat_VehiclePart_Outrunner_Tentacle',
            ]),
        TECHNICAL: set([
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Atlas.VehiclePart_Mat_VehiclePart_Technical_Atlas',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Bling.VehiclePart_Mat_VehiclePart_Technical_Bling',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_BlueAngel.VehiclePart_Mat_VehiclePart_Technical_BlueAngel',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Bubblegum.VehiclePart_Mat_VehiclePart_Technical_Bubblegum',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Camo.VehiclePart_Mat_VehiclePart_Technical_Camo',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Checker.VehiclePart_Mat_VehiclePart_Technical_Checker',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Cov.VehiclePart_Mat_VehiclePart_Technical_Cov',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Dahl.VehiclePart_Mat_VehiclePart_Technical_Dahl',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Default.VehiclePart_Mat_VehiclePart_Technical_Default',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Dino.VehiclePart_Mat_VehiclePart_Technical_Dino',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_E3.VehiclePart_Mat_VehiclePart_Technical_E3',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Ellie1.VehiclePart_Mat_VehiclePart_Technical_Ellie1',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Festi.VehiclePart_Mat_VehiclePart_Technical_Festi',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Forest.VehiclePart_Mat_VehiclePart_Technical_Forest',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_GBX.VehiclePart_Mat_VehiclePart_Technical_GBX',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_GoldenTicket.VehiclePart_Mat_VehiclePart_Technical_GoldenTicket',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_HYP.VehiclePart_Mat_VehiclePart_Technical_HYP',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Halftone.VehiclePart_Mat_VehiclePart_Technical_Halftone',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_JAK.VehiclePart_Mat_VehiclePart_Technical_JAK',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_MAL.VehiclePart_Mat_VehiclePart_Technical_MAL',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Maya.VehiclePart_Mat_VehiclePart_Technical_Maya',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Plaid.VehiclePart_Mat_VehiclePart_Technical_Plaid',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Roadkill.VehiclePart_Mat_VehiclePart_Technical_Roadkill',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Sand.VehiclePart_Mat_VehiclePart_Technical_Sand',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Skag.VehiclePart_Mat_VehiclePart_Technical_Skag',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Stealth.VehiclePart_Mat_VehiclePart_Technical_Stealth',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Thunderbird.VehiclePart_Mat_VehiclePart_Technical_Thunderbird',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Torgue.VehiclePart_Mat_VehiclePart_Technical_Torgue',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Vaughn.VehiclePart_Mat_VehiclePart_Technical_Vaughn',
            '/Game/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Vladof.VehiclePart_Mat_VehiclePart_Technical_Vladof',
            '/Game/PatchDLC/Hibiscus/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Tentacle.VehiclePart_Mat_VehiclePart_Technical_Tentacle',
            '/Game/PatchDLC/Hibiscus/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Fish.VehiclePart_Mat_VehiclePart_Technical_Fish',
            '/Game/PatchDLC/Hibiscus/Vehicles/Technical/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Technical_Frost.VehiclePart_Mat_VehiclePart_Technical_Frost',
            ]),
        CYCLONE: set([
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Atlas.VehiclePart_Mat_VehiclePart_Revolver_Atlas',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_COV.VehiclePart_Mat_VehiclePart_Revolver_COV',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Chopper.VehiclePart_Mat_VehiclePart_Revolver_Chopper',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Chups.VehiclePart_Mat_VehiclePart_Revolver_Chups',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Dahl.VehiclePart_Mat_VehiclePart_Revolver_Dahl',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Dark.VehiclePart_Mat_VehiclePart_Revolver_Dark',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Default.VehiclePart_Mat_VehiclePart_Revolver_Default',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Ellie1.VehiclePart_Mat_VehiclePart_Revolver_Ellie1',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Forest.VehiclePart_Mat_VehiclePart_Revolver_Forest',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_GBX.VehiclePart_Mat_VehiclePart_Revolver_GBX',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_GC.VehiclePart_Mat_VehiclePart_Revolver_GC',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_HubbaBubba.VehiclePart_Mat_VehiclePart_Revolver_HubbaBubba',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Hyp.VehiclePart_Mat_VehiclePart_Revolver_Hyp',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Hyp2.VehiclePart_Mat_VehiclePart_Revolver_Hyp2',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Jakobs.VehiclePart_Mat_VehiclePart_Revolver_Jakobs',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_LifeSaver.VehiclePart_Mat_VehiclePart_Revolver_LifeSaver',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Maliwan.VehiclePart_Mat_VehiclePart_Revolver_Maliwan',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Mask.VehiclePart_Mat_VehiclePart_Revolver_Mask',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Maya.VehiclePart_Mat_VehiclePart_Revolver_Maya',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Ninja.VehiclePart_Mat_VehiclePart_Revolver_Ninja',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Pepto.VehiclePart_Mat_VehiclePart_Revolver_Pepto',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Police.VehiclePart_Mat_VehiclePart_Revolver_Police',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Stealth.VehiclePart_Mat_VehiclePart_Revolver_Stealth',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Torgue.VehiclePart_Mat_VehiclePart_Revolver_Torgue',
            '/Game/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Vladof.VehiclePart_Mat_VehiclePart_Revolver_Vladof',
            '/Game/PatchDLC/Hibiscus/Vehicles/Revolver/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Revolver_Fish.VehiclePart_Mat_VehiclePart_Revolver_Fish',
            ]),
        JETBEAST: set([
            '/Geranium/Vehicles/Horse/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Horse_Default.VehiclePart_Mat_VehiclePart_Horse_Default',
            '/Geranium/Vehicles/Horse/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Horse_Skin1.VehiclePart_Mat_VehiclePart_Horse_Skin1',
            '/Geranium/Vehicles/Horse/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Horse_Skin2.VehiclePart_Mat_VehiclePart_Horse_Skin2',
            '/Geranium/Vehicles/Horse/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Horse_Skin3.VehiclePart_Mat_VehiclePart_Horse_Skin3',
            '/Geranium/Vehicles/Horse/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Horse_Skin4.VehiclePart_Mat_VehiclePart_Horse_Skin4',
            '/Geranium/Vehicles/Horse/Design/Parts/Materials/VehiclePart_Mat_VehiclePart_Horse_Skin5.VehiclePart_Mat_VehiclePart_Horse_Skin5',
            ]),
        }
skin_to_vehicle = {}
for vehicle, skins in vehicle_skins.items():
    for skin in skins:
        skin_to_vehicle[skin] = vehicle

# Profile customizations - Skins
# (all these customization sections omit the ones unlocked by default,
# which don't seem to show up in the profile usually)
profile_skins = set([
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/_Shared/CustomSkin_Beastmaster_DLC4_01.CustomSkin_Beastmaster_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/_Shared/CustomSkin_Gunner_DLC4_01.CustomSkin_Gunner_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/_Shared/CustomSkin_Operative__DLC4_01.CustomSkin_Operative__DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/_Shared/CustomSkin_Siren__DLC4_01.CustomSkin_Siren__DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_63.CustomSkin_Beastmaster_63',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_63.CustomSkin_Gunner_63',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_63.CustomSkin_Operative_63',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_63.CustomSkin_Siren_63',
    '/Game/PatchDLC/BloodyHarvest/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_40.CustomSkin_Beastmaster_40',
    '/Game/PatchDLC/BloodyHarvest/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_40.CustomSkin_Gunner_40',
    '/Game/PatchDLC/BloodyHarvest/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_40.CustomSkin_Operative_40',
    '/Game/PatchDLC/BloodyHarvest/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_40.CustomSkin_Siren_40',
    '/Game/PatchDLC/CitizenScience/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_CS.CustomSkin_Beastmaster_CS',
    '/Game/PatchDLC/CitizenScience/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_CS.CustomSkin_Gunner_CS',
    '/Game/PatchDLC/CitizenScience/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_CS.CustomSkin_Operative_CS',
    '/Game/PatchDLC/CitizenScience/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_CS.CustomSkin_Siren_CS',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomSkin_Beastmaster_44.CustomSkin_Beastmaster_44',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomSkin_Beastmaster_46.CustomSkin_Beastmaster_46',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomSkin_Gunner_44.CustomSkin_Gunner_44',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomSkin_Gunner_46.CustomSkin_Gunner_46',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomSkin_Operative_44.CustomSkin_Operative_44',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomSkin_Operative_46.CustomSkin_Operative_46',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomSkin_Siren_44.CustomSkin_Siren_44',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomSkin_Siren_46.CustomSkin_Siren_46',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_47.CustomSkin_Beastmaster_47',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_48.CustomSkin_Beastmaster_48',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_47.CustomSkin_Gunner_47',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_48.CustomSkin_Gunner_48',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_47.CustomSkin_Operative_47',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_48.CustomSkin_Operative_48',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_47.CustomSkin_Siren_47',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_48.CustomSkin_Siren_48',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomSkin_Beastmaster_50.CustomSkin_Beastmaster_50',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomSkin_Beastmaster_65.CustomSkin_Beastmaster_65',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomSkin_Gunner_50.CustomSkin_Gunner_50',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomSkin_Gunner_65.CustomSkin_Gunner_65',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomSkin_Operative_50.CustomSkin_Operative_50',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomSkin_Operative_65.CustomSkin_Operative_65',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomSkin_Siren_50.CustomSkin_Siren_50',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomSkin_Siren_65.CustomSkin_Siren_65',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_61.CustomSkin_Beastmaster_61',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_61.CustomSkin_Gunner_61',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_61.CustomSkin_Operative_61',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Siren/Skins/CustomSkin_Siren_61.CustomSkin_Siren_61',
    '/Game/PatchDLC/Geranium/Customizations/PlayerSkin/CustomSkin_Beastmaster_DLC3_1.CustomSkin_Beastmaster_DLC3_1',
    '/Game/PatchDLC/Geranium/Customizations/PlayerSkin/CustomSkin_Gunner_DLC3_1.CustomSkin_Gunner_DLC3_1',
    '/Game/PatchDLC/Geranium/Customizations/PlayerSkin/CustomSkin_Operative_DLC3_1.CustomSkin_Operative_DLC3_1',
    '/Game/PatchDLC/Geranium/Customizations/PlayerSkin/CustomSkin_Siren_DLC3_1.CustomSkin_Siren_DLC3_1',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/_Shared/CustomSkin_Beastmaster_DLC2_01.CustomSkin_Beastmaster_DLC2_01',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/_Shared/CustomSkin_Gunner_DLC2_01.CustomSkin_Gunner_DLC2_01',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/_Shared/CustomSkin_Operative__DLC2_01.CustomSkin_Operative__DLC2_01',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/_Shared/CustomSkin_Siren__DLC2_01.CustomSkin_Siren__DLC2_01',
    '/Game/PatchDLC/Ixora/PlayerCharacters/_Customizations/PlayerSkins/Skin51/CustomSkin_Beastmaster_51.CustomSkin_Beastmaster_51',
    '/Game/PatchDLC/Ixora/PlayerCharacters/_Customizations/PlayerSkins/Skin51/CustomSkin_Gunner_51.CustomSkin_Gunner_51',
    '/Game/PatchDLC/Ixora/PlayerCharacters/_Customizations/PlayerSkins/Skin51/CustomSkin_Operative_51.CustomSkin_Operative_51',
    '/Game/PatchDLC/Ixora/PlayerCharacters/_Customizations/PlayerSkins/Skin51/CustomSkin_Siren_51.CustomSkin_Siren_51',
    '/Game/PatchDLC/Ixora/PlayerCharacters/_Customizations/PlayerSkins/Skin62/CustomSkin_Beastmaster_62.CustomSkin_Beastmaster_62',
    '/Game/PatchDLC/Ixora/PlayerCharacters/_Customizations/PlayerSkins/Skin62/CustomSkin_Gunner_62.CustomSkin_Gunner_62',
    '/Game/PatchDLC/Ixora/PlayerCharacters/_Customizations/PlayerSkins/Skin62/CustomSkin_Operative_62.CustomSkin_Operative_62',
    '/Game/PatchDLC/Ixora/PlayerCharacters/_Customizations/PlayerSkins/Skin62/CustomSkin_Siren_62.CustomSkin_Siren_62',
    '/Game/PatchDLC/Ixora2/PlayerCharacters/_Shared/Skins/CustomSkin_Beastmaster_66.CustomSkin_Beastmaster_66',
    '/Game/PatchDLC/Ixora2/PlayerCharacters/_Shared/Skins/CustomSkin_Gunner_66.CustomSkin_Gunner_66',
    '/Game/PatchDLC/Ixora2/PlayerCharacters/_Shared/Skins/CustomSkin_Operative_66.CustomSkin_Operative_66',
    '/Game/PatchDLC/Ixora2/PlayerCharacters/_Shared/Skins/CustomSkin_Siren_66.CustomSkin_Siren_66',
    '/Game/PatchDLC/Raid1/PlayerCharacters/_Customizations/Beastmaster/CustomSkin_Beastmaster_45.CustomSkin_Beastmaster_45',
    '/Game/PatchDLC/Raid1/PlayerCharacters/_Customizations/Gunner/CustomSkin_Gunner_45.CustomSkin_Gunner_45',
    '/Game/PatchDLC/Raid1/PlayerCharacters/_Customizations/Operative/CustomSkin_Operative_45.CustomSkin_Operative_45',
    '/Game/PatchDLC/Raid1/PlayerCharacters/_Customizations/Siren/CustomSkin_Siren_45.CustomSkin_Siren_45',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/PlayerSkins/CustomSkin_Beastmaster_52.CustomSkin_Beastmaster_52',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/PlayerSkins/CustomSkin_Gunner_52.CustomSkin_Gunner_52',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/PlayerSkins/CustomSkin_Operative_52.CustomSkin_Operative_52',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/PlayerSkins/CustomSkin_Siren_52.CustomSkin_Siren_52',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Beastmaster_67.CustomSkin_Beastmaster_67',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Beastmaster_68.CustomSkin_Beastmaster_68',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Beastmaster_69.CustomSkin_Beastmaster_69',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Beastmaster_70.CustomSkin_Beastmaster_70',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Gunner_67.CustomSkin_Gunner_67',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Gunner_68.CustomSkin_Gunner_68',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Gunner_69.CustomSkin_Gunner_69',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Gunner_70.CustomSkin_Gunner_70',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Operative_67.CustomSkin_Operative_67',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Operative_68.CustomSkin_Operative_68',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Operative_69.CustomSkin_Operative_69',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Operative_70.CustomSkin_Operative_70',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Siren_67.CustomSkin_Siren_67',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Siren_68.CustomSkin_Siren_68',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Siren_69.CustomSkin_Siren_69',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomSkin_Siren_70.CustomSkin_Siren_70',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_1.CustomSkin_Beastmaster_1',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_10.CustomSkin_Beastmaster_10',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_11.CustomSkin_Beastmaster_11',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_12.CustomSkin_Beastmaster_12',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_13.CustomSkin_Beastmaster_13',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_14.CustomSkin_Beastmaster_14',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_15.CustomSkin_Beastmaster_15',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_16.CustomSkin_Beastmaster_16',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_17.CustomSkin_Beastmaster_17',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_18.CustomSkin_Beastmaster_18',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_19.CustomSkin_Beastmaster_19',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_2.CustomSkin_Beastmaster_2',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_20.CustomSkin_Beastmaster_20',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_21.CustomSkin_Beastmaster_21',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_22.CustomSkin_Beastmaster_22',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_23.CustomSkin_Beastmaster_23',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_24.CustomSkin_Beastmaster_24',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_25.CustomSkin_Beastmaster_25',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_26.CustomSkin_Beastmaster_26',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_27.CustomSkin_Beastmaster_27',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_28.CustomSkin_Beastmaster_28',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_29.CustomSkin_Beastmaster_29',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_3.CustomSkin_Beastmaster_3',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_30.CustomSkin_Beastmaster_30',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_31.CustomSkin_Beastmaster_31',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_32.CustomSkin_Beastmaster_32',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_34.CustomSkin_Beastmaster_34',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_35.CustomSkin_Beastmaster_35',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_36.CustomSkin_Beastmaster_36',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_37.CustomSkin_Beastmaster_37',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_39.CustomSkin_Beastmaster_39',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_4.CustomSkin_Beastmaster_4',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_41.CustomSkin_Beastmaster_41',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_42.CustomSkin_Beastmaster_42',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_43.CustomSkin_Beastmaster_43',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_5.CustomSkin_Beastmaster_5',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_6.CustomSkin_Beastmaster_6',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_7.CustomSkin_Beastmaster_7',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_8.CustomSkin_Beastmaster_8',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_9.CustomSkin_Beastmaster_9',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_1.CustomSkin_Gunner_1',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_10.CustomSkin_Gunner_10',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_11.CustomSkin_Gunner_11',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_12.CustomSkin_Gunner_12',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_13.CustomSkin_Gunner_13',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_14.CustomSkin_Gunner_14',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_15.CustomSkin_Gunner_15',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_16.CustomSkin_Gunner_16',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_17.CustomSkin_Gunner_17',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_18.CustomSkin_Gunner_18',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_19.CustomSkin_Gunner_19',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_2.CustomSkin_Gunner_2',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_20.CustomSkin_Gunner_20',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_21.CustomSkin_Gunner_21',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_22.CustomSkin_Gunner_22',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_23.CustomSkin_Gunner_23',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_24.CustomSkin_Gunner_24',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_25.CustomSkin_Gunner_25',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_26.CustomSkin_Gunner_26',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_27.CustomSkin_Gunner_27',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_28.CustomSkin_Gunner_28',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_29.CustomSkin_Gunner_29',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_3.CustomSkin_Gunner_3',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_30.CustomSkin_Gunner_30',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_31.CustomSkin_Gunner_31',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_32.CustomSkin_Gunner_32',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_34.CustomSkin_Gunner_34',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_35.CustomSkin_Gunner_35',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_36.CustomSkin_Gunner_36',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_37.CustomSkin_Gunner_37',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_39.CustomSkin_Gunner_39',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_4.CustomSkin_Gunner_4',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_41.CustomSkin_Gunner_41',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_42.CustomSkin_Gunner_42',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_43.CustomSkin_Gunner_43',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_5.CustomSkin_Gunner_5',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_6.CustomSkin_Gunner_6',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_7.CustomSkin_Gunner_7',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_8.CustomSkin_Gunner_8',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_9.CustomSkin_Gunner_9',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_1.CustomSkin_Operative_1',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_10.CustomSkin_Operative_10',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_11.CustomSkin_Operative_11',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_12.CustomSkin_Operative_12',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_13.CustomSkin_Operative_13',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_14.CustomSkin_Operative_14',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_15.CustomSkin_Operative_15',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_16.CustomSkin_Operative_16',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_17.CustomSkin_Operative_17',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_18.CustomSkin_Operative_18',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_19.CustomSkin_Operative_19',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_2.CustomSkin_Operative_2',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_20.CustomSkin_Operative_20',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_21.CustomSkin_Operative_21',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_22.CustomSkin_Operative_22',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_23.CustomSkin_Operative_23',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_24.CustomSkin_Operative_24',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_25.CustomSkin_Operative_25',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_26.CustomSkin_Operative_26',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_27.CustomSkin_Operative_27',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_28.CustomSkin_Operative_28',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_29.CustomSkin_Operative_29',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_3.CustomSkin_Operative_3',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_30.CustomSkin_Operative_30',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_31.CustomSkin_Operative_31',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_32.CustomSkin_Operative_32',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_34.CustomSkin_Operative_34',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_35.CustomSkin_Operative_35',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_36.CustomSkin_Operative_36',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_37.CustomSkin_Operative_37',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_39.CustomSkin_Operative_39',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_4.CustomSkin_Operative_4',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_41.CustomSkin_Operative_41',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_42.CustomSkin_Operative_42',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_43.CustomSkin_Operative_43',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_5.CustomSkin_Operative_5',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_6.CustomSkin_Operative_6',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_7.CustomSkin_Operative_7',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_8.CustomSkin_Operative_8',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_9.CustomSkin_Operative_9',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_1.CustomSkin_Siren_1',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_10.CustomSkin_Siren_10',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_11.CustomSkin_Siren_11',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_12.CustomSkin_Siren_12',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_13.CustomSkin_Siren_13',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_14.CustomSkin_Siren_14',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_15.CustomSkin_Siren_15',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_16.CustomSkin_Siren_16',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_17.CustomSkin_Siren_17',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_18.CustomSkin_Siren_18',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_19.CustomSkin_Siren_19',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_2.CustomSkin_Siren_2',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_20.CustomSkin_Siren_20',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_21.CustomSkin_Siren_21',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_22.CustomSkin_Siren_22',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_23.CustomSkin_Siren_23',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_24.CustomSkin_Siren_24',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_25.CustomSkin_Siren_25',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_26.CustomSkin_Siren_26',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_27.CustomSkin_Siren_27',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_28.CustomSkin_Siren_28',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_29.CustomSkin_Siren_29',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_3.CustomSkin_Siren_3',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_30.CustomSkin_Siren_30',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_31.CustomSkin_Siren_31',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_32.CustomSkin_Siren_32',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_34.CustomSkin_Siren_34',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_35.CustomSkin_Siren_35',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_36.CustomSkin_Siren_36',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_37.CustomSkin_Siren_37',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_39.CustomSkin_Siren_39',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_4.CustomSkin_Siren_4',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_41.CustomSkin_Siren_41',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_42.CustomSkin_Siren_42',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_43.CustomSkin_Siren_43',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_5.CustomSkin_Siren_5',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_6.CustomSkin_Siren_6',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_7.CustomSkin_Siren_7',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_8.CustomSkin_Siren_8',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_9.CustomSkin_Siren_9',
    ])
profile_skins_defaults = set([
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Skins/CustomSkin_Beastmaster_Default.CustomSkin_Beastmaster_Default',
    '/Game/PlayerCharacters/_Customizations/Gunner/Skins/CustomSkin_Gunner_Default.CustomSkin_Gunner_Default',
    '/Game/PlayerCharacters/_Customizations/Operative/Skins/CustomSkin_Operative_Default.CustomSkin_Operative_Default',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Skins/CustomSkin_Siren_Default.CustomSkin_Siren_Default',
    ])

# Profile customizations - Heads
profile_heads = set([
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/_Shared/CustomHead_Beastmaster_DLC4_01.CustomHead_Beastmaster_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/_Shared/CustomHead_Gunner_DLC4_01.CustomHead_Gunner_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/_Shared/CustomHead_Operative_DLC4_01.CustomHead_Operative_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/_Shared/CustomHead_Siren_DLC4_01.CustomHead_Siren_DLC4_01',
    '/Game/PatchDLC/CitizenScience/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_CS.CustomHead_Beastmaster_CS',
    '/Game/PatchDLC/CitizenScience/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_CS.CustomHead_Gunner_CS',
    '/Game/PatchDLC/CitizenScience/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_CS.CustomHead_Operative_CS',
    '/Game/PatchDLC/CitizenScience/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_CS.CustomHead_Siren_CS',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_25.CustomHead_Beastmaster_25',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_27.CustomHead_Beastmaster_27',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_28.CustomHead_Beastmaster_28',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_29.CustomHead_Beastmaster_29',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_25.CustomHead_Gunner_25',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_27.CustomHead_Gunner_27',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_28.CustomHead_Gunner_28',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_29.CustomHead_Gunner_29',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_25.CustomHead_Operative_25',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_27.CustomHead_Operative_27',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_28.CustomHead_Operative_28',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_29.CustomHead_Operative_29',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_25.CustomHead_Siren_25',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_27.CustomHead_Siren_27',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_28.CustomHead_Siren_28',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_29.CustomHead_Siren_29',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomHead_Beastmaster_30.CustomHead_Beastmaster_30',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomHead_Gunner_30.CustomHead_Gunner_30',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomHead_Operative_30.CustomHead_Operative_30',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/_Shared/CustomHead_Siren_30.CustomHead_Siren_30',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_34.CustomHead_Beastmaster_34',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_34.CustomHead_Gunner_34',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_34.CustomHead_Operative_34',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_34.CustomHead_Siren_34',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomHead_BeastMaster_Twitch.CustomHead_BeastMaster_Twitch',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomHead_Gunner_Twitch.CustomHead_Gunner_Twitch',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomHead_Operative_Twitch.CustomHead_Operative_Twitch',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/CustomHead_Siren_Twitch.CustomHead_Siren_Twitch',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Beastmaster/Heads/DA_BMHead33.DA_BMHead33',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Beastmaster/Heads/DA_BMHead35.DA_BMHead35',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Beastmaster/Heads/DA_BMHead36.DA_BMHead36',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Beastmaster/Heads/DA_BMHead37.DA_BMHead37',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Gunner/Heads/DA_GNRHead33.DA_GNRHead33',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Gunner/Heads/DA_GNRHead35.DA_GNRHead35',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Gunner/Heads/DA_GNRHead36.DA_GNRHead36',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Gunner/Heads/DA_GNRHead37.DA_GNRHead37',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Operative/Heads/DA_OPHead33.DA_OPHead33',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Operative/Heads/DA_OPHead35.DA_OPHead35',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Operative/Heads/DA_OPHead36.DA_OPHead36',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Operative/Heads/DA_OPHead37.DA_OPHead37',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Siren/Heads/DA_SRNHead33.DA_SRNHead33',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Siren/Heads/DA_SRNHead35.DA_SRNHead35',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Siren/Heads/DA_SRNHead36.DA_SRNHead36',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Customizations/Siren/Heads/DA_SRNHead37.DA_SRNHead37',
    '/Game/PatchDLC/Geranium/Customizations/PlayerHead/CustomHead38/CustomHead_Beastmaster_38.CustomHead_Beastmaster_38',
    '/Game/PatchDLC/Geranium/Customizations/PlayerHead/CustomHead38/CustomHead_Gunner_38.CustomHead_Gunner_38',
    '/Game/PatchDLC/Geranium/Customizations/PlayerHead/CustomHead38/CustomHead_Operative_38.CustomHead_Operative_38',
    '/Game/PatchDLC/Geranium/Customizations/PlayerHead/CustomHead38/CustomHead_Siren_38.CustomHead_Siren_38',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/_Shared/CustomHead_Beastmaster_DLC2_01.CustomHead_Beastmaster_DLC2_01',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/_Shared/CustomHead_Gunner_DLC2_01.CustomHead_Gunner_DLC2_01',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/_Shared/CustomHead_Operative_DLC2_01.CustomHead_Operative_DLC2_01',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/_Shared/CustomHead_Siren_DLC2_01.CustomHead_Siren_DLC2_01',
    '/Game/PatchDLC/Ixora/PlayerCharacters/Beastmaster/Heads/DA_BMHead39.DA_BMHead39',
    '/Game/PatchDLC/Ixora/PlayerCharacters/Gunner/Heads/DA_GNRHead39.DA_GNRHead39',
    '/Game/PatchDLC/Ixora/PlayerCharacters/Operative/Heads/DA_OPHead39.DA_OPHead39',
    '/Game/PatchDLC/Ixora/PlayerCharacters/SirenBrawler/Heads/DA_SRNHead39.DA_SRNHead39',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/CustomHeads/CustomHead46/CustomHead_Beastmaster_46.CustomHead_Beastmaster_46',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/CustomHeads/CustomHead46/CustomHead_Gunner_46.CustomHead_Gunner_46',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/CustomHeads/CustomHead46/CustomHead_Operative_46.CustomHead_Operative_46',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/CustomHeads/CustomHead46/CustomHead_Siren_46.CustomHead_Siren_46',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomHeads/CustomHead47/CustomHead_Beastmaster_47.CustomHead_Beastmaster_47',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomHeads/CustomHead47/CustomHead_Gunner_47.CustomHead_Gunner_47',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomHeads/CustomHead47/CustomHead_Operative_47.CustomHead_Operative_47',
    '/Game/PatchDLC/VaultCard/PlayerCharacters/_Shared/CustomHeads/CustomHead47/CustomHead_Siren_47.CustomHead_Siren_47',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_1.CustomHead_Beastmaster_1',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_10.CustomHead_Beastmaster_10',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_11.CustomHead_Beastmaster_11',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_12.CustomHead_Beastmaster_12',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_13.CustomHead_Beastmaster_13',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_14.CustomHead_Beastmaster_14',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_15.CustomHead_Beastmaster_15',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_16.CustomHead_Beastmaster_16',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_17.CustomHead_Beastmaster_17',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_18.CustomHead_Beastmaster_18',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_19.CustomHead_Beastmaster_19',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_20.CustomHead_Beastmaster_20',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_21.CustomHead_Beastmaster_21',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_22.CustomHead_Beastmaster_22',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_23.CustomHead_Beastmaster_23',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_24.CustomHead_Beastmaster_24',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_26.CustomHead_Beastmaster_26',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_4.CustomHead_Beastmaster_4',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_5.CustomHead_Beastmaster_5',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_6.CustomHead_Beastmaster_6',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_7.CustomHead_Beastmaster_7',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_8.CustomHead_Beastmaster_8',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_9.CustomHead_Beastmaster_9',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_1.CustomHead_Gunner_1',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_10.CustomHead_Gunner_10',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_11.CustomHead_Gunner_11',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_12.CustomHead_Gunner_12',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_13.CustomHead_Gunner_13',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_14.CustomHead_Gunner_14',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_15.CustomHead_Gunner_15',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_16.CustomHead_Gunner_16',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_17.CustomHead_Gunner_17',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_18.CustomHead_Gunner_18',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_19.CustomHead_Gunner_19',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_20.CustomHead_Gunner_20',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_21.CustomHead_Gunner_21',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_22.CustomHead_Gunner_22',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_23.CustomHead_Gunner_23',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_24.CustomHead_Gunner_24',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_26.CustomHead_Gunner_26',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_4.CustomHead_Gunner_4',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_5.CustomHead_Gunner_5',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_6.CustomHead_Gunner_6',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_7.CustomHead_Gunner_7',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_8.CustomHead_Gunner_8',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_9.CustomHead_Gunner_9',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_1.CustomHead_Operative_1',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_10.CustomHead_Operative_10',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_11.CustomHead_Operative_11',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_12.CustomHead_Operative_12',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_13.CustomHead_Operative_13',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_14.CustomHead_Operative_14',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_15.CustomHead_Operative_15',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_16.CustomHead_Operative_16',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_17.CustomHead_Operative_17',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_18.CustomHead_Operative_18',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_19.CustomHead_Operative_19',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_20.CustomHead_Operative_20',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_21.CustomHead_Operative_21',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_22.CustomHead_Operative_22',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_23.CustomHead_Operative_23',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_24.CustomHead_Operative_24',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_26.CustomHead_Operative_26',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_4.CustomHead_Operative_4',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_5.CustomHead_Operative_5',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_6.CustomHead_Operative_6',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_7.CustomHead_Operative_7',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_8.CustomHead_Operative_8',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_9.CustomHead_Operative_9',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_1.CustomHead_Siren_1',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_10.CustomHead_Siren_10',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_11.CustomHead_Siren_11',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_12.CustomHead_Siren_12',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_13.CustomHead_Siren_13',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_14.CustomHead_Siren_14',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_15.CustomHead_Siren_15',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_16.CustomHead_Siren_16',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_17.CustomHead_Siren_17',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_18.CustomHead_Siren_18',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_19.CustomHead_Siren_19',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_20.CustomHead_Siren_20',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_21.CustomHead_Siren_21',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_22.CustomHead_Siren_22',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_23.CustomHead_Siren_23',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_24.CustomHead_Siren_24',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_26.CustomHead_Siren_26',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_4.CustomHead_Siren_4',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_5.CustomHead_Siren_5',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_6.CustomHead_Siren_6',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_7.CustomHead_Siren_7',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_8.CustomHead_Siren_8',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_9.CustomHead_Siren_9',
    ])
profile_heads_defaults = set([
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Heads/CustomHead_Beastmaster_Default.CustomHead_Beastmaster_Default',
    '/Game/PlayerCharacters/_Customizations/Gunner/Heads/CustomHead_Gunner_Default.CustomHead_Gunner_Default',
    '/Game/PlayerCharacters/_Customizations/Operative/Heads/CustomHead_Operative_Default.CustomHead_Operative_Default',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Heads/CustomHead_Siren_Default.CustomHead_Siren_Default',
    ])

# Profile customizations - ECHO themes
profile_echothemes = set([
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_79.ECHOTheme_79',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_DLC4_01.ECHOTheme_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_DLC4_02.ECHOTheme_DLC4_02',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_DLC4_03.ECHOTheme_DLC4_03',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_DLC4_04.ECHOTheme_DLC4_04',
    '/Game/PatchDLC/BloodyHarvest/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_11.ECHOTheme_11',
    '/Game/PatchDLC/Customizations/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_37.ECHOTheme_37',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_36.ECHOTheme_36',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_64.ECHOTheme_64',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_65.ECHOTheme_65',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_66.ECHOTheme_66',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_40.ECHOTheme_40',
    '/Game/PatchDLC/Event2/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_44.ECHOTheme_44',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/ECHODevice/EchoTheme_Valentines_01.EchoTheme_Valentines_01',
    '/Game/PatchDLC/EventVDay/PlayerCharacters/_Shared/ECHODevice/EchoTheme_Valentines_02.EchoTheme_Valentines_02',
    '/Game/PatchDLC/EventVDay/TwitchDrops/PlayerCharacters/_Shared/ECHODevice/ECHOTheme_46.ECHOTheme_46',
    '/Game/PatchDLC/Geranium/Customizations/EchoTheme/ECHOTheme_73.ECHOTheme_73',
    '/Game/PatchDLC/Geranium/Customizations/EchoTheme/ECHOTheme_74.ECHOTheme_74',
    '/Game/PatchDLC/Geranium/Customizations/EchoTheme/ECHOTheme_75.ECHOTheme_75',
    '/Game/PatchDLC/Geranium/Customizations/EchoTheme/ECHOTheme_76.ECHOTheme_76',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_DLC2_01.ECHOTheme_DLC2_01',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_DLC2_02.ECHOTheme_DLC2_02',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_DLC2_03.ECHOTheme_DLC2_03',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_DLC2_04.ECHOTheme_DLC2_04',
    '/Game/PatchDLC/Ixora/Customizations/ECHOTheme/ECHOTheme_50.ECHOTheme_50',
    '/Game/PatchDLC/Ixora/Customizations/ECHOTheme/ECHOTheme_52.ECHOTheme_52',
    '/Game/PatchDLC/Ixora/Customizations/ECHOTheme/ECHOTheme_57a.ECHOTheme_57a',
    '/Game/PatchDLC/Ixora/Customizations/ECHOTheme/ECHOTheme_58.ECHOTheme_58',
    '/Game/PatchDLC/Raid1/Customizations/EchoDevice/ECHOTheme_38.ECHOTheme_38',
    '/Game/PatchDLC/Takedown2/PlayerCharacters/_Customizations/EchoDevice/EchoTheme_Takedown2.EchoTheme_Takedown2',
    '/Game/PatchDLC/VaultCard/Customizations/EchoDevice/ECHOTheme_VC1_1.ECHOTheme_VC1_1',
    '/Game/PatchDLC/VaultCard/Customizations/EchoDevice/ECHOTheme_VC1_2.ECHOTheme_VC1_2',
    '/Game/PatchDLC/VaultCard/Customizations/EchoDevice/ECHOTheme_VC1_3.ECHOTheme_VC1_3',
    '/Game/PatchDLC/VaultCard/Customizations/EchoDevice/ECHOTheme_VC1_4.ECHOTheme_VC1_4',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_01.ECHOTheme_01',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_02.ECHOTheme_02',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_03.ECHOTheme_03',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_04.ECHOTheme_04',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_05.ECHOTheme_05',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_06.ECHOTheme_06',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_07.ECHOTheme_07',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_08.ECHOTheme_08',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_09.ECHOTheme_09',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_10.ECHOTheme_10',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_12.ECHOTheme_12',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_13.ECHOTheme_13',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_14.ECHOTheme_14',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_15.ECHOTheme_15',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_16.ECHOTheme_16',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_17.ECHOTheme_17',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_18.ECHOTheme_18',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_19.ECHOTheme_19',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_20.ECHOTheme_20',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_21.ECHOTheme_21',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_22.ECHOTheme_22',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_23.ECHOTheme_23',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_24.ECHOTheme_24',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_26.ECHOTheme_26',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_27.ECHOTheme_27',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_28.ECHOTheme_28',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_29.ECHOTheme_29',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_30.ECHOTheme_30',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_31.ECHOTheme_31',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_32.ECHOTheme_32',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_33.ECHOTheme_33',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_34.ECHOTheme_34',
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_35.ECHOTheme_35',
    ])
profile_echothemes_defaults = set([
    '/Game/PlayerCharacters/_Customizations/EchoDevice/ECHOTheme_Default.ECHOTheme_Default',
    ])

# Profile customizations - Emotes
profile_emotes = set([
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Emotes/Beastmaster/CustomEmote_Beastmaster_DLC4_01.CustomEmote_Beastmaster_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Emotes/Beastmaster/CustomEmote_Beastmaster_DLC4_02.CustomEmote_Beastmaster_DLC4_02',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Emotes/Gunner/CustomEmote_Gunner_DLC4_01.CustomEmote_Gunner_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Emotes/Gunner/CustomEmote_Gunner_DLC4_02.CustomEmote_Gunner_DLC4_02',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Emotes/Operative/CustomEmote_Operative_DLC4_01.CustomEmote_Operative_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Emotes/Operative/CustomEmote_Operative_DLC4_02.CustomEmote_Operative_DLC4_02',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Emotes/SirenBrawler/CustomEmote_Siren_DLC4_01.CustomEmote_Siren_DLC4_01',
    '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/Emotes/SirenBrawler/CustomEmote_Siren_DLC4_02.CustomEmote_Siren_DLC4_02',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/Emotes/Beastmaster/CustomEmote_Beastmaster_13_HandsomeJack.CustomEmote_Beastmaster_13_HandsomeJack',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/Emotes/Beastmaster/CustomEmote_Beastmaster_14_MakeItRain.CustomEmote_Beastmaster_14_MakeItRain',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/Emotes/Gunner/CustomEmote_Gunner_13_Handsome_Jack.CustomEmote_Gunner_13_Handsome_Jack',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/Emotes/Gunner/CustomEmote_Gunner_14_MakeItRain.CustomEmote_Gunner_14_MakeItRain',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/Emotes/Operative/CustomEmote_Operative_13_HandsomeJack.CustomEmote_Operative_13_HandsomeJack',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/Emotes/Operative/CustomEmote_Operative_14_MakeItRain.CustomEmote_Operative_14_MakeItRain',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/Emotes/SirenBrawler/CustomEmote_Siren_13_HandsomeJack.CustomEmote_Siren_13_HandsomeJack',
    '/Game/PatchDLC/Dandelion/PlayerCharacters/_Customizations/Emotes/SirenBrawler/CustomEmote_Siren_14_MakeItRain.CustomEmote_Siren_14_MakeItRain',
    '/Game/PatchDLC/Geranium/Customizations/PlayerEmote/CustomEmote_Beastmaster_DLC3_1.CustomEmote_Beastmaster_DLC3_1',
    '/Game/PatchDLC/Geranium/Customizations/PlayerEmote/CustomEmote_Beastmaster_DLC3_2.CustomEmote_Beastmaster_DLC3_2',
    '/Game/PatchDLC/Geranium/Customizations/PlayerEmote/CustomEmote_Gunner_DLC3_1.CustomEmote_Gunner_DLC3_1',
    '/Game/PatchDLC/Geranium/Customizations/PlayerEmote/CustomEmote_Gunner_DLC3_2.CustomEmote_Gunner_DLC3_2',
    '/Game/PatchDLC/Geranium/Customizations/PlayerEmote/CustomEmote_Operative_DLC3_1.CustomEmote_Operative_DLC3_1',
    '/Game/PatchDLC/Geranium/Customizations/PlayerEmote/CustomEmote_Operative_DLC3_2.CustomEmote_Operative_DLC3_2',
    '/Game/PatchDLC/Geranium/Customizations/PlayerEmote/CustomEmote_Siren_DLC3_1.CustomEmote_Siren_DLC3_1',
    '/Game/PatchDLC/Geranium/Customizations/PlayerEmote/CustomEmote_Siren_DLC3_2.CustomEmote_Siren_DLC3_2',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/Emotes/Beastmaster/CustomEmote_Beastmaster_15.CustomEmote_Beastmaster_15',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/Emotes/Beastmaster/CustomEmote_Beastmaster_16.CustomEmote_Beastmaster_16',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/Emotes/Gunner/CustomEmote_Gunner_15.CustomEmote_Gunner_15',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/Emotes/Gunner/CustomEmote_Gunner_16.CustomEmote_Gunner_16',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/Emotes/Operative/CustomEmote_Operative_15.CustomEmote_Operative_15',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/Emotes/Operative/CustomEmote_Operative_16.CustomEmote_Operative_16',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/Emotes/SirenBrawler/CustomEmote_Siren_15.CustomEmote_Siren_15',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Customizations/Emotes/SirenBrawler/CustomEmote_Siren_16.CustomEmote_Siren_16',
    '/Game/PatchDLC/VaultCard/Customizations/Emotes/Beastmaster/CustomEmote_Beastmaster_VC1_1.CustomEmote_Beastmaster_VC1_1',
    '/Game/PatchDLC/VaultCard/Customizations/Emotes/Beastmaster/CustomEmote_Beastmaster_VC1_2.CustomEmote_Beastmaster_VC1_2',
    '/Game/PatchDLC/VaultCard/Customizations/Emotes/Gunner/CustomEmote_Gunner_VC1_1.CustomEmote_Gunner_VC1_1',
    '/Game/PatchDLC/VaultCard/Customizations/Emotes/Gunner/CustomEmote_Gunner_VC1_2.CustomEmote_Gunner_VC1_2',
    '/Game/PatchDLC/VaultCard/Customizations/Emotes/Operative/CustomEmote_Operative_VC1_1.CustomEmote_Operative_VC1_1',
    '/Game/PatchDLC/VaultCard/Customizations/Emotes/Operative/CustomEmote_Operative_VC1_2.CustomEmote_Operative_VC1_2',
    '/Game/PatchDLC/VaultCard/Customizations/Emotes/SirenBrawler/CustomEmote_Siren_VC1_1.CustomEmote_Siren_VC1_1',
    '/Game/PatchDLC/VaultCard/Customizations/Emotes/SirenBrawler/CustomEmote_Siren_VC1_2.CustomEmote_Siren_VC1_2',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_05_Heart.CustomEmote_Beastmaster_05_Heart',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_06_FingerGuns.CustomEmote_Beastmaster_06_FingerGuns',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_09_RobotDance.CustomEmote_Beastmaster_09_RobotDance',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_10_KickDance.CustomEmote_Beastmaster_10_KickDance',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_11_Chicken_Dance.CustomEmote_Beastmaster_11_Chicken_Dance',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_12_Death.CustomEmote_Beastmaster_12_Death',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_05_Heart.CustomEmote_Gunner_05_Heart',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_06_FingerGuns.CustomEmote_Gunner_06_FingerGuns',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_09_RobotDance.CustomEmote_Gunner_09_RobotDance',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_10_KickDance.CustomEmote_Gunner_10_KickDance',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_11_ChickenDance.CustomEmote_Gunner_11_ChickenDance',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_12_Death.CustomEmote_Gunner_12_Death',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_05_Heart.CustomEmote_Operative_05_Heart',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_06_FingerGuns.CustomEmote_Operative_06_FingerGuns',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_09_RobotDance.CustomEmote_Operative_09_RobotDance',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_10_KickDance.CustomEmote_Operative_10_KickDance',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_11_ChickenDance.CustomEmote_Operative_11_ChickenDance',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_12_Death.CustomEmote_Operative_12_Death',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_05_Heart.CustomEmote_Siren_05_Heart',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_06_FingerGuns.CustomEmote_Siren_06_FingerGuns',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_09_RobotDance.CustomEmote_Siren_09_RobotDance',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_10_KickDance.CustomEmote_Siren_10_KickDance',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_11_ChickenDance.CustomEmote_Siren_11_ChickenDance',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_12_Death.CustomEmote_Siren_12_Death',
    ])
profile_emotes_defaults = set([
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_01_Wave.CustomEmote_Beastmaster_01_Wave',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_02_Cheer.CustomEmote_Beastmaster_02_Cheer',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_03_Point.CustomEmote_Beastmaster_03_Point',
    '/Game/PlayerCharacters/_Customizations/Beastmaster/Emotes/CustomEmote_Beastmaster_04_Laugh.CustomEmote_Beastmaster_04_Laugh',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_01_Wave.CustomEmote_Gunner_01_Wave',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_02_Cheer.CustomEmote_Gunner_02_Cheer',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_03_Point.CustomEmote_Gunner_03_Point',
    '/Game/PlayerCharacters/_Customizations/Gunner/Emotes/CustomEmote_Gunner_04_Laugh.CustomEmote_Gunner_04_Laugh',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_01_Wave.CustomEmote_Operative_01_Wave',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_02_Cheer.CustomEmote_Operative_02_Cheer',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_03_Point.CustomEmote_Operative_03_Point',
    '/Game/PlayerCharacters/_Customizations/Operative/Emotes/CustomEmote_Operative_04_Laugh.CustomEmote_Operative_04_Laugh',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_01_Wave.CustomEmote_Siren_01_Wave',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_02_Cheer.CustomEmote_Siren_02_Cheer',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_03_Point.CustomEmote_Siren_03_Point',
    '/Game/PlayerCharacters/_Customizations/SirenBrawler/Emotes/CustomEmote_Siren_04_Laugh.CustomEmote_Siren_04_Laugh',
    ])

# Profile customizations - Room Decorations
# We're handling these a bit differently so that our util can re-order them in
# alphabetical order.
profile_roomdeco_obj_to_eng = {
        '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/RoomDeco/RoomDeco_DLC4_01_Orbs.RoomDeco_DLC4_01_Orbs': "Memory Orbs",
        '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/RoomDeco/RoomDeco_DLC4_02_Trophy.RoomDeco_DLC4_02_Trophy': "Psychoreaver Trophy",
        '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/RoomDeco/RoomDeco_DLC4_03_Axe.RoomDeco_DLC4_03_Axe': "Golden Buzz-axe",
        '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/RoomDeco/RoomDeco_DLC4_04_Moon.RoomDeco_DLC4_04_Moon': "Krieg's Moon",
        '/Game/PatchDLC/Alisma/PlayerCharacters/_Customizations/RoomDeco/RoomDeco_DLC4_05_Mask.RoomDeco_DLC4_05_Mask': "Krieg's Mask",
        '/Game/PatchDLC/Dandelion/Customizations/RoomDeco/RoomDeco_DLC1_1.RoomDeco_DLC1_1': "Neon Peach",
        '/Game/PatchDLC/Dandelion/Customizations/RoomDeco/RoomDeco_DLC1_2.RoomDeco_DLC1_2': "Casino Banner",
        '/Game/PatchDLC/Dandelion/Customizations/RoomDeco/RoomDeco_DLC1_3.RoomDeco_DLC1_3': "Handsome Jackpot",
        '/Game/PatchDLC/Dandelion/Customizations/RoomDeco/RoomDeco_DLC1_4.RoomDeco_DLC1_4': "Saxophone",
        '/Game/PatchDLC/Dandelion/Customizations/RoomDeco/RoomDeco_DLC1_5.RoomDeco_DLC1_5': "Jack Plaque",
        '/Game/PatchDLC/Dandelion/Customizations/RoomDeco/RoomDeco_DLC1_6.RoomDeco_DLC1_6': "Jack Hologram",
        '/Game/PatchDLC/Event2/Pickups/RoomDecoration/RoomDecoration_Event2_2.RoomDecoration_Event2_2': "Framed Tenderizer",
        '/Game/PatchDLC/Event2/Pickups/RoomDecoration/RoomDecoration_Event2_3.RoomDecoration_Event2_3': 'Framed Firewall',
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_2.RoomDecoration_Geranium_2': "Bellik Trophy",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_3.RoomDecoration_Geranium_3': "High Noon Clock",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_4.RoomDecoration_Geranium_4': "Saloon Sign",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_5.RoomDecoration_Geranium_5': "Ruiner Tapestry",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_6.RoomDecoration_Geranium_6': "Rampage of the Gorgonoth Poster",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_7.RoomDecoration_Geranium_7': "Seven Smugglers Poster",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_IO_1.RoomDecoration_Geranium_IO_1': "Old Guitar",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_IO_2.RoomDecoration_Geranium_IO_2': "Chemistry Set",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_Geranium_IO_3.RoomDecoration_Geranium_IO_3': "Core Lamp",
        '/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDecoration_KeyToCity.RoomDecoration_KeyToCity': "Key to the City",
        '/Game/PatchDLC/Hibiscus/Customizations/RoomDeco/RoomDeco_DLC2_1.RoomDeco_DLC2_1': "Lunatic Shield",
        '/Game/PatchDLC/Hibiscus/Customizations/RoomDeco/RoomDeco_DLC2_2.RoomDeco_DLC2_2': "Private Eye",
        '/Game/PatchDLC/Hibiscus/Customizations/RoomDeco/RoomDeco_DLC2_3.RoomDeco_DLC2_3': "The Lodge Poster",
        '/Game/PatchDLC/Hibiscus/Customizations/RoomDeco/RoomDeco_DLC2_4.RoomDeco_DLC2_4': "Just Married Poster",
        '/Game/PatchDLC/Hibiscus/Customizations/RoomDeco/RoomDeco_DLC2_5.RoomDeco_DLC2_5': "Dahl Bonded Blueprints",
        '/Game/PatchDLC/Hibiscus/Customizations/RoomDeco/RoomDeco_DLC2_6.RoomDeco_DLC2_6': "Talking Fish",
        '/Game/PatchDLC/Hibiscus/Customizations/RoomDeco/RoomDeco_DLC2_7.RoomDeco_DLC2_7': "Warrior Horn",
        '/Game/PatchDLC/Hibiscus/Customizations/RoomDeco/RoomDeco_DLC2_8.RoomDeco_DLC2_8': "Framed Portal",
        '/Game/PatchDLC/Raid1/Customizations/RoomDeco/RoomDeco_Raid1_1.RoomDeco_Raid1_1': "Wotan's Head",
        '/Game/PatchDLC/Takedown2/InteractiveObjects/PlayerQuarters/RoomDeco_Takedown2.RoomDeco_Takedown2': "The Martyr's Head",
        '/Game/PatchDLC/VaultCard/Customizations/RoomDeco/RoomDecoration_VC1_1.RoomDecoration_VC1_1': "Roland and Tina Photo",
        '/Game/PatchDLC/VaultCard/Customizations/RoomDeco/RoomDecoration_VC1_2.RoomDecoration_VC1_2': "Maya's Book",
        '/Game/PatchDLC/VaultCard/Customizations/RoomDeco/RoomDecoration_VC1_3.RoomDecoration_VC1_3': "Bloodwing Statue",
        '/Game/Pickups/RoomDecoration/RoomDecoration_10.RoomDecoration_10': "Skag Skull",
        '/Game/Pickups/RoomDecoration/RoomDecoration_11.RoomDecoration_11': "Life Preserver",
        '/Game/Pickups/RoomDecoration/RoomDecoration_12.RoomDecoration_12': "Bug Zapper",
        '/Game/Pickups/RoomDecoration/RoomDecoration_13.RoomDecoration_13': "Buzzsaw Blade",
        '/Game/Pickups/RoomDecoration/RoomDecoration_15.RoomDecoration_15': "Jakobs Poster",
        '/Game/Pickups/RoomDecoration/RoomDecoration_16.RoomDecoration_16': "Methane Monitor",
        '/Game/Pickups/RoomDecoration/RoomDecoration_17.RoomDecoration_17': "Trophy Fish",
        '/Game/Pickups/RoomDecoration/RoomDecoration_18.RoomDecoration_18': "Salvation",
        '/Game/Pickups/RoomDecoration/RoomDecoration_19.RoomDecoration_19': "Holy",
        '/Game/Pickups/RoomDecoration/RoomDecoration_20.RoomDecoration_20': "HBC Poster 1",
        '/Game/Pickups/RoomDecoration/RoomDecoration_21.RoomDecoration_21': "HBC Poster 2",
        '/Game/Pickups/RoomDecoration/RoomDecoration_22.RoomDecoration_22': "HBC Poster 3",
        '/Game/Pickups/RoomDecoration/RoomDecoration_23.RoomDecoration_23': "HBC Poster 4",
        '/Game/Pickups/RoomDecoration/RoomDecoration_24.RoomDecoration_24': "HBC Poster 5",
        '/Game/Pickups/RoomDecoration/RoomDecoration_25.RoomDecoration_25': "HBC Poster 6",
        '/Game/Pickups/RoomDecoration/RoomDecoration_26.RoomDecoration_26': "Vegan",
        '/Game/Pickups/RoomDecoration/RoomDecoration_27.RoomDecoration_27': "Live Streaming",
        '/Game/Pickups/RoomDecoration/RoomDecoration_28.RoomDecoration_28': "Storm Brewin'",
        '/Game/Pickups/RoomDecoration/RoomDecoration_29.RoomDecoration_29': "Decorative Bomb",
        '/Game/Pickups/RoomDecoration/RoomDecoration_30.RoomDecoration_30': "Jack Mask",
        '/Game/Pickups/RoomDecoration/RoomDecoration_31.RoomDecoration_31': "Hand Clock",
        '/Game/Pickups/RoomDecoration/RoomDecoration_32.RoomDecoration_32': "Three Fingers",
        '/Game/Pickups/RoomDecoration/RoomDecoration_33.RoomDecoration_33': "R0ADK1L",
        '/Game/Pickups/RoomDecoration/RoomDecoration_34.RoomDecoration_34': "5KAGB8",
        '/Game/Pickups/RoomDecoration/RoomDecoration_35.RoomDecoration_35': "5P8NKM3",
        '/Game/Pickups/RoomDecoration/RoomDecoration_36.RoomDecoration_36': "Skag Attack",
        '/Game/Pickups/RoomDecoration/RoomDecoration_37.RoomDecoration_37': "Mounted Ratch",
        '/Game/Pickups/RoomDecoration/RoomDecoration_38.RoomDecoration_38': "Mounted Skag",
        '/Game/Pickups/RoomDecoration/RoomDecoration_39.RoomDecoration_39': "Mounted Spiderant",
        '/Game/Pickups/RoomDecoration/RoomDecoration_4.RoomDecoration_4': "Bandit Tire",
        '/Game/Pickups/RoomDecoration/RoomDecoration_40.RoomDecoration_40': "Service Bot Console",
        '/Game/Pickups/RoomDecoration/RoomDecoration_41.RoomDecoration_41': "Safety First",
        '/Game/Pickups/RoomDecoration/RoomDecoration_42.RoomDecoration_42': "Hard Hat",
        '/Game/Pickups/RoomDecoration/RoomDecoration_43.RoomDecoration_43': "Dip Road",
        '/Game/Pickups/RoomDecoration/RoomDecoration_44.RoomDecoration_44': "Mouthpiece Speaker",
        '/Game/Pickups/RoomDecoration/RoomDecoration_45.RoomDecoration_45': "Rocketeer Mask",
        '/Game/Pickups/RoomDecoration/RoomDecoration_46.RoomDecoration_46': "COV Bat",
        '/Game/Pickups/RoomDecoration/RoomDecoration_47.RoomDecoration_47': "Psycho Mask",
        '/Game/Pickups/RoomDecoration/RoomDecoration_48.RoomDecoration_48': "COV Hammer",
        '/Game/Pickups/RoomDecoration/RoomDecoration_49.RoomDecoration_49': "COV Cleaver",
        '/Game/Pickups/RoomDecoration/RoomDecoration_5.RoomDecoration_5': "Moxxxi's Bar",
        '/Game/Pickups/RoomDecoration/RoomDecoration_50.RoomDecoration_50': "COV Buzzaxe",
        '/Game/Pickups/RoomDecoration/RoomDecoration_51.RoomDecoration_51': "COV Engine Club",
        '/Game/Pickups/RoomDecoration/RoomDecoration_52.RoomDecoration_52': "Neon Heart",
        '/Game/Pickups/RoomDecoration/RoomDecoration_55.RoomDecoration_55': "Neon Lips",
        '/Game/Pickups/RoomDecoration/RoomDecoration_56.RoomDecoration_56': "COV Sword",
        '/Game/Pickups/RoomDecoration/RoomDecoration_57.RoomDecoration_57': "COV Wrench",
        '/Game/Pickups/RoomDecoration/RoomDecoration_58.RoomDecoration_58': "Mouthpiece Mask",
        '/Game/Pickups/RoomDecoration/RoomDecoration_59.RoomDecoration_59': "Western Portrait 1",
        '/Game/Pickups/RoomDecoration/RoomDecoration_6.RoomDecoration_6': "Pandoracorn",
        '/Game/Pickups/RoomDecoration/RoomDecoration_60.RoomDecoration_60': "Killavolt's Shield",
        '/Game/Pickups/RoomDecoration/RoomDecoration_61.RoomDecoration_61': "Framed Landsape",
        '/Game/Pickups/RoomDecoration/RoomDecoration_62.RoomDecoration_62': "Framed Duchess",
        '/Game/Pickups/RoomDecoration/RoomDecoration_63.RoomDecoration_63': "Western Portrait 2",
        '/Game/Pickups/RoomDecoration/RoomDecoration_64.RoomDecoration_64': "Trooper Shield",
        '/Game/Pickups/RoomDecoration/RoomDecoration_65.RoomDecoration_65': "The Big 3",
        '/Game/Pickups/RoomDecoration/RoomDecoration_66.RoomDecoration_66': "Trooper Disc",
        '/Game/Pickups/RoomDecoration/RoomDecoration_67.RoomDecoration_67': "Use Protection",
        '/Game/Pickups/RoomDecoration/RoomDecoration_7.RoomDecoration_7': "Troy Graffiti",
        '/Game/Pickups/RoomDecoration/RoomDecoration_8.RoomDecoration_8': "Tyreen Graffiti",
        '/Game/Pickups/RoomDecoration/RoomDecoration_9.RoomDecoration_9': "Dynasty Diner",
        # Not including this one 'cause it's bugged - won't even show up, even if unlocked.
        #'/Game/PatchDLC/Geranium/Customizations/RoomDeco/RoomDeco_DLC3_1.RoomDeco_DLC3_1': "DLC3 RoomDeco",
        }
profile_roomdeco_eng_to_obj = {v: k for k, v in profile_roomdeco_obj_to_eng.items()}

# CRC32 table used to compute weapon customization hashes in the profile.  Many
# thanks to Gibbed, yet again, for supplying this!
_weapon_cust_crc32_table = [
        0x00000000, 0x04C11DB7, 0x09823B6E, 0x0D4326D9, 0x130476DC, 0x17C56B6B, 0x1A864DB2, 0x1E475005,
        0x2608EDB8, 0x22C9F00F, 0x2F8AD6D6, 0x2B4BCB61, 0x350C9B64, 0x31CD86D3, 0x3C8EA00A, 0x384FBDBD,
        0x4C11DB70, 0x48D0C6C7, 0x4593E01E, 0x4152FDA9, 0x5F15ADAC, 0x5BD4B01B, 0x569796C2, 0x52568B75,
        0x6A1936C8, 0x6ED82B7F, 0x639B0DA6, 0x675A1011, 0x791D4014, 0x7DDC5DA3, 0x709F7B7A, 0x745E66CD,
        0x9823B6E0, 0x9CE2AB57, 0x91A18D8E, 0x95609039, 0x8B27C03C, 0x8FE6DD8B, 0x82A5FB52, 0x8664E6E5,
        0xBE2B5B58, 0xBAEA46EF, 0xB7A96036, 0xB3687D81, 0xAD2F2D84, 0xA9EE3033, 0xA4AD16EA, 0xA06C0B5D,
        0xD4326D90, 0xD0F37027, 0xDDB056FE, 0xD9714B49, 0xC7361B4C, 0xC3F706FB, 0xCEB42022, 0xCA753D95,
        0xF23A8028, 0xF6FB9D9F, 0xFBB8BB46, 0xFF79A6F1, 0xE13EF6F4, 0xE5FFEB43, 0xE8BCCD9A, 0xEC7DD02D,
        0x34867077, 0x30476DC0, 0x3D044B19, 0x39C556AE, 0x278206AB, 0x23431B1C, 0x2E003DC5, 0x2AC12072,
        0x128E9DCF, 0x164F8078, 0x1B0CA6A1, 0x1FCDBB16, 0x018AEB13, 0x054BF6A4, 0x0808D07D, 0x0CC9CDCA,
        0x7897AB07, 0x7C56B6B0, 0x71159069, 0x75D48DDE, 0x6B93DDDB, 0x6F52C06C, 0x6211E6B5, 0x66D0FB02,
        0x5E9F46BF, 0x5A5E5B08, 0x571D7DD1, 0x53DC6066, 0x4D9B3063, 0x495A2DD4, 0x44190B0D, 0x40D816BA,
        0xACA5C697, 0xA864DB20, 0xA527FDF9, 0xA1E6E04E, 0xBFA1B04B, 0xBB60ADFC, 0xB6238B25, 0xB2E29692,
        0x8AAD2B2F, 0x8E6C3698, 0x832F1041, 0x87EE0DF6, 0x99A95DF3, 0x9D684044, 0x902B669D, 0x94EA7B2A,
        0xE0B41DE7, 0xE4750050, 0xE9362689, 0xEDF73B3E, 0xF3B06B3B, 0xF771768C, 0xFA325055, 0xFEF34DE2,
        0xC6BCF05F, 0xC27DEDE8, 0xCF3ECB31, 0xCBFFD686, 0xD5B88683, 0xD1799B34, 0xDC3ABDED, 0xD8FBA05A,
        0x690CE0EE, 0x6DCDFD59, 0x608EDB80, 0x644FC637, 0x7A089632, 0x7EC98B85, 0x738AAD5C, 0x774BB0EB,
        0x4F040D56, 0x4BC510E1, 0x46863638, 0x42472B8F, 0x5C007B8A, 0x58C1663D, 0x558240E4, 0x51435D53,
        0x251D3B9E, 0x21DC2629, 0x2C9F00F0, 0x285E1D47, 0x36194D42, 0x32D850F5, 0x3F9B762C, 0x3B5A6B9B,
        0x0315D626, 0x07D4CB91, 0x0A97ED48, 0x0E56F0FF, 0x1011A0FA, 0x14D0BD4D, 0x19939B94, 0x1D528623,
        0xF12F560E, 0xF5EE4BB9, 0xF8AD6D60, 0xFC6C70D7, 0xE22B20D2, 0xE6EA3D65, 0xEBA91BBC, 0xEF68060B,
        0xD727BBB6, 0xD3E6A601, 0xDEA580D8, 0xDA649D6F, 0xC423CD6A, 0xC0E2D0DD, 0xCDA1F604, 0xC960EBB3,
        0xBD3E8D7E, 0xB9FF90C9, 0xB4BCB610, 0xB07DABA7, 0xAE3AFBA2, 0xAAFBE615, 0xA7B8C0CC, 0xA379DD7B,
        0x9B3660C6, 0x9FF77D71, 0x92B45BA8, 0x9675461F, 0x8832161A, 0x8CF30BAD, 0x81B02D74, 0x857130C3,
        0x5D8A9099, 0x594B8D2E, 0x5408ABF7, 0x50C9B640, 0x4E8EE645, 0x4A4FFBF2, 0x470CDD2B, 0x43CDC09C,
        0x7B827D21, 0x7F436096, 0x7200464F, 0x76C15BF8, 0x68860BFD, 0x6C47164A, 0x61043093, 0x65C52D24,
        0x119B4BE9, 0x155A565E, 0x18197087, 0x1CD86D30, 0x029F3D35, 0x065E2082, 0x0B1D065B, 0x0FDC1BEC,
        0x3793A651, 0x3352BBE6, 0x3E119D3F, 0x3AD08088, 0x2497D08D, 0x2056CD3A, 0x2D15EBE3, 0x29D4F654,
        0xC5A92679, 0xC1683BCE, 0xCC2B1D17, 0xC8EA00A0, 0xD6AD50A5, 0xD26C4D12, 0xDF2F6BCB, 0xDBEE767C,
        0xE3A1CBC1, 0xE760D676, 0xEA23F0AF, 0xEEE2ED18, 0xF0A5BD1D, 0xF464A0AA, 0xF9278673, 0xFDE69BC4,
        0x89B8FD09, 0x8D79E0BE, 0x803AC667, 0x84FBDBD0, 0x9ABC8BD5, 0x9E7D9662, 0x933EB0BB, 0x97FFAD0C,
        0xAFB010B1, 0xAB710D06, 0xA6322BDF, 0xA2F33668, 0xBCB4666D, 0xB8757BDA, 0xB5365D03, 0xB1F740B4,
        ]

def inventory_path_hash(object_path):
    """
    Computes the hashes used in the profile for weapon customizations and the golden key
    count.  Possibly used for other things, too.  Many thanks to Gibbed, yet again, for this!
    """
    global _weapon_cust_crc32_table
    if '.' not in object_path:
        object_path = '{}.{}'.format(object_path, object_path.split('/')[-1])

    # TODO: Gibbed was under the impression that these were checksummed in
    # UTF-16, but the hashes all match for me when using latin1/utf-8.
    object_full = object_path.upper().encode('latin1')
    crc32 = 0
    for char in object_full:
        crc32 = (_weapon_cust_crc32_table[(crc32 ^ (char >> 0)) & 0xFF] ^ (crc32 >> 8)) & 0xFFFFFFFF
        crc32 = (_weapon_cust_crc32_table[(crc32 ^ (char >> 8)) & 0xFF] ^ (crc32 >> 8)) & 0xFFFFFFFF
    return crc32

def weapon_cust_paths_to_hash(obj_to_eng):
    """
    Computes the hashes used in the profile, for weapon customizations (skins+trinkets).
    """
    to_ret = {}
    for (object_path, eng) in obj_to_eng.items():
        to_ret[inventory_path_hash(object_path)] = eng
    return to_ret

# Profile customizations - Weapon Skins
profile_weaponskins_obj_to_eng = {
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_1.WeaponSkin_1': "Burnished Steele",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_10.WeaponSkin_10': "Ink and Kill",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_11.WeaponSkin_11': "It's Poop!",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_12.WeaponSkin_12': "Painbow",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_13.WeaponSkin_13': "Crepuscule",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_14.WeaponSkin_14': "Skelebones",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_15.WeaponSkin_15': "Black Dragon",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_16.WeaponSkin_16': "Extraspectral",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_17.WeaponSkin_17': "Dandy Lion",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_18.WeaponSkin_18': "Maliwannabe",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_19.WeaponSkin_19': "Fire and Ash",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_2.WeaponSkin_2': "Thunderhead",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_20.WeaponSkin_20': "Blueberry Limeade",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_21.WeaponSkin_21': "Goldie Locks and Loads",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_22.WeaponSkin_22': "Gearbox Prime",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_23.WeaponSkin_23': "Retro Blaster",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_24.WeaponSkin_24': "Butt Dazzle",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_25.WeaponSkin_25': "Super Oaker",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_3.WeaponSkin_3': "Psychodelic",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_4.WeaponSkin_4': "Deep Nebula",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_5.WeaponSkin_5': "Dead Set",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_6.WeaponSkin_6': "Hot Blooded",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_7.WeaponSkin_7': "Red Sands",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_8.WeaponSkin_8': "Gun-fetti",
        '/Game/Gear/WeaponSkins/_Design/SkinParts/WeaponSkin_9.WeaponSkin_9': "Leather and Regret",
        '/Game/PatchDLC/BloodyHarvest/Gear/Weapons/WeaponSkins/WeaponSkin_BloodyHarvest_01.WeaponSkin_BloodyHarvest_01': "Ghoul Metal Grey",
        '/Game/PatchDLC/BloodyHarvest/Gear/Weapons/WeaponSkins/WeaponSkin_BloodyHarvest_02.WeaponSkin_BloodyHarvest_02': "Porphyrophobia",
        '/Game/PatchDLC/Event2/Gear/_Design/WeaponSkins/WeaponSkin_Event2_2.WeaponSkin_Event2_2': "Digital Horizons",
        '/Game/PatchDLC/VaultCard/Customizations/WeaponSkin/WeaponSkin_VC1_1.WeaponSkin_VC1_1': "Phaselocked and Loaded",
        '/Game/PatchDLC/VaultCard/Customizations/WeaponSkin/WeaponSkin_VC1_2.WeaponSkin_VC1_2': "Scoot and Loot",
        '/Game/PatchDLC/VaultCard/Customizations/WeaponSkin/WeaponSkin_VC1_3.WeaponSkin_VC1_3': "Runic Relic",
        # Not including this one because it's quite obviously unfinished, and identical to Burnished Steele
        #'/Game/PatchDLC/Geranium/Customizations/WeaponSkin/WeaponSkin_DLC3_1.WeaponSkin_DLC3_1': "DLC3 WeaponSkin",
        }
profile_weaponskins_hash_to_eng = weapon_cust_paths_to_hash(profile_weaponskins_obj_to_eng)
profile_weaponskins_eng_to_hash = {v: k for k, v in profile_weaponskins_hash_to_eng.items()}

# Profile customizations - Weapon Trinkets
profile_weapontrinkets_obj_to_eng = {
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_10.WeaponTrinket_10': "Super General Claptrap",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_11.WeaponTrinket_11': "Keep Your Eye Out",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_12.WeaponTrinket_12': "Ellie's Power Flower",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_13.WeaponTrinket_13': "Sign of the Hawk",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_14.WeaponTrinket_14': "Beast Bowl",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_15.WeaponTrinket_15': "AnarChic",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_16.WeaponTrinket_16': "Guardian's Lament",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_17.WeaponTrinket_17': "H Marks the Spot",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_18.WeaponTrinket_18': "Cloak and Swagger",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_19.WeaponTrinket_19': "Jack's Off",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_2.WeaponTrinket_2': "Hat Trick",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_20.WeaponTrinket_20': "Stink Eye",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_21.WeaponTrinket_21': "Siren's Mark",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_22.WeaponTrinket_22': "Drop It",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_24.WeaponTrinket_24': "Dedication to Capitalism",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_25.WeaponTrinket_25': "Deadeye Decal",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_26.WeaponTrinket_26': "Born to Kill",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_27.WeaponTrinket_27': "No, You're Crazy",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_28.WeaponTrinket_28': "Itsy Bitsy Rakky Hive",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_29.WeaponTrinket_29': "Buckle Up",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_3.WeaponTrinket_3': "Queen of Hearts",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_30.WeaponTrinket_30': "Rhys's Piece",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_31.WeaponTrinket_31': "Last Ride",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_32.WeaponTrinket_32': "Lil' Chomper",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_33.WeaponTrinket_33': "Just In Case",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_34.WeaponTrinket_34': "Kaboom Bunny",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_35.WeaponTrinket_35': "Frakkin' Toaster",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_37.WeaponTrinket_37': "God-King's Bling",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_38.WeaponTrinket_38': "Hunter's Patch",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_39.WeaponTrinket_39': "On the Hunt",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_4.WeaponTrinket_4': "Earn Your Stripes",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_40.WeaponTrinket_40': "Wittle Warrior",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_41.WeaponTrinket_41': "Null and V0id",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_42.WeaponTrinket_42': "One Army",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_43.WeaponTrinket_43': "Who Needs Gods?",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_44.WeaponTrinket_44': "Explosives Enthusiast",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_45.WeaponTrinket_45': "When In Doubt, Chuck It",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_46.WeaponTrinket_46': "Turtle Up",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_47.WeaponTrinket_47': "Switch Hitter",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_48.WeaponTrinket_48': "One Shot",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_49.WeaponTrinket_49': "Track and Destroy",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_5.WeaponTrinket_5': "Goodnight Kiss",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_50.WeaponTrinket_50': "Adapt and Overcome",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_51.WeaponTrinket_51': "Gold Tier",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_52.WeaponTrinket_52': "Neon Skelly",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_53.WeaponTrinket_53': "Diamond Ponytail",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_54.WeaponTrinket_54': "Gearbox Fan",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_57.WeaponTrinket_57': "Vault Insider VIP",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_58.WeaponTrinket_58': "For Funsies",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_6.WeaponTrinket_6': "Book of the Storm",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_7.WeaponTrinket_7': "Splorghuld, the Flesh-Slayer",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_8.WeaponTrinket_8': "Action Axton",
        '/Game/Gear/WeaponTrinkets/_Design/TrinketParts/WeaponTrinket_9.WeaponTrinket_9': "Hoops Dreams",
        '/Game/PatchDLC/Alisma/Gear/WeaponTrinkets/_Shared/Trinket_League_BloodyHarvest_2020.Trinket_League_BloodyHarvest_2020': "A Shrinking Feeling",
        '/Game/PatchDLC/Alisma/Gear/WeaponTrinkets/Trinket_DLC4_Trinket_01.Trinket_DLC4_Trinket_01': "Divergent Thinking",
        '/Game/PatchDLC/Alisma/Gear/WeaponTrinkets/Trinket_DLC4_Trinket_02.Trinket_DLC4_Trinket_02': "King's Knight",
        '/Game/PatchDLC/BloodyHarvest/Gear/Weapons/WeaponTrinkets/_Shared/Trinket_League_BloodyHarvest_1.Trinket_League_BloodyHarvest_1': "Shrunk 'n Dead",
        '/Game/PatchDLC/Customizations/Gear/Weapons/WeaponTrinkets/WeaponTrinket_59.WeaponTrinket_59': "Caster Blaster",
        '/Game/PatchDLC/Dandelion/Gear/WeaponTrinkets/_Shared/Trinket_Dandelion_01_JackGoldenMask.Trinket_Dandelion_01_JackGoldenMask': "Nothing Gold Can Stay",
        '/Game/PatchDLC/Dandelion/Gear/WeaponTrinkets/_Shared/Trinket_Dandelion_02_Mimic.Trinket_Dandelion_02_Mimic': "Slot Shot",
        '/Game/PatchDLC/Dandelion/Gear/WeaponTrinkets/_Shared/Trinket_MercenaryDay_01_CandyCane.Trinket_MercenaryDay_01_CandyCane': "Mercenary Day Ornament",
        '/Game/PatchDLC/Event2/Gear/_Design/WeaponTrinkets/WeaponTrinket_Cartels_1.WeaponTrinket_Cartels_1': "Retro Outrunner",
        '/Game/PatchDLC/Event2/Gear/_Design/WeaponTrinkets/WeaponTrinket_Cartels_2021.WeaponTrinket_Cartels_2021': "Pandora Sunset",
        '/Game/PatchDLC/EventVDay/Gear/Weapon/WeaponTrinkets/_Shared/Trinket_League_VDay_1.Trinket_League_VDay_1': "Cosmic Romance",
        '/Game/PatchDLC/EventVDay/Gear/Weapon/WeaponTrinkets/_Shared/Trinket_League_VDay_2.Trinket_League_VDay_2': "Tentacle Ventricles",
        '/Game/PatchDLC/EventVDay/TwitchDrops/Gear/Weapon/WeaponTrinkets/_Shared/Trinket_Twitch.Trinket_Twitch': "Pain Freeze",
        '/Game/PatchDLC/Geranium/Customizations/WeaponTrinket/WeaponTrinket_DLC3_1.WeaponTrinket_DLC3_1': "Devil Tooth",
        '/Game/PatchDLC/Geranium/Customizations/WeaponTrinket/WeaponTrinket_DLC3_2.WeaponTrinket_DLC3_2': "Battle Driver",
        '/Game/PatchDLC/Hibiscus/Gear/WeaponTrinkets/_Shared/Trinket_Hibiscus_01_Squidly.Trinket_Hibiscus_01_Squidly': "Tactical Tentacle",
        '/Game/PatchDLC/Hibiscus/Gear/WeaponTrinkets/_Shared/Trinket_Hibiscus_02_Necrocookmicon.Trinket_Hibiscus_02_Necrocookmicon': "Nibblenomicon",
        '/Game/PatchDLC/Ixora/Gear/Weapons/WeaponTrinkets/_Design/WeaponTrinket_GearUp.WeaponTrinket_GearUp': "Dahl Tags",
        '/Game/PatchDLC/Steam/Gear/WeaponTrinkets/WeaponTrinket_SteamPunk.WeaponTrinket_SteamPunk': "Vapor Hoodlum",
        '/Game/PatchDLC/VaultCard/Gear/WeaponTrinkets/_Design/WeaponTrinket_VC1_1.WeaponTrinket_VC1_1': "Ascension",
        '/Game/PatchDLC/VaultCard/Gear/WeaponTrinkets/_Design/WeaponTrinket_VC1_2.WeaponTrinket_VC1_2': "Tinker's Trinket",
        '/Game/PatchDLC/VaultCard/Gear/WeaponTrinkets/_Design/WeaponTrinket_VC1_3.WeaponTrinket_VC1_3': "Deploy and Destroy",
        '/Game/PatchDLC/VaultCard/Gear/WeaponTrinkets/_Design/WeaponTrinket_VC1_4.WeaponTrinket_VC1_4': "De Leon's Lash",
        }
profile_weapontrinkets_hash_to_eng = weapon_cust_paths_to_hash(profile_weapontrinkets_obj_to_eng)
profile_weapontrinkets_eng_to_hash = {v: k for k, v in profile_weapontrinkets_hash_to_eng.items()}

# Golden Keys
goldenkey_category = '/Game/Gear/_Shared/_Design/InventoryCategories/InventoryCategory_GoldenKey'
goldenkey_hash = inventory_path_hash(goldenkey_category)

# Vault Card #1 Keys
vaultcard1key_category = '/Game/Gear/_Shared/_Design/InventoryCategories/InventoryCategory_VaultCard1Key'
vaultcard1key_hash = inventory_path_hash(vaultcard1key_category)

# Diamond Keys
diamondkey_category = '/Game/Gear/_Shared/_Design/InventoryCategories/InventoryCategory_DiamondKey'
diamondkey_hash = inventory_path_hash(diamondkey_category)

# XP
max_level = 72
required_xp_list = [
    0,          # lvl 1
    358,        # lvl 2
    1241,       # lvl 3
    2850,       # lvl 4
    5376,       # lvl 5
    8997,       # lvl 6
    13886,      # lvl 7
    20208,      # lvl 8
    28126,      # lvl 9
    37798,      # lvl 10
    49377,      # lvl 11
    63016,      # lvl 12
    78861,      # lvl 13
    97061,      # lvl 14
    117757,     # lvl 15
    141092,     # lvl 16
    167206,     # lvl 17
    196238,     # lvl 18
    228322,     # lvl 19
    263595,     # lvl 20
    302190,     # lvl 21
    344238,     # lvl 22
    389873,     # lvl 23
    439222,     # lvl 24
    492414,     # lvl 25
    549578,     # lvl 26
    610840,     # lvl 27
    676325,     # lvl 28
    746158,     # lvl 29
    820463,     # lvl 30
    899363,     # lvl 31
    982980,     # lvl 32
    1071435,    # lvl 33
    1164850,    # lvl 34
    1263343,    # lvl 35
    1367034,    # lvl 36
    1476041,    # lvl 37
    1590483,    # lvl 38
    1710476,    # lvl 39
    1836137,    # lvl 40
    1967582,    # lvl 41
    2104926,    # lvl 42
    2248285,    # lvl 43
    2397772,    # lvl 44
    2553501,    # lvl 45
    2715586,    # lvl 46
    2884139,    # lvl 47
    3059273,    # lvl 48
    3241098,    # lvl 49
    3429728,    # lvl 50
    3625271,    # lvl 51
    3827840,    # lvl 52
    4037543,    # lvl 53
    4254491,    # lvl 54
    4478792,    # lvl 55
    4710556,    # lvl 56
    4949890,    # lvl 57
    5196902,    # lvl 58
    5451701,    # lvl 59
    5714393,    # lvl 60
    5985086,    # lvl 61
    6263885,    # lvl 62
    6550897,    # lvl 63
    6846227,    # lvl 64
    7149982,    # lvl 65
    7462266,    # lvl 66
    7783184,    # lvl 67
    8112840,    # lvl 68
    8451340,    # lvl 69
    8798786,    # lvl 70
    9155282,    # lvl 71
    9520932,    # lvl 72
    9895837,    # lvl 73
    10280103,    # lvl 74
    10673830,    # lvl 75
    11077120,    # lvl 76
    11490077,    # lvl 77
    11912801,    # lvl 78
    12345393,    # lvl 79
    12787955,    # lvl 80
]
max_supported_level = len(required_xp_list)

# Mayhem parts
mayhem_part_to_lvl = {
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_01.Part_WeaponMayhemLevel_01': 1,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_02.Part_WeaponMayhemLevel_02': 2,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_03.Part_WeaponMayhemLevel_03': 3,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_04.Part_WeaponMayhemLevel_04': 4,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_05.Part_WeaponMayhemLevel_05': 5,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_06.Part_WeaponMayhemLevel_06': 6,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_07.Part_WeaponMayhemLevel_07': 7,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_08.Part_WeaponMayhemLevel_08': 8,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_09.Part_WeaponMayhemLevel_09': 9,
        '/Game/PatchDLC/Mayhem2/Gear/Weapon/_Shared/_Design/MayhemParts/Part_WeaponMayhemLevel_10.Part_WeaponMayhemLevel_10': 10,
        }
mayhem_part_lower_to_lvl = {k.lower(): v for k, v in mayhem_part_to_lvl.items()}
mayhem_lvl_to_part = {v: k for k, v in mayhem_part_to_lvl.items()}
mayhem_max = max(mayhem_part_to_lvl.values())

# InvData types which can accept Mayhem parts
# (may have to be more clever about this if non-guns start accepting *different* Mayhem parts)
mayhem_invdata_types = set([
    '/Game/Gear/Weapons/AssaultRifles/Atlas/_Shared/_Design/WT_AR_ATL.WT_AR_ATL',
    '/Game/Gear/Weapons/AssaultRifles/ChildrenOfTheVault/_Shared/_Design/WT_AR_COV.WT_AR_COV',
    '/Game/Gear/Weapons/AssaultRifles/Dahl/_Shared/_Design/WT_AR_DAL.WT_AR_DAL',
    '/Game/Gear/Weapons/AssaultRifles/Jakobs/_Shared/_Design/WT_AR_JAK.WT_AR_JAK',
    '/Game/Gear/Weapons/AssaultRifles/Torgue/_Shared/_Design/WT_AR_TOR.WT_AR_TOR',
    '/Game/Gear/Weapons/AssaultRifles/Vladof/_Shared/_Design/WT_AR_VLA.WT_AR_VLA',
    '/Game/Gear/Weapons/HeavyWeapons/ATL/_Shared/_Design/WT_HW_ATL.WT_HW_ATL',
    '/Game/Gear/Weapons/HeavyWeapons/ChildrenOfTheVault/_Shared/_Design/WT_HW_COV.WT_HW_COV',
    '/Game/Gear/Weapons/HeavyWeapons/Torgue/_Shared/_Design/WT_HW_TOR.WT_HW_TOR',
    '/Game/Gear/Weapons/HeavyWeapons/Vladof/_Shared/_Design/WT_HW_VLA.WT_HW_VLA',
    '/Game/Gear/Weapons/Pistols/Atlas/_Shared/_Design/WT_PS_ATL.WT_PS_ATL',
    '/Game/Gear/Weapons/Pistols/ChildrenOfTheVault/_Shared/_Design/WT_PS_COV.WT_PS_COV',
    '/Game/Gear/Weapons/Pistols/Dahl/_Shared/_Design/WT_PS_DAL.WT_PS_DAL',
    '/Game/Gear/Weapons/Pistols/Jakobs/_Shared/_Design/WT_PS_JAK.WT_PS_JAK',
    '/Game/Gear/Weapons/Pistols/Maliwan/_Shared/_Design/WT_PS_MAL.WT_PS_MAL',
    '/Game/Gear/Weapons/Pistols/Tediore/Shared/_Design/WT_PS_TED.WT_PS_TED',
    '/Game/Gear/Weapons/Pistols/Torgue/_Shared/_Design/WT_PS_TOR.WT_PS_TOR',
    '/Game/Gear/Weapons/Pistols/Vladof/_Shared/_Design/WT_PS_VLA.WT_PS_VLA',
    '/Game/Gear/Weapons/SMGs/Dahl/_Shared/_Design/WT_SM_DAL.WT_SM_DAL',
    '/Game/Gear/Weapons/SMGs/Hyperion/_Shared/_Design/WT_SM_HYP.WT_SM_HYP',
    '/Game/Gear/Weapons/SMGs/Maliwan/_Shared/_Design/WT_SM_MAL.WT_SM_MAL',
    '/Game/Gear/Weapons/SMGs/Tediore/_Shared/_Design/WT_SM_TED.WT_SM_TED',
    '/Game/Gear/Weapons/Shotguns/Hyperion/_Shared/_Design/WT_SG_HYP.WT_SG_HYP',
    '/Game/Gear/Weapons/Shotguns/Jakobs/_Shared/_Design/WT_SG_JAK.WT_SG_JAK',
    '/Game/Gear/Weapons/Shotguns/Maliwan/_Shared/_Design/WT_SG_MAL.WT_SG_MAL',
    '/Game/Gear/Weapons/Shotguns/Tediore/_Shared/_Design/WT_SG_TED.WT_SG_TED',
    '/Game/Gear/Weapons/Shotguns/Torgue/_Shared/_Design/WT_SG_TOR.WT_SG_TOR',
    '/Game/Gear/Weapons/SniperRifles/Dahl/_Shared/_Design/WT_SR_DAL.WT_SR_DAL',
    '/Game/Gear/Weapons/SniperRifles/Hyperion/_Shared/_Design/WT_SR_HYP.WT_SR_HYP',
    '/Game/Gear/Weapons/SniperRifles/Jakobs/_Shared/_Design/WT_SR_JAK.WT_SR_JAK',
    '/Game/Gear/Weapons/SniperRifles/Maliwan/Shared/_Design/WT_SR_MAL.WT_SR_MAL',
    '/Game/Gear/Weapons/SniperRifles/Vladof/_Shared/_Design/WT_SR_VLA.WT_SR_VLA',
    '/Game/Gear/GrenadeMods/_Design/A_Data/GM_Default.GM_Default',
    ])
mayhem_invdata_lower_types = set([t.lower() for t in mayhem_invdata_types])

# Anointable InvData types - will be identical to Mayhemable list, plus shields
anointable_invdata_types = mayhem_invdata_types | set(['/Game/Gear/Shields/_Design/A_Data/Shield_Default.Shield_Default'])
anointable_invdata_lower_types = set([t.lower() for t in anointable_invdata_types])

# Guardian Rank Rewards
guardian_rank_rewards = set([
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_Accuracy.GuardianReward_Accuracy',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_ActionSkillCooldown.GuardianReward_ActionSkillCooldown',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_CriticalDamage.GuardianReward_CriticalDamage',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_FFYLDuration.GuardianReward_FFYLDuration',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_FFYLMovementSpeed.GuardianReward_FFYLMovementSpeed',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_GrenadeDamage.GuardianReward_GrenadeDamage',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_GunDamage.GuardianReward_GunDamage',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_GunFireRate.GuardianReward_GunFireRate',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_MaxHealth.GuardianReward_MaxHealth',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_MeleeDamage.GuardianReward_MeleeDamage',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_RarityRate.GuardianReward_RarityRate',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_RecoilReduction.GuardianReward_RecoilReduction',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_ReloadSpeed.GuardianReward_ReloadSpeed',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_ShieldCapacity.GuardianReward_ShieldCapacity',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_ShieldRechargeDelay.GuardianReward_ShieldRechargeDelay',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_ShieldRechargeRate.GuardianReward_ShieldRechargeRate',
    '/Game/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_VehicleDamage.GuardianReward_VehicleDamage',
    '/Game/PatchDLC/Hibiscus/PlayerCharacters/_Shared/_Design/GuardianRank/GuardianReward_ElementalDamage.GuardianReward_ElementalDamage',
    ])

# Eridian Cube Puzzle stat
cube_puzzle_stat = '/Game/PlayerCharacters/_Shared/_Design/Stats/GameSystem/Stat_GameSystem_BeachCubeSolved.Stat_GameSystem_BeachCubeSolved'

# Takedown Discovery missions
takedown_missions = {
        '/Game/PatchDLC/Raid1/Missions/Mission_Raid1Intro.Mission_Raid1Intro_C': (
            '/Game/PatchDLC/Raid1/Missions/Mission_Raid1Intro.Set_MissionEnd_ObjectiveSet',
            [1, 0, 0, 1, 0]),
        '/Game/PatchDLC/Takedown2/Missions/Side/Mission_Takedown2_Intro.Mission_Takedown2_Intro_C': (
            '/Game/PatchDLC/Takedown2/Missions/Side/Mission_Takedown2_Intro.Set_MissionEnd_ObjectiveSet',
            [1, 0, 0, 1, 0]),
        }

# Mission names
#
# For most missions, the following find statement will generate this list:
#
#    for file in $(find Game/Missions Game/PatchDLC/Dandelion/Missions Game/PatchDLC/Hibiscus/Missions Game/PatchDLC/Raid1/Missions Game/PatchDLC/BloodyHarvest/Missions Game/PatchDLC/CitizenScience/Missions Game/PatchDLC/Event2/Missions Game/PatchDLC/Takedown2/Missions Game/PatchDLC/Geranium/Missions Game/PatchDLC/Alisma/Missions Game/PatchDLC/Ixora/Missions Game/PatchDLC/Ixora2/Missions \( -iname "Mission_*.uexp" -o -name "SideMission_*.uexp" -o -name "EP*_DLC2.uexp" -o -name "ALI_EP*.uexp" -o -name "ALI_SM_*.uexp" \) -print); do echo -n "'/$(dirname $file)/$(basename $file .uexp)': \""; echo $(strings $file | head -n 2 | tail -n 1)\",; done
#
# Various plot missions, though, from both the main game and DLC1, will need
# some edits by hand (they use a UIName_*_MissionTitle object instead.)  Also,
# the Rare Spawn missions need the second string, not the first, so you'll
# want to run this to grab those:
#
#    for file in $(find Game/Missions/Side/RareSpawn Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn -iname "Mission_*.uexp" -print); do echo -n "'/$(dirname $file)/$(basename $file .uexp)': \""; echo $(strings $file | head -n 4 | tail -n 1)\",; done
#    
# Keep in mind that the El Dragon Jr one will need a hand edit, since `strings`
# only matches on latin1 by default (at least on the GNU/Linux version).
mission_to_name = {
        '/Game/Missions/Plot/Mission_Ep01_ChildrenOfTheVault': "Children of the Vault",
        '/Game/Missions/Plot/Mission_Ep02_Sacrifice': "From the Ground Up",
        '/Game/Missions/Plot/Mission_Ep03_GetVaultMap': "Cult Following",
        '/Game/Missions/Plot/Mission_Ep04_EarnSpaceship': "Taking Flight",
        '/Game/Missions/Plot/Mission_Ep05_OvercomeHQBlockade': "Hostile Takeover",
        '/Game/Missions/Plot/Mission_Ep05_Sanctuary': "Sanctuary",
        '/Game/Missions/Plot/Mission_Ep06_MeetMaya': "The Impending Storm",
        '/Game/Missions/Plot/Mission_Ep08_OrbitalPlatform': "Space-Laser Tag",
        '/Game/Missions/Plot/MIssion_Ep09_AtlasHQ': "Atlas, At Last",
        '/Game/Missions/Plot/Mission_Ep10_CityVault': "Beneath the Meridian",
        '/Game/Missions/Plot/Mission_Ep11_PrisonBreak': "Hammerlocked",
        '/Game/Missions/Plot/Mission_Ep12_GrandTour': "Lair of the Harpy",
        '/Game/Missions/Plot/Mission_Ep13_JakobsRebellion': "The Guns of Reliance",
        '/Game/Missions/Plot/Mission_Ep13_Watership': "The Family Jewel",
        '/Game/Missions/Plot/Mission_Ep15_MarshFields': "Going Rogue",
        '/Game/Missions/Plot/Mission_Ep16_DesertVault': "The Great Vault",
        '/Game/Missions/Plot/Mission_Ep16_SiblingRivalry': "Cold as the Grave",
        '/Game/Missions/Plot/Mission_Ep17_BigChase': "Blood Drive",
        '/Game/Missions/Plot/Mission_Ep19_MinerDetails': "Angels and Speed Demons",
        '/Game/Missions/Plot/Mission_Ep20_FirstVaultHunter': "The First Vault Hunter",
        '/Game/Missions/Plot/Mission_Ep21_Beachhead': "Footsteps of Giants",
        '/Game/Missions/Plot/Mission_Ep22_TheMachine': "In the Shadow of Starlight",
        '/Game/Missions/Plot/Mission_Ep23_TyreenFinalBoss': "Divine Retribution",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds1/Mission_ProvingGrounds_Mission01': "Trial of Survival",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds1/Mission_ProvingGroundsDiscovery_Mission01': "Discover the Trial of Survival",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds4/Mission_ProvingGrounds_Mission04': "Trial of Fervor",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds4/Mission_ProvingGroundsDiscovery_Mission04': "Discover the Trial of Fervor",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds5/Mission_ProvingGrounds_Mission05': "Trial of Cunning",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds5/Mission_ProvingGroundsDiscovery_Mission05': "Discover the Trial of Cunning",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds6/Mission_ProvingGrounds_Mission06': "Trial of Supremacy",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds6/Mission_ProvingGroundsDiscovery_Mission06': "Discover the Trial of Supremacy",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds7/Mission_ProvingGrounds_Mission07': "Trial of Discipline",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds7/Mission_ProvingGroundsDiscovery_Mission07': "Discover the Trial of Discipline",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds8/Mission_ProvingGrounds_Mission08': "Trial of Instinct",
        '/Game/Missions/Side/ProvingGrounds/ProvingGrounds8/Mission_ProvingGroundsDiscovery_Mission08': "Discover the Trial of Instinct",
        '/Game/Missions/Side/Raid/Raid/Mission_RaidOnMaliwan': "Raid On Maliwan",
        '/Game/Missions/Side/RareSpawn/Mission_Async_BormanNates': "Kill Borman Nates",
        '/Game/Missions/Side/RareSpawn/Mission_Async_CaptainThunkAndSloth': "Kill Captain Thunk and Sloth",
        '/Game/Missions/Side/RareSpawn/Mission_Async_DemoSkag': "Kill Demoskaggon",
        '/Game/Missions/Side/RareSpawn/Mission_Async_Dinklebot': "Kill Dinklebot",
        '/Game/Missions/Side/RareSpawn/Mission_Async_ElDragonJr': "Kill El Dragón Jr",
        '/Game/Missions/Side/RareSpawn/Mission_Async_EnforcerUrist': "Kill Urist McEnforcer",
        '/Game/Missions/Side/RareSpawn/Mission_Async_IndoTyrant': "Kill IndoTyrant",
        '/Game/Missions/Side/RareSpawn/Mission_Async_Maxitrillion': "Kill Maxitrillion",
        '/Game/Missions/Side/RareSpawn/Mission_Async_PowerTroopers': "Kill the Power Troopers",
        '/Game/Missions/Side/RareSpawn/Mission_Async_Rakkman': "Kill Rakkman",
        '/Game/Missions/Side/RareSpawn/Mission_Async_RedJabber': "Kill Red Jabber",
        '/Game/Missions/Side/RareSpawn/Mission_Async_RoadDog': "Kill Road Dog",
        '/Game/Missions/Side/RareSpawn/Mission_Async_Tarantella': "Kill Tarantella",
        '/Game/Missions/Side/RareSpawn/Mission_Async_TheUnstoppable': "Kill The Unstoppable",
        '/Game/Missions/Side/RareSpawn/Mission_Async_ThreeDragons': "Kill the Grogans and Their Mother",
        '/Game/Missions/Side/RareSpawn/Mission_Async_VicAndWarty': "Kill Wick and Warty",
        '/Game/Missions/Side/Sanctuary3/Mission_Infestation': "The Kevin Konundrum",
        '/Game/Missions/Side/Sanctuary3/Mission_JustAPrick': "Just A Prick",
        '/Game/Missions/Side/Slaughters/CoVSlaughter/Mission_COVSlaughter1': "The Slaughter Shaft",
        '/Game/Missions/Side/Slaughters/CreatureSlaughter/Mission_CreatureSlaughter': "Cistern of Slaughter",
        '/Game/Missions/Side/Slaughters/TechSlaughter/Mission_TechSlaughter1': "Tech Slaughter",
        '/Game/Missions/Side/Slaughters/TechSlaughter/Mission_TechSlaughterDiscovery': "Welcome to Slaughterstar 3000",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_BadReception': "Bad Reception",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_FineDining': "Skag Dog Days",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_Scoopers_Bully': "Dump on Dumptruck",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_UnderwearTink': "Under Taker",
        '/Game/Missions/Side/Zone_0/Prologue/Mission_VendingMachineRepair': "Powerful Connections",
        '/Game/Missions/Side/Zone_0/Sacrifice/Mission_GoldenCalves': "Golden Calves",
        '/Game/Missions/Side/Zone_0/Sacrifice/Mission_HeadCase': "Head Case",
        '/Game/Missions/Side/Zone_0/Sacrifice/Mission_PandorasNextTopMouthpiece': "Pandora's Next Top Mouthpiece",
        '/Game/Missions/Side/Zone_1/Athenas/Mission_InvasionOfPrivacy': "Invasion of Privacy",
        '/Game/Missions/Side/Zone_1/Athenas/Mission_MonkMission': "Holy Spirits",
        '/Game/Missions/Side/Zone_1/AtlasHQ/Mission_RatchetItUp': "Ratch'd Up",
        '/Game/Missions/Side/Zone_1/City/Mission_BitterPillToSwallow': "Healers and Dealers",
        '/Game/Missions/Side/Zone_1/City/Mission_DynastyDiner': "Dynasty Diner",
        '/Game/Missions/Side/Zone_1/City/Mission_PissingContest': "Maliwannabees",
        '/Game/Missions/Side/Zone_1/City/Mission_RiseAndGrind': "Rise and Grind",
        '/Game/Missions/Side/Zone_1/City/Mission_WizardOfNogs': "Technical NOGout",
        '/Game/Missions/Side/Zone_1/OrbitalPlatform/OppositionResearch/Mission_OppResearch': "Opposition Research",
        '/Game/Missions/Side/Zone_1/Towers/Mission_KillKillavolt': "Kill Killavolt",
        '/Game/Missions/Side/Zone_1/Towers/Mission_LastKatagawa': "Proof of Wife",
        '/Game/Missions/Side/Zone_1/Towers/Mission_Porta-Prison': "Porta Prison",
        '/Game/Missions/Side/Zone_2/Mansion/Mission_AureliasSkeletons': "Sacked",
        '/Game/Missions/Side/Zone_2/Mansion/Mission_WitchesBrew': "Witch's Brew",
        '/Game/Missions/Side/Zone_2/MarshFields/Mission_RockOnPandora': "Raiders of the Lost Rock",
        '/Game/Missions/Side/Zone_2/MarshFields/Mission_SuckerPunch': "Sell Out",
        '/Game/Missions/Side/Zone_2/Prison/Mission_FreeHugs': "On the Blood Path",
        '/Game/Missions/Side/Zone_2/Prison/Mission_MalevolentPractice': "Malevolent Practice",
        '/Game/Missions/Side/Zone_2/Watership/Mission_RumbleJungle': "Rumble In The Jungle",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_DriveAwayThePain': "Get Quick, Slick",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_DudeBro': "Swamp Bro",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_DynastyDash_Wetlands': "Dynasty Dash: Eden-6",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_DynastyDash_Wetlands_Repeatable': "Dynasty Dash: Floodmoor Basin",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_SpecialDelivery': "Capture the Frag",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_TheHangover': "Irregular Customers",
        '/Game/Missions/Side/Zone_2/Wetlands/Mission_TortureTruck': "Don't Truck with Eden-6",
        '/Game/Missions/Side/Zone_3/Desert/Mission_BabyDancer': "Baby Dancer",
        '/Game/Missions/Side/Zone_3/Desert/Mission_BirthdaySurprise': "Life of the Party",
        '/Game/Missions/Side/Zone_3/Desert/Mission_BuffFilmBuff': "Buff Film Buff",
        '/Game/Missions/Side/Zone_3/Desert/Mission_CaringForElderly': "The Feeble and the Furious",
        '/Game/Missions/Side/Zone_3/Desert/Mission_ChangeOfHeart': "Sheega's All That",
        '/Game/Missions/Side/Zone_3/Desert/Mission_DynastyDash_Desert': "Dynasty Dash: Pandora",
        '/Game/Missions/Side/Zone_3/Desert/Mission_DynastyDash_Desert_Repeatable': "Dynasty Dash: Devil's Razor",
        '/Game/Missions/Side/Zone_3/Desert/Mission_EchoNetNeutrality': "ECHOnet Neutrality",
        '/Game/Missions/Side/Zone_3/Desert/Mission_ItsComplicated': "Boom Boom Boomtown",
        '/Game/Missions/Side/Zone_3/Mine/Mission_BridgeInTheDark': "The Demon in the Dark",
        '/Game/Missions/Side/Zone_3/Mine/Mission_GrowingPains': "Childhood's End",
        '/Game/Missions/Side/Zone_3/Mine/Mission_WildlifeConservation': "Wildlife Conservation",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Gameshow': "Let's Get It Vaughn",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Homestead_Part1': "The Homestead",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Homestead_Part2': "The Homestead (Part 2)",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Homestead_Part3': "The Homestead (Part 3)",
        '/Game/Missions/Side/Zone_3/Motorcade/Mission_Just_Desserts': "Just Desserts",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_BetterTimes': "Fire in the Sky",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_BoneDeep': "Bad Vibrations",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_Canonization': "Cannonization",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_DestroyerOfWorlds': "Transaction-Packed",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_Homeopathological': "Homeopathological",
        '/Game/Missions/Side/Zone_4/Desolate/Mission_ItsAlive2': "It's Alive",
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP01': "Enter the Psychoscape",
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP02': "Siege of Castle Crimson",
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP03': "What Love Remains",
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP04': "Inhuman Trials",
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP05': "Locus of Rage",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_AllShapesAndCalibers': "A Good Egg",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_BlastRequests': "Blast Requests",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_ChecksAndBalances': "Check, Please",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_ExposureTherapy': "Remodel Behavior",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_GoodbyeOldFriend': "Laid to Rust",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_HotNBothered': "Hot and Unbothered",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_InkBlots': "Don't Call it a Rorschach",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_ParadeHarpoon': "Krieg's on Parade",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_ShadesOfTruth': "It's an Allegory",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_SpineTingler': "Scratch, Don't Sniff",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_StrongBones': "Does a Body Good",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_ThatRingsABell': "That Rings a Something",
        '/Game/PatchDLC/Alisma/Missions/Side/ALI_SM_WhenItRains': "Brainstorm",
        '/Game/PatchDLC/BloodyHarvest/Missions/Side/Seasonal/Mission_Season_01_Intro': "Bloody Harvest: Descent into Heck",
        '/Game/PatchDLC/BloodyHarvest/Missions/Side/Seasonal/Mission_Season_01_Repeatable': "Bloody Harvest: The Rebloodening",
        '/Game/PatchDLC/CitizenScience/Missions/Mission_CitizenScience_Intro': "Borderlands Science!",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep01_MeetTimothy': "The Handsome Jackpot",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep02_MeetCrad': "Playing with Fire",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep03_Impound': "Winners and Losers",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep04_Trashtown': "One Man's Treasure",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep05_ThePlan': "The Plan",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep06_TheCore': "Jack's Wild",
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep07_TheHeist': "All Bets Off",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_AcidTrip': "Acid Trip",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_BrotherlyLove': "Sisterly Love",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_DoItForDigby_Part1': "Do it for Digby - Part 1",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_DoItForDigby_Part2': "Do it for Digby - Part 2",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_DoItForDigby_Part3': "Do it for Digby - Part 3",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_DoubleDown': "Double Down",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_GreatEscape': "The Great Escape",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_HeartOfGold': "Heart of Gold",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_RagingBot': "Raging Bot",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_RegainingOnesFeet': "Regaining One's Feet",
        '/Game/PatchDLC/Dandelion/Missions/Side/Mission_DLC1_Side_TooMuchOfAGoodThing': "Too Much Of A Good Thing",
        '/Game/PatchDLC/Event2/Missions/Side/MauriceSide/Mission_Maurice': "Claw and Order",
        '/Game/PatchDLC/Event2/Missions/Side/Seasonal/Mission_Season_02_Intro': "Revenge of the Cartels: Ultraviolet Nights",
        '/Game/PatchDLC/Event2/Missions/Side/Seasonal/Mission_Season_02_Repeatable': "Revenge of the Cartels II: The Revengening",
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep01_WestlandWelcome': "Blood From A Stone",
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep02_Bathhouse': "The Name of the Law",
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep03_ObsidianForest': "Off the Rails",
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep04_Facility': "Where It All Started",
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep05_Crater': "Riding to Ruin",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_AnimalControl': "Lost and Found",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_BloodAndBeans': "Of Blood and Beans",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_DirtyDeeds': "Dirty Deeds",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_Dueling': "The Quick and the Quickerer",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_GhostStories': "The Meatman Prophecy",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_LoveBarsNone': "The Dandy and Damsel",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_MoneyBackGuarantee': "Money Back Guarantee",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_RustlerBaby': "Devil Rustlers",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_SaurdewValley': "Saurdew Valley",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_SnakeOil': "Miracle Elixir Fixer",
        '/Game/PatchDLC/Geranium/Missions/Side/Mission_TheLegendOfMcSmugger': "The Legend of McSmugger",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP01_DLC2': "The Party Out of Space",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP02_DLC2': "The Shadow Over Cursehaven",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP03_DLC2': "The Case of Wainwright Jakobs",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP04_DLC2': "The Horror in the Woods",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP05_DLC2': "On the Mountain of Mayhem",
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP06_DLC2': "The Call of Gythian",
        '/Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn/Mission_Async_FrostbiteDragon': "Kill Shiverous the Unscathed",
        '/Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn/Mission_Async_MushroomGiant': "Kill Fungal Gorger",
        '/Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn/Mission_Async_Shocker': "Kill Voltborn",
        '/Game/PatchDLC/Hibiscus/Missions/Side/RareSpawn/Mission_Async_ZealotPilfer': "Kill Amach",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_Bounty_BusinessAsUsual': "The Proprietor: Rare Vintage",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_Bounty_DebtCollector': "The Proprietor: Empty Bottles",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_HappilyEverAfter': "Happily Ever After",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_IntoTheDeep': "The Madness Beneath",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_Necrocookmicon': "The Nibblenomicon",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_PrivateEyePart1': "Cold Case: Buried Questions",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_PrivateEyePart2': "Cold Case: Restless Memories",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_PrivateEyePart3': "Cold Case: Forgotten Answers",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_ReturnOfMaxSky': "The Great Escape (Part 2)",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_SinisterSounds': "Sinister Sounds",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_WeSlassPart1': "We Slass!",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_WeSlassPart2': "We Slass! (Part 2)",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_WeSlassPart3': "We Slass! (Part 3)",
        '/Game/PatchDLC/Hibiscus/Missions/Side/SideMission_DLC2_WhereIBelong': "Call of the Deep",
        '/Game/PatchDLC/Ixora/Missions/Side/Mission_GearUp': "Arms Race",
        '/Game/PatchDLC/Ixora/Missions/Side/Mission_GearUp_Intro': "Arms Race: Introduction",
        '/Game/PatchDLC/Ixora2/Missions/Side/Mission_Ixora_Main01': "Mysteriouslier: Murder on Eschaton Row",
        '/Game/PatchDLC/Ixora2/Missions/Side/Mission_Ixora_Main02': "Mysteriouslier: The Vanishing of Hizzen Mays",
        '/Game/PatchDLC/Ixora2/Missions/Side/Mission_Ixora_Main03': "Mysteriouslier: Ghosts of Karass Canyon",
        '/Game/PatchDLC/Ixora2/Missions/Side/Mission_Ixora_Main04': "Mysteriouslier: Horror at Scryer's Crypt",
        '/Game/PatchDLC/Ixora2/Missions/Side/Mission_Ixora_VarkidBoss': "You. Will. Die. (Over and Over.)",
        '/Game/PatchDLC/Raid1/Missions/Mission_Raid1': "Takedown at the Maliwan Blacksite",
        '/Game/PatchDLC/Raid1/Missions/Mission_Raid1Intro': "Discovery: Takedown at the Maliwan Blacksite",
        '/Game/PatchDLC/Takedown2/Missions/Side/Mission_Takedown2': "Takedown at the Guardian Breach",
        '/Game/PatchDLC/Takedown2/Missions/Side/Mission_Takedown2_Intro': "Discovery: Takedown at the Guardian Breach",
        }
for k, v in list(mission_to_name.items()):
    lower = k.lower()
    last_bit = lower.split('/')[-1]
    new_k = '{}.{}_c'.format(lower, last_bit)
    mission_to_name[new_k] = v

# Plot missions (of the sort that we don't want to allow removing, since you'd
# probably be locked out of the plot missions).  These were just copy+pasted
# from the mission_to_name structure above and pruned manually.
plot_missions = set()
for mission_name in [
        '/Game/Missions/Plot/Mission_Ep01_ChildrenOfTheVault',
        '/Game/Missions/Plot/Mission_Ep02_Sacrifice',
        '/Game/Missions/Plot/Mission_Ep03_GetVaultMap',
        '/Game/Missions/Plot/Mission_Ep04_EarnSpaceship',
        '/Game/Missions/Plot/Mission_Ep05_OvercomeHQBlockade',
        '/Game/Missions/Plot/Mission_Ep05_Sanctuary',
        '/Game/Missions/Plot/Mission_Ep06_MeetMaya',
        '/Game/Missions/Plot/Mission_Ep08_OrbitalPlatform',
        '/Game/Missions/Plot/MIssion_Ep09_AtlasHQ',
        '/Game/Missions/Plot/Mission_Ep10_CityVault',
        '/Game/Missions/Plot/Mission_Ep11_PrisonBreak',
        '/Game/Missions/Plot/Mission_Ep12_GrandTour',
        '/Game/Missions/Plot/Mission_Ep13_JakobsRebellion',
        '/Game/Missions/Plot/Mission_Ep13_Watership',
        '/Game/Missions/Plot/Mission_Ep15_MarshFields',
        '/Game/Missions/Plot/Mission_Ep16_DesertVault',
        '/Game/Missions/Plot/Mission_Ep16_SiblingRivalry',
        '/Game/Missions/Plot/Mission_Ep17_BigChase',
        '/Game/Missions/Plot/Mission_Ep19_MinerDetails',
        '/Game/Missions/Plot/Mission_Ep20_FirstVaultHunter',
        '/Game/Missions/Plot/Mission_Ep21_Beachhead',
        '/Game/Missions/Plot/Mission_Ep22_TheMachine',
        '/Game/Missions/Plot/Mission_Ep23_TyreenFinalBoss',
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP01',
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP02',
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP03',
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP04',
        '/Game/PatchDLC/Alisma/Missions/Plot/ALI_EP05',
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep01_MeetTimothy',
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep02_MeetCrad',
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep03_Impound',
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep04_Trashtown',
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep05_ThePlan',
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep06_TheCore',
        '/Game/PatchDLC/Dandelion/Missions/Plot/Mission_DLC1_Ep07_TheHeist',
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep01_WestlandWelcome',
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep02_Bathhouse',
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep03_ObsidianForest',
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep04_Facility',
        '/Game/PatchDLC/Geranium/Missions/Plot/Mission_Ep05_Crater',
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP01_DLC2',
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP02_DLC2',
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP03_DLC2',
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP04_DLC2',
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP05_DLC2',
        '/Game/PatchDLC/Hibiscus/Missions/Plot/EP06_DLC2',
        ]:
    lower = mission_name.lower()
    last_bit = lower.split('/')[-1]
    plot_missions.add('{}.{}_c'.format(lower, last_bit))

# Map-to-eng
map_to_eng = {
        'Anger_P': "Castle Crimson",
        'Archive_P': "Dustbound Archives",
        'AtlasHQ_P': "Atlas HQ",
        'Bar_P': "Lodge",
        'Beach_P': "Tazendeer Ruins",
        'BloodyHarvest_P': "Heck Hole",
        'COVSlaughter_P': "Slaughter Shaft",
        'Cabin_P': "Enoch's Grove",
        'Camp_P': "Negul Neshai",
        'Cartels_P': "Villa Ultraviolet",
        'CasinoIntro_P': "Grand Opening",
        'Chase_P': "Sapphire's Run",
        'CityBoss_P': "Forgotten Basilica",
        'CityVault_P': "Neon Arterial",
        'City_P': "Meridian Metroplex",
        'Convoy_P': "Sandblast Scar",
        'Core_P': "Jack's Secret",
        'CraterBoss_P': "Crater's Edge",
        'CreatureSlaughter_P': "Cistern of Slaughter",
        'Crypt_P': "Pyre of Stars",
        'DesertBoss_P': "Great Vault",
        'Desert_P': "Devil's Razor",
        'Desertvault_P': "Cathedral of the Twin Gods",
        'Desolate_P': "Desolation's Edge",
        'Eldorado_P': "Vaulthalla",
        'Experiment_P': "Benediction of Pain",
        'Facility_P': "Bloodsun Canyon",
        'FinalBoss_P': "Destroyer's Rift",
        'Forest_P': "Obsidian Forest",
        'Frontier_P': "The Blastplains",
        'FrostSite_P': "Stormblind Complex",
        'GuardianTakedown_P': "Minos Prime / The Shattered Tribunal",
        'Impound_P': "Impound Deluxe",
        'Lake_P': "Skittermaw Basin",
        'Lodge_P': "Ashfall Peaks",
        'Mansion_P': "Jakobs Estate",
        'MarshFields_P': "Ambermire",
        'Mine_P': "Konrad's Hold",
        'Monastery_P': "Athenas",
        'MotorcadeFestival_P': "Carnivora",
        'MotorcadeInterior_P': "Guts of Carnivora",
        'Motorcade_P': "Splinterlands",
        'NekroMystery_p': "Scryer's Crypt",
        'Noir_P': "Eschaton Row",
        'OrbitalPlatform_P': "Skywell-27",
        'Outskirts_P': "Meridian Outskirts",
        'PandoraMystery_p': "Karass Canyon",
        'Prison_P': "Anvil",
        'Prologue_P': "Droughts",
        'ProvingGrounds_Trial1_P': "Gradient of Dawn (Survival)",
        'ProvingGrounds_Trial4_P': "Skydrowned Pulpit (Fervor)",
        'ProvingGrounds_Trial5_P': "Ghostlight Beacon (Cunning)",
        'ProvingGrounds_Trial6_P': "Hall Obsidian (Supremacy)",
        'ProvingGrounds_Trial7_P': "Precipice Anchor (Discipline)",
        'ProvingGrounds_Trial8_P': "Wayward Tether (Instinct)",
        'Raid_P': "Midnight's Cairn (Maliwan Takedown)",
        'Recruitment_P': "Covenant Pass",
        'Sacrifice_P': "Ascension Bluff",
        'SacrificeBoss_p': "Darkthirst Dominion",
        'Sanctuary3_P': "Sanctuary",
        'Sanctum_P': "The Psychoscape",
        'Strip_P': "Spendopticon",
        'TechSlaughter_P': "Slaughterstar 3000",
        'TowerLair_P': "VIP Tower",
        'Towers_P': "Lectra City",
        'Town_P': "Vestige",
        'Trashtown_P': "Compactor",
        'Venue_P': "Heart's Desire",
        'Village_P': "Cursehaven",
        'Watership_P': "Voracious Canopy",
        'WetlandsBoss_P': "Floating Tomb",
        'WetlandsVault_P': "Blackbarrel Cellars",
        'Wetlands_P': "Floodmoor Basin",
        'Woods_P': "Cankerwood",
        }

# Autogenerated by gen_fts_mappings.py, in my bl3hotfixmodding project (in dataprocessing)
fts_to_map = {
        '/game/gamedata/fasttravel/fts_atlashq.fts_atlashq': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/fts_atlashq_sendonly.fts_atlashq_sendonly': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/fts_beach.fts_beach': 'Beach_P',
        '/game/gamedata/fasttravel/fts_beach_sendonly.fts_beach_sendonly': 'Beach_P',
        '/game/gamedata/fasttravel/fts_city.fts_city': 'City_P',
        '/game/gamedata/fasttravel/fts_cityboss.fts_cityboss': 'CityBoss_P',
        '/game/gamedata/fasttravel/fts_cityboss_sendonly.fts_cityboss_sendonly': 'CityBoss_P',
        '/game/gamedata/fasttravel/fts_cityvault.fts_cityvault': 'CityVault_P',
        '/game/gamedata/fasttravel/fts_convoy.fts_convoy': 'Convoy_P',
        '/game/gamedata/fasttravel/fts_covslaughter.fts_covslaughter': 'COVSlaughter_P',
        '/game/gamedata/fasttravel/fts_creatureslaughter.fts_creatureslaughter': 'CreatureSlaughter_P',
        '/game/gamedata/fasttravel/fts_crypt.fts_crypt': 'Crypt_P',
        '/game/gamedata/fasttravel/fts_desert1.fts_desert1': 'Desert_P',
        '/game/gamedata/fasttravel/fts_desert2.fts_desert2': 'Desert_P',
        '/game/gamedata/fasttravel/fts_desertboss.fts_desertboss': 'DesertBoss_P',
        '/game/gamedata/fasttravel/fts_desertboss_sendonly.fts_desertboss_sendonly': 'DesertBoss_P',
        '/game/gamedata/fasttravel/fts_desertvault.fts_desertvault': 'Desertvault_P',
        '/game/gamedata/fasttravel/fts_desolate2.fts_desolate2': 'Desolate_P',
        '/game/gamedata/fasttravel/fts_desolatedroppod.fts_desolatedroppod': 'Desolate_P',
        '/game/gamedata/fasttravel/fts_finalboss.fts_finalboss': 'FinalBoss_P',
        '/game/gamedata/fasttravel/fts_finalboss_sendonly.fts_finalboss_sendonly': 'FinalBoss_P',
        '/game/gamedata/fasttravel/fts_finalbossportal.fts_finalbossportal': 'FinalBoss_P',
        '/game/gamedata/fasttravel/fts_grotto.fts_grotto': 'Grotto_P',
        '/game/gamedata/fasttravel/fts_mansion.fts_mansion': 'Mansion_P',
        '/game/gamedata/fasttravel/fts_marshfields.fts_marshfields': 'MarshFields_P',
        '/game/gamedata/fasttravel/fts_marshfields_sendonly.fts_marshfields_sendonly': 'MarshFields_P',
        '/game/gamedata/fasttravel/fts_marshfieldsship.fts_marshfieldsship': 'MarshFields_P',
        '/game/gamedata/fasttravel/fts_mine.fts_mine': 'Mine_P',
        '/game/gamedata/fasttravel/fts_monastery.fts_monastery': 'Monastery_P',
        '/game/gamedata/fasttravel/fts_monastery_sendonly.fts_monastery_sendonly': 'Monastery_P',
        '/game/gamedata/fasttravel/fts_monasterydroppod.fts_monasterydroppod': 'Monastery_P',
        '/game/gamedata/fasttravel/fts_motorcade.fts_motorcade': 'Motorcade_P',
        '/game/gamedata/fasttravel/fts_motorcade2.fts_motorcade2': 'Motorcade_P',
        '/game/gamedata/fasttravel/fts_motorcadefestival.fts_motorcadefestival': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/fts_motorcadeinterior.fts_motorcadeinterior': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/fts_motorcadeinterior_sendonly.fts_motorcadeinterior_sendonly': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/fts_orbitalplatform.fts_orbitalplatform': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/fts_orbitalplatform_sendonly.fts_orbitalplatform_sendonly': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/fts_orbitalshuttle.fts_orbitalshuttle': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/fts_outskirts.fts_outskirts': 'Outskirts_P',
        '/game/gamedata/fasttravel/fts_outskirtsdroppod.fts_outskirtsdroppod': 'Outskirts_P',
        '/game/gamedata/fasttravel/fts_playableintro_sendonly.fts_playableintro_sendonly': 'PlayableIntro_P',
        '/game/gamedata/fasttravel/fts_prison.fts_prison': 'Prison_P',
        '/game/gamedata/fasttravel/fts_prison_sendonly.fts_prison_sendonly': 'Prison_P',
        '/game/gamedata/fasttravel/fts_prologue.fts_prologue': 'Prologue_P',
        '/game/gamedata/fasttravel/fts_prologue2.fts_prologue2': 'Prologue_P',
        '/game/gamedata/fasttravel/fts_provinggrounds00.fts_provinggrounds00': 'ProvingGrounds_Trial0_P',
        '/game/gamedata/fasttravel/fts_provinggrounds01.fts_provinggrounds01': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/fts_provinggrounds01_droppod.fts_provinggrounds01_droppod': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/fts_provinggrounds01_oneway.fts_provinggrounds01_oneway': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/fts_provinggrounds02.fts_provinggrounds02': 'ProvingGrounds_Trial2_P',
        '/game/gamedata/fasttravel/fts_provinggrounds03.fts_provinggrounds03': 'ProvingGrounds_Trial3_P',
        '/game/gamedata/fasttravel/fts_provinggrounds04.fts_provinggrounds04': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/fts_provinggrounds04_droppod.fts_provinggrounds04_droppod': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/fts_provinggrounds04_oneway.fts_provinggrounds04_oneway': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/fts_provinggrounds05.fts_provinggrounds05': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/fts_provinggrounds05_droppod.fts_provinggrounds05_droppod': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/fts_provinggrounds05_oneway.fts_provinggrounds05_oneway': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/fts_provinggrounds06.fts_provinggrounds06': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/fts_provinggrounds06_droppod.fts_provinggrounds06_droppod': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/fts_provinggrounds06_oneway.fts_provinggrounds06_oneway': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/fts_provinggrounds07.fts_provinggrounds07': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/fts_provinggrounds07_droppod.fts_provinggrounds07_droppod': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/fts_provinggrounds07_oneway.fts_provinggrounds07_oneway': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/fts_provinggrounds08.fts_provinggrounds08': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/fts_provinggrounds08_droppod.fts_provinggrounds08_droppod': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/fts_provinggrounds08_oneway.fts_provinggrounds08_oneway': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/fts_raid.fts_raid': 'Raid_P',
        '/game/gamedata/fasttravel/fts_recruitment.fts_recruitment': 'Recruitment_P',
        '/game/gamedata/fasttravel/fts_sacrifice.fts_sacrifice': 'Sacrifice_P',
        '/game/gamedata/fasttravel/fts_sanctuary.fts_sanctuary': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/fts_sanctuarybridge.fts_sanctuarybridge': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/fts_techslaughter.fts_techslaughter': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/fts_techslaughterdroppod.fts_techslaughterdroppod': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/fts_towers.fts_towers': 'Towers_P',
        '/game/gamedata/fasttravel/fts_watership.fts_watership': 'Watership_P',
        '/game/gamedata/fasttravel/fts_watership_sendonly.fts_watership_sendonly': 'Watership_P',
        '/game/gamedata/fasttravel/fts_wetlands1.fts_wetlands1': 'Wetlands_P',
        '/game/gamedata/fasttravel/fts_wetlands2.fts_wetlands2': 'Wetlands_P',
        '/game/gamedata/fasttravel/fts_wetlandsboss.fts_wetlandsboss': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/fts_wetlandsboss_sendonly.fts_wetlandsboss_sendonly': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/fts_wetlandsdroppod.fts_wetlandsdroppod': 'Wetlands_P',
        '/game/gamedata/fasttravel/fts_wetlandsvault.fts_wetlandsvault': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/fts_zonemaptest.fts_zonemaptest': 'ZoneMap_Test_P',
        '/game/gamedata/fasttravel/fts_zonemaptest2.fts_zonemaptest2': 'ZoneMap_Test_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_atlashq_city.lts_atlashq_city': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_atlashqside_city.lts_atlashqside_city': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_beach_desolate.lts_beach_desolate': 'Beach_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_beach_vaultinterior.lts_beach_vaultinterior': 'Beach_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_atlashq.lts_city_atlashq': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_atlashqside.lts_city_atlashqside': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_cityvault.lts_city_cityvault': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_creatureslaughter.lts_city_creatureslaughter': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_orbitalplatform.lts_city_orbitalplatform': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_outskirts1.lts_city_outskirts1': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_outskirts2.lts_city_outskirts2': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_sanctuary3.lts_city_sanctuary3': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_city_towers.lts_city_towers': 'City_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_cityboss_cityvault.lts_cityboss_cityvault': 'CityBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_cityboss_vaultinterior.lts_cityboss_vaultinterior': 'CityBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_cityvault_city.lts_cityvault_city': 'CityVault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_cityvault_cityboss.lts_cityvault_cityboss': 'CityVault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_convoy_desert.lts_convoy_desert': 'Convoy_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_convoy_mine.lts_convoy_mine': 'Convoy_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_covslaughter_mine.lts_covslaughter_mine': 'COVSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_creatureslaughter_city.lts_creatureslaughter_city': 'CreatureSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_creatureslaughter_sanctuary3.lts_creatureslaughter_sanctuary3': 'CreatureSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_crypt_desolate.lts_crypt_desolate': 'Crypt_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_crypt_finalboss.lts_crypt_finalboss': 'Crypt_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert2_mine2.lts_desert2_mine2': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_convoy.lts_desert_convoy': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_desertvault.lts_desert_desertvault': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_grotto.lts_desert_grotto': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_mine.lts_desert_mine': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_motorcade.lts_desert_motorcade': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desert_prologue.lts_desert_prologue': 'Desert_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desertboss_desertvault.lts_desertboss_desertvault': 'DesertBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desertboss_vaultinterior.lts_desertboss_vaultinterior': 'DesertBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desertvault_desert.lts_desertvault_desert': 'Desertvault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desertvault_desertboss.lts_desertvault_desertboss': 'Desertvault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desolate_beach.lts_desolate_beach': 'Desolate_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desolate_crypt.lts_desolate_crypt': 'Desolate_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desolate_sanctuary3.lts_desolate_sanctuary3': 'Desolate_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_desolate_techslaughter.lts_desolate_techslaughter': 'Desolate_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_finalboss_crypt.lts_finalboss_crypt': 'FinalBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_finalboss_prologue.lts_finalboss_prologue': 'FinalBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_finalboss_vaultinterior.lts_finalboss_vaultinterior': 'FinalBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_grotto_desert.lts_grotto_desert': 'Grotto_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_grotto_sanctuary3.lts_grotto_sanctuary3': 'Grotto_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mansion_wetlands.lts_mansion_wetlands': 'Mansion_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_marshfields_wetlands.lts_marshfields_wetlands': 'MarshFields_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mine2_desert2.lts_mine2_desert2': 'Mine_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mine_convoy.lts_mine_convoy': 'Mine_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mine_covslaughter.lts_mine_covslaughter': 'Mine_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_mine_desert.lts_mine_desert': 'Mine_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_monastery_sanctuary3.lts_monastery_sanctuary3': 'Monastery_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcade_desert.lts_motorcade_desert': 'Motorcade_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcade_motorcadefestival.lts_motorcade_motorcadefestival': 'Motorcade_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcadefestival_motorcadeinterior.lts_motorcadefestival_motorcadeinterior': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcadefestival_motorcademain.lts_motorcadefestival_motorcademain': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_motorcadeinterior_motorcadefestival.lts_motorcadeinterior_motorcadefestival': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_orbitalplatform_city.lts_orbitalplatform_city': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_outskirts_city1.lts_outskirts_city1': 'Outskirts_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_outskirts_city2.lts_outskirts_city2': 'Outskirts_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prison_wetlands.lts_prison_wetlands': 'Prison_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_desert.lts_prologue_desert': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_finalboss.lts_prologue_finalboss': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_recruitment.lts_prologue_recruitment': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_sacrifice.lts_prologue_sacrifice': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_prologue_sanctuary3.lts_prologue_sanctuary3': 'Prologue_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground1_sanctuary3.lts_provingground1_sanctuary3': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground2_sanctuary3.lts_provingground2_sanctuary3': 'ProvingGrounds_Trial2_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground4_sanctuary3.lts_provingground4_sanctuary3': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground5_sanctuary3.lts_provingground5_sanctuary3': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground6_sanctuary3.lts_provingground6_sanctuary3': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground7_sanctuary3.lts_provingground7_sanctuary3': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_provingground8_sanctuary3.lts_provingground8_sanctuary3': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_recruitment_prologue.lts_recruitment_prologue': 'Recruitment_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sacrifice_prologue.lts_sacrifice_prologue': 'Sacrifice_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sactuary3_provingground1.lts_sactuary3_provingground1': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_creatureslaughter.lts_sanctuary3_creatureslaughter': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_desolate.lts_sanctuary3_desolate': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_grotto.lts_sanctuary3_grotto': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_monastery.lts_sanctuary3_monastery': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_outskirts.lts_sanctuary3_outskirts': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_prologue.lts_sanctuary3_prologue': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground2.lts_sanctuary3_provingground2': 'Monastery_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground4.lts_sanctuary3_provingground4': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground5.lts_sanctuary3_provingground5': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground6.lts_sanctuary3_provingground6': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground7.lts_sanctuary3_provingground7': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_provingground8.lts_sanctuary3_provingground8': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_techslaughter.lts_sanctuary3_techslaughter': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_sanctuary3_wetlands.lts_sanctuary3_wetlands': 'Sanctuary3_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_techslaughter_desolate.lts_techslaughter_desolate': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_techslaughter_sanctuary3.lts_techslaughter_sanctuary3': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_towers_city.lts_towers_city': 'Towers_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_beach.lts_vaultinterior_beach': 'Beach_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_cityboss.lts_vaultinterior_cityboss': 'CityBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_desertboss.lts_vaultinterior_desertboss': 'DesertBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_finalboss.lts_vaultinterior_finalboss': 'FinalBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_vaultinterior_wetlandsboss.lts_vaultinterior_wetlandsboss': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_watership_wetlands.lts_watership_wetlands': 'Watership_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_mansion.lts_wetlands_mansion': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_marshfields.lts_wetlands_marshfields': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_prison.lts_wetlands_prison': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_sanctuary3.lts_wetlands_sanctuary3': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_watership.lts_wetlands_watership': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlands_wetlandsvault.lts_wetlands_wetlandsvault': 'Wetlands_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlandsboss_vaultinterior.lts_wetlandsboss_vaultinterior': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlandsboss_wetlandsvault.lts_wetlandsboss_wetlandsvault': 'WetlandsBoss_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlandsvault_wetlands.lts_wetlandsvault_wetlands': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_wetlandsvault_wetlandsboss.lts_wetlandsvault_wetlandsboss': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_zonemaptest1_zonemaptest2.lts_zonemaptest1_zonemaptest2': 'ZoneMap_Test_P',
        '/game/gamedata/fasttravel/leveltravelstations/lts_zonemaptest2_zonemaptest1.lts_zonemaptest2_zonemaptest1': 'ZoneMap_Test_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_controlroom01.rts_atlashq_controlroom01': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_controlroom02.rts_atlashq_controlroom02': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_lounge.rts_atlashq_lounge': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_maintenance.rts_atlashq_maintenance': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/atlashq/rts_atlashq_office.rts_atlashq_office': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_controlroomone.rts_atlashq_courtyard_dynamic_checkpoint_controlroomone': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_controlroomtwo.rts_atlashq_courtyard_dynamic_checkpoint_controlroomtwo': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_lounge.rts_atlashq_courtyard_dynamic_checkpoint_lounge': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_maintenance.rts_atlashq_courtyard_dynamic_checkpoint_maintenance': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_courtyard_dynamic_checkpoint_office.rts_atlashq_courtyard_dynamic_checkpoint_office': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_labs_2.rts_atlashq_labs_2': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_atlashq_p_2.rts_atlashq_p_2': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_controlroomone.rts_autogen_checkpoint_controlroomone': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_controlroomtwo.rts_autogen_checkpoint_controlroomtwo': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_lounge.rts_autogen_checkpoint_lounge': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_maintenance.rts_autogen_checkpoint_maintenance': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_checkpoint_office.rts_autogen_checkpoint_office': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/atlashq/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'AtlasHQ_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_159.rts_autogen_resurrecttravelstationobject_159': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_5.rts_autogen_resurrecttravelstationobject_5': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_6.rts_autogen_resurrecttravelstationobject_6': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_autogen_resurrecttravelstationobject_7.rts_autogen_resurrecttravelstationobject_7': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_2.rts_beach_p_2': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_3.rts_beach_p_3': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_5.rts_beach_p_5': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_6.rts_beach_p_6': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_p_7.rts_beach_p_7': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/beach/rts_beach_plot_m_159.rts_beach_plot_m_159': 'Beach_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_1.rts_autogen_resurrecttravelstationobject_1': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_34437.rts_autogen_resurrecttravelstationobject_34437': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_36177.rts_autogen_resurrecttravelstationobject_36177': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_38715.rts_autogen_resurrecttravelstationobject_38715': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_44109.rts_autogen_resurrecttravelstationobject_44109': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_autogen_resurrecttravelstationobject_49115.rts_autogen_resurrecttravelstationobject_49115': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_boss_gigamind_38715.rts_city_boss_gigamind_38715': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_0.rts_city_dynamic_0': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_1.rts_city_dynamic_1': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_2.rts_city_dynamic_2': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_34437.rts_city_dynamic_34437': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_36177.rts_city_dynamic_36177': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_38715.rts_city_dynamic_38715': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_44109.rts_city_dynamic_44109': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_dynamic_49115.rts_city_dynamic_49115': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/city/rts_city_hub_49115.rts_city_hub_49115': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_14.rts_autogen_resurrecttravelstationobject_14': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_28.rts_autogen_resurrecttravelstationobject_28': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_afterdriving.rts_autogen_resurrecttravelstationobject_afterdriving': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_chkpt.rts_autogen_resurrecttravelstationobject_chkpt': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_chkpt_0.rts_autogen_resurrecttravelstationobject_chkpt_0': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_chkpt_1.rts_autogen_resurrecttravelstationobject_chkpt_1': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_autogen_resurrecttravelstationobject_chkpt_2.rts_autogen_resurrecttravelstationobject_chkpt_2': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_0.rts_cityvault_m_laststop_0': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_28.rts_cityvault_m_laststop_28': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_afterdriving.rts_cityvault_m_laststop_afterdriving': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_chkpt.rts_cityvault_m_laststop_chkpt': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_chkpt_0.rts_cityvault_m_laststop_chkpt_0': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_chkpt_1.rts_cityvault_m_laststop_chkpt_1': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_chkpt_2.rts_cityvault_m_laststop_chkpt_2': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/cityvault/rts_cityvault_m_laststop_resurrecttravelstationobject.rts_cityvault_m_laststop_resurrecttravelstationobject': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation.rts_autogen_resurrecttravelstation': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation_31032.rts_autogen_resurrecttravelstation_31032': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation_36.rts_autogen_resurrecttravelstation_36': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation_37.rts_autogen_resurrecttravelstation_37': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_autogen_resurrecttravelstation_54.rts_autogen_resurrecttravelstation_54': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation.rts_convoy_p_resurrecttravelstation': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation_31032.rts_convoy_p_resurrecttravelstation_31032': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation_36.rts_convoy_p_resurrecttravelstation_36': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation_37.rts_convoy_p_resurrecttravelstation_37': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/convoy/rts_convoy_p_resurrecttravelstation_54.rts_convoy_p_resurrecttravelstation_54': 'Convoy_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/creatureslaughter/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'CreatureSlaughter_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_autogen_resurrecttravelstationobject3.rts_autogen_resurrecttravelstationobject3': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_autogen_resurrecttravelstationobject4.rts_autogen_resurrecttravelstationobject4': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_crypt_p_0.rts_crypt_p_0': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_crypt_p_resurrecttravelstationobject.rts_crypt_p_resurrecttravelstationobject': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_crypt_p_resurrecttravelstationobject3.rts_crypt_p_resurrecttravelstationobject3': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/crypt/rts_crypt_p_resurrecttravelstationobject4.rts_crypt_p_resurrecttravelstationobject4': 'Crypt_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject11.rts_autogen_resurrecttravelstationobject11': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_84.rts_autogen_resurrecttravelstationobject_84': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_85.rts_autogen_resurrecttravelstationobject_85': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_86.rts_autogen_resurrecttravelstationobject_86': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_87.rts_autogen_resurrecttravelstationobject_87': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_autogen_resurrecttravelstationobject_89.rts_autogen_resurrecttravelstationobject_89': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_84.rts_desert_p_84': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_85.rts_desert_p_85': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_86.rts_desert_p_86': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_87.rts_desert_p_87': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_p_89.rts_desert_p_89': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_poi_babydancer_84.rts_desert_poi_babydancer_84': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desert/rts_desert_poi_echonet_resurrecttravelstationobject11.rts_desert_poi_echonet_resurrecttravelstationobject11': 'Desert_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desertvault/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Desertvault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desertvault/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Desertvault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_13.rts_autogen_resurrecttravelstationobject_13': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_14.rts_autogen_resurrecttravelstationobject_14': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_4.rts_autogen_resurrecttravelstationobject_4': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_5.rts_autogen_resurrecttravelstationobject_5': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_6.rts_autogen_resurrecttravelstationobject_6': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_7.rts_autogen_resurrecttravelstationobject_7': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_8.rts_autogen_resurrecttravelstationobject_8': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_autogen_resurrecttravelstationobject_9.rts_autogen_resurrecttravelstationobject_9': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_asylum.rts_desolate_gameplay_asylum': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_beforerepaircamp.rts_desolate_gameplay_beforerepaircamp': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_beforetrauntarena.rts_desolate_gameplay_beforetrauntarena': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_eastmarsh.rts_desolate_gameplay_eastmarsh': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_finaleentrance.rts_desolate_gameplay_finaleentrance': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_maliwancampentrance.rts_desolate_gameplay_maliwancampentrance': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_maliwancampexit.rts_desolate_gameplay_maliwancampexit': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_northswampentrance.rts_desolate_gameplay_northswampentrance': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_northtemplebelow.rts_desolate_gameplay_northtemplebelow': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_northtempleentrance.rts_desolate_gameplay_northtempleentrance': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/desolate/rts_desolate_gameplay_typhoncampoutside.rts_desolate_gameplay_typhoncampoutside': 'Desolate_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/finalboss/rts_autogen_resurrecttravelstationobject_5082.rts_autogen_resurrecttravelstationobject_5082': 'FinalBoss_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject_1404.rts_autogen_resurrecttravelstationobject_1404': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject_18.rts_autogen_resurrecttravelstationobject_18': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_autogen_resurrecttravelstationobject_48.rts_autogen_resurrecttravelstationobject_48': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_dynamic_48.rts_mansion_dynamic_48': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_0.rts_mansion_exterior_0': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_1.rts_mansion_exterior_1': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_1404.rts_mansion_exterior_1404': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_18.rts_mansion_exterior_18': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_exterior_48.rts_mansion_exterior_48': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mansion/rts_mansion_theater_resurrecttravelstationobject.rts_mansion_theater_resurrecttravelstationobject': 'Mansion_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_54.rts_autogen_resurrecttravelstationobject_54': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_72.rts_autogen_resurrecttravelstationobject_72': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_90.rts_autogen_resurrecttravelstationobject_90': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/marshfields/rts_autogen_resurrecttravelstationobject_956.rts_autogen_resurrecttravelstationobject_956': 'MarshFields_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_28.rts_autogen_resurrecttravelstationobject_28': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_29.rts_autogen_resurrecttravelstationobject_29': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_36.rts_autogen_resurrecttravelstationobject_36': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_autogen_resurrecttravelstationobject_54.rts_autogen_resurrecttravelstationobject_54': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_m_bridgeinthedark_0.rts_mine_m_bridgeinthedark_0': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_p_0.rts_mine_p_0': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_p_28.rts_mine_p_28': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_p_29.rts_mine_p_29': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_p_54.rts_mine_p_54': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/mine/rts_mine_section2_lobby_36.rts_mine_section2_lobby_36': 'Mine_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject10.rts_autogen_resurrecttravelstationobject10': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject9.rts_autogen_resurrecttravelstationobject9': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject_240.rts_autogen_resurrecttravelstationobject_240': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject_84.rts_autogen_resurrecttravelstationobject_84': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/monastery/rts_autogen_resurrecttravelstationobject_87.rts_autogen_resurrecttravelstationobject_87': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_chopchop.rts_autogen_resurrecttravelstationobject_chopchop': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_desert.rts_autogen_resurrecttravelstationobject_desert': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_greaseland_4071.rts_autogen_resurrecttravelstationobject_greaseland_4071': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_homestead.rts_autogen_resurrecttravelstationobject_homestead': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_homestead_16407.rts_autogen_resurrecttravelstationobject_homestead_16407': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_orphanage.rts_autogen_resurrecttravelstationobject_orphanage': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_radiostation.rts_autogen_resurrecttravelstationobject_radiostation': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_ravecave.rts_autogen_resurrecttravelstationobject_ravecave': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_rollercoaster.rts_autogen_resurrecttravelstationobject_rollercoaster': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcade/rts_autogen_resurrecttravelstationobject_spiderantcave.rts_autogen_resurrecttravelstationobject_spiderantcave': 'Motorcade_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadefestival/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadefestival/rts_autogen_resurrecttravelstationobject_3245.rts_autogen_resurrecttravelstationobject_3245': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadefestival/rts_autogen_resurrecttravelstationobject_668.rts_autogen_resurrecttravelstationobject_668': 'MotorcadeFestival_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_autogen_resurrecttravelstationobject5.rts_autogen_resurrecttravelstationobject5': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_autogen_resurrecttravelstationobject_42.rts_autogen_resurrecttravelstationobject_42': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_autogen_resurrecttravelstationobject_43.rts_autogen_resurrecttravelstationobject_43': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_autogen_resurrecttravelstationobject_44.rts_autogen_resurrecttravelstationobject_44': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_motorcadeinterior_catwalks_resurrecttravelstationobject5.rts_motorcadeinterior_catwalks_resurrecttravelstationobject5': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_motorcadeinterior_engine_43.rts_motorcadeinterior_engine_43': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_motorcadeinterior_plot_44.rts_motorcadeinterior_plot_44': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/motorcadeinterior/rts_motorcadeinterior_top_42.rts_motorcadeinterior_top_42': 'MotorcadeInterior_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_1.rts_autogen_resurrecttravelstationobject_1': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_28.rts_autogen_resurrecttravelstationobject_28': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_4.rts_autogen_resurrecttravelstationobject_4': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_autogen_resurrecttravelstationobject_5.rts_autogen_resurrecttravelstationobject_5': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_0.rts_orbitalplatform_combat_0': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_1.rts_orbitalplatform_combat_1': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_2.rts_orbitalplatform_combat_2': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_28.rts_orbitalplatform_combat_28': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_3.rts_orbitalplatform_combat_3': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_4.rts_orbitalplatform_combat_4': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_combat_5.rts_orbitalplatform_combat_5': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_m_oppresearch_2.rts_orbitalplatform_m_oppresearch_2': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/orbitalplatform/rts_orbitalplatform_mission_0.rts_orbitalplatform_mission_0': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/outskirts/rts_autogen_resurrecttravelstationobject_14447.rts_autogen_resurrecttravelstationobject_14447': 'Outskirts_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/outskirts/rts_autogen_resurrecttravelstationobject_16242.rts_autogen_resurrecttravelstationobject_16242': 'Outskirts_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/outskirts/rts_autogen_resurrecttravelstationobject_19620.rts_autogen_resurrecttravelstationobject_19620': 'Outskirts_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/outskirts/rts_autogen_resurrecttravelstationobject_786.rts_autogen_resurrecttravelstationobject_786': 'Outskirts_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_1243.rts_autogen_resurrecttravelstationobject_1243': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_2268.rts_autogen_resurrecttravelstationobject_2268': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_3114.rts_autogen_resurrecttravelstationobject_3114': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_3242.rts_autogen_resurrecttravelstationobject_3242': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_3964.rts_autogen_resurrecttravelstationobject_3964': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_594.rts_autogen_resurrecttravelstationobject_594': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_6231.rts_autogen_resurrecttravelstationobject_6231': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_648.rts_autogen_resurrecttravelstationobject_648': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_74.rts_autogen_resurrecttravelstationobject_74': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_8752.rts_autogen_resurrecttravelstationobject_8752': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prison/rts_autogen_resurrecttravelstationobject_884.rts_autogen_resurrecttravelstationobject_884': 'Prison_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_12.rts_autogen_resurrecttravelstationobject_12': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_13.rts_autogen_resurrecttravelstationobject_13': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_2220.rts_autogen_resurrecttravelstationobject_2220': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_2846.rts_autogen_resurrecttravelstationobject_2846': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_3.rts_autogen_resurrecttravelstationobject_3': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_5.rts_autogen_resurrecttravelstationobject_5': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_6.rts_autogen_resurrecttravelstationobject_6': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_8159.rts_autogen_resurrecttravelstationobject_8159': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_autogen_resurrecttravelstationobject_pastbarricade.rts_autogen_resurrecttravelstationobject_pastbarricade': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_combat_2.rts_prologue_combat_2': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_combat_6.rts_prologue_combat_6': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_0.rts_prologue_dynamic_0': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_12.rts_prologue_dynamic_12': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_13.rts_prologue_dynamic_13': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_2.rts_prologue_dynamic_2': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_2220.rts_prologue_dynamic_2220': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_2846.rts_prologue_dynamic_2846': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_3.rts_prologue_dynamic_3': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_5.rts_prologue_dynamic_5': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_6.rts_prologue_dynamic_6': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_8159.rts_prologue_dynamic_8159': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/prologue/rts_prologue_dynamic_pastbarricade.rts_prologue_dynamic_pastbarricade': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial1/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial1/rts_autogen_resurrecttravelstationobject_180.rts_autogen_resurrecttravelstationobject_180': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial1/rts_autogen_resurrecttravelstationobject_730.rts_autogen_resurrecttravelstationobject_730': 'ProvingGrounds_Trial1_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial4/rts_autogen_resurrecttravelstationobject_1896.rts_autogen_resurrecttravelstationobject_1896': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial4/rts_autogen_resurrecttravelstationobject_3373.rts_autogen_resurrecttravelstationobject_3373': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial4/rts_autogen_resurrecttravelstationobject_3614.rts_autogen_resurrecttravelstationobject_3614': 'ProvingGrounds_Trial4_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial5/rts_autogen_resurrecttravelstationobject_13277.rts_autogen_resurrecttravelstationobject_13277': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial5/rts_autogen_resurrecttravelstationobject_3614.rts_autogen_resurrecttravelstationobject_3614': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial5/rts_autogen_resurrecttravelstationobject_3962.rts_autogen_resurrecttravelstationobject_3962': 'ProvingGrounds_Trial5_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial6/rts_autogen_resurrecttravelstationobject_0.rts_autogen_resurrecttravelstationobject_0': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial6/rts_autogen_resurrecttravelstationobject_1502.rts_autogen_resurrecttravelstationobject_1502': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial6/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'ProvingGrounds_Trial6_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial7/rts_autogen_resurrecttravelstationobject_afterencounter.rts_autogen_resurrecttravelstationobject_afterencounter': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial7/rts_autogen_resurrecttravelstationobject_afterencounter_7403.rts_autogen_resurrecttravelstationobject_afterencounter_7403': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial7/rts_autogen_resurrecttravelstationobject_afterencounter_7440.rts_autogen_resurrecttravelstationobject_afterencounter_7440': 'ProvingGrounds_Trial7_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial8/rts_autogen_resurrecttravelstationobject_afterencounter.rts_autogen_resurrecttravelstationobject_afterencounter': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial8/rts_autogen_resurrecttravelstationobject_afterencounter_1801.rts_autogen_resurrecttravelstationobject_afterencounter_1801': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/provinggrounds_trial8/rts_autogen_resurrecttravelstationobject_afterencounter_24.rts_autogen_resurrecttravelstationobject_afterencounter_24': 'ProvingGrounds_Trial8_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/recruitment/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Recruitment_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/recruitment/rts_autogen_resurrecttravelstationobject_covcamp.rts_autogen_resurrecttravelstationobject_covcamp': 'Recruitment_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_13.rts_autogen_resurrecttravelstationobject_13': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_16.rts_autogen_resurrecttravelstationobject_16': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_2828.rts_autogen_resurrecttravelstationobject_2828': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_6.rts_autogen_resurrecttravelstationobject_6': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/sacrifice/rts_autogen_resurrecttravelstationobject_7547.rts_autogen_resurrecttravelstationobject_7547': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/techslaughter/rts_autogen_resurrecttravelstationobject_2.rts_autogen_resurrecttravelstationobject_2': 'TechSlaughter_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_1136.rts_autogen_resurrecttravelstationobject_1136': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_14.rts_autogen_resurrecttravelstationobject_14': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_660.rts_autogen_resurrecttravelstationobject_660': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_772.rts_autogen_resurrecttravelstationobject_772': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_84.rts_autogen_resurrecttravelstationobject_84': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_85.rts_autogen_resurrecttravelstationobject_85': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_86.rts_autogen_resurrecttravelstationobject_86': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/towers/rts_autogen_resurrecttravelstationobject_87.rts_autogen_resurrecttravelstationobject_87': 'Towers_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject.rts_autogen_resurrecttravelstationobject': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject4.rts_autogen_resurrecttravelstationobject4': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject8.rts_autogen_resurrecttravelstationobject8': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject9.rts_autogen_resurrecttravelstationobject9': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject_18.rts_autogen_resurrecttravelstationobject_18': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject_4123.rts_autogen_resurrecttravelstationobject_4123': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_autogen_resurrecttravelstationobject_6904.rts_autogen_resurrecttravelstationobject_6904': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_combat_resurrecttravelstationobject.rts_watership_combat_resurrecttravelstationobject': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_leadup_geo_6904.rts_watership_leadup_geo_6904': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_mission_0.rts_watership_mission_0': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_mission_1.rts_watership_mission_1': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_mission_resurrecttravelstationobject.rts_watership_mission_resurrecttravelstationobject': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_p_resurrecttravelstationobject4.rts_watership_p_resurrecttravelstationobject4': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_p_resurrecttravelstationobject8.rts_watership_p_resurrecttravelstationobject8': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_sidemission_0.rts_watership_sidemission_0': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_sidemission_4123.rts_watership_sidemission_4123': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/watership/rts_watership_sidemission_resurrecttravelstationobject.rts_watership_sidemission_resurrecttravelstationobject': 'Watership_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_1046.rts_autogen_resurrecttravelstationobject_1046': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_1190.rts_autogen_resurrecttravelstationobject_1190': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_36.rts_autogen_resurrecttravelstationobject_36': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_4761.rts_autogen_resurrecttravelstationobject_4761': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_4791.rts_autogen_resurrecttravelstationobject_4791': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_48.rts_autogen_resurrecttravelstationobject_48': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_5977.rts_autogen_resurrecttravelstationobject_5977': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_7157.rts_autogen_resurrecttravelstationobject_7157': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_9177.rts_autogen_resurrecttravelstationobject_9177': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_autogen_resurrecttravelstationobject_920.rts_autogen_resurrecttravelstationobject_920': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_1046.rts_wetlands_combat_1046': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_1190.rts_wetlands_combat_1190': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_36.rts_wetlands_combat_36': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_4761.rts_wetlands_combat_4761': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_4791.rts_wetlands_combat_4791': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_48.rts_wetlands_combat_48': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_5977.rts_wetlands_combat_5977': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_7157.rts_wetlands_combat_7157': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_9177.rts_wetlands_combat_9177': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlands/rts_wetlands_combat_920.rts_wetlands_combat_920': 'Wetlands_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_autogen_resurrecttravelstationobject_108.rts_autogen_resurrecttravelstationobject_108': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_autogen_resurrecttravelstationobject_144.rts_autogen_resurrecttravelstationobject_144': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_autogen_resurrecttravelstationobject_54.rts_autogen_resurrecttravelstationobject_54': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_wetlandsvault_combat_144.rts_wetlandsvault_combat_144': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_wetlandsvault_p_108.rts_wetlandsvault_p_108': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_wetlandsvault_p_144.rts_wetlandsvault_p_144': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/autogen/wetlandsvault/rts_wetlandsvault_p_54.rts_wetlandsvault_p_54': 'WetlandsVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_airport.rts_city_airport': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_atlashqgates.rts_city_atlashqgates': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_cvgate.rts_city_cvgate': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_maintexit.rts_city_maintexit': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/city/rts_city_mallentrance.rts_city_mallentrance': 'City_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_cave.rts_cityvault_cave': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_phonebank.rts_cityvault_phonebank': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_stationentrance.rts_cityvault_stationentrance': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_vehiclepit1.rts_cityvault_vehiclepit1': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/cityvault/rts_cityvault_vehiclepit2.rts_cityvault_vehiclepit2': 'CityVault_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/monastery/rts_monastery_bosscourtyard.rts_monastery_bosscourtyard': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/monastery/rts_monastery_bridge.rts_monastery_bridge': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/monastery/rts_monastery_cemetery.rts_monastery_cemetery': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/monastery/rts_monastery_cliffpath.rts_monastery_cliffpath': 'Monastery_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_ballpit.rts_orbitalplatform_ballpit': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_cargobay.rts_orbitalplatform_cargobay': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_commandcenter.rts_orbitalplatform_commandcenter': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_maintenance.rts_orbitalplatform_maintenance': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/orbital/rts_orbitalplatform_thruster.rts_orbitalplatform_thruster': 'OrbitalPlatform_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_desertgate.rts_prologue_desertgate': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_ellies.rts_prologue_ellies': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_gatecamp.rts_prologue_gatecamp': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_launchpad.rts_prologue_launchpad': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_lilithbase.rts_prologue_lilithbase': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_navcamp.rts_prologue_navcamp': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_sacrificegate.rts_prologue_sacrificegate': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/prologue/rts_prologue_vehiclecamp.rts_prologue_vehiclecamp': 'Prologue_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/recruitment/rts_recruitment_entrance.rts_recruitment_entrance': 'Recruitment_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/sacrifice/rts_sacrifice_holybroadgate.rts_sacrifice_holybroadgate': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/sacrifice/rts_sacrifice_holybroadlobby.rts_sacrifice_holybroadlobby': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/sacrifice/rts_sacrifice_mouthpiece.rts_sacrifice_mouthpiece': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/sacrifice/rts_sacrifice_prologuegate.rts_sacrifice_prologuegate': 'Sacrifice_P',
        '/game/gamedata/fasttravel/resurrecttravelstations/wetlands/rts_wetlands_mansion.rts_wetlands_mansion': 'Wetlands_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_anger.fts_ali_anger': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_anger_boss.fts_ali_anger_boss': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_anger_castle.fts_ali_anger_castle': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_chase.fts_ali_chase': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_chase_boss.fts_ali_chase_boss': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_eldorado.fts_ali_eldorado': 'Eldorado_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_eldorado_boss.fts_ali_eldorado_boss': 'Eldorado_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_experiment.fts_ali_experiment': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_experiment_boss.fts_ali_experiment_boss': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_sanctum.fts_ali_sanctum': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/fts_ali_sanctum_droppod.fts_ali_sanctum_droppod': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_anger_sanctum.lts_ali_anger_sanctum': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_anger_whitedoor_back.lts_ali_anger_whitedoor_back': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_anger_whitedoor_in.lts_ali_anger_whitedoor_in': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_angerboss_sanctum.lts_ali_angerboss_sanctum': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_chase_sanctum.lts_ali_chase_sanctum': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_chase_whitedoor_back.lts_ali_chase_whitedoor_back': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_chase_whitedoor_in.lts_ali_chase_whitedoor_in': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_chaseboss_sanctum.lts_ali_chaseboss_sanctum': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_eldorado_sanctum.lts_ali_eldorado_sanctum': 'Eldorado_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_eldorado_whitedoor_back.lts_ali_eldorado_whitedoor_back': 'Eldorado_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_eldorado_whitedoor_in.lts_ali_eldorado_whitedoor_in': 'Eldorado_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_eldoradoboss_sanctum.lts_ali_eldoradoboss_sanctum': 'Eldorado_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_experiment_sanctum.lts_ali_experiment_sanctum': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_experiment_whitedoor_back.lts_ali_experiment_whitedoor_back': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_experiment_whitedoor_in.lts_ali_experiment_whitedoor_in': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_experimentboss_sanctum.lts_ali_experimentboss_sanctum': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_sanctum_anger.lts_ali_sanctum_anger': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_sanctum_angerboss_unusable.lts_ali_sanctum_angerboss_unusable': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_sanctum_chase.lts_ali_sanctum_chase': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_sanctum_chaseboss_unusable.lts_ali_sanctum_chaseboss_unusable': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_sanctum_eldorado.lts_ali_sanctum_eldorado': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_sanctum_eldoradoboss_unusable.lts_ali_sanctum_eldoradoboss_unusable': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_sanctum_experiment.lts_ali_sanctum_experiment': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_sanctum_experimentboss_unusable.lts_ali_sanctum_experimentboss_unusable': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_whitedoor_back.lts_ali_whitedoor_back': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/leveltravelstations/lts_ali_whitedoor_in.lts_ali_whitedoor_in': 'Sanctum_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/patchedleveltraveldata/lts_sanctuary3_ali.lts_sanctuary3_ali': 'Sanctuary3_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__ascen.rts_anger_travel_rs__ascen': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__gate.rts_anger_travel_rs__gate': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__main.rts_anger_travel_rs__main': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__meata.rts_anger_travel_rs__meata': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__meatb.rts_anger_travel_rs__meatb': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__outposta.rts_anger_travel_rs__outposta': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__outpostb.rts_anger_travel_rs__outpostb': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__outpostc.rts_anger_travel_rs__outpostc': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__side.rts_anger_travel_rs__side': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__skag.rts_anger_travel_rs__skag': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/anger/rts_anger_travel_rs__stronghold.rts_anger_travel_rs__stronghold': 'Anger_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__anoa.rts_chase_travel_rs__anoa': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__anob.rts_chase_travel_rs__anob': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__bridgea.rts_chase_travel_rs__bridgea': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__bridgeb.rts_chase_travel_rs__bridgeb': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__chess.rts_chase_travel_rs__chess': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__lair.rts_chase_travel_rs__lair': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__minea.rts_chase_travel_rs__minea': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__mineb.rts_chase_travel_rs__mineb': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__minec.rts_chase_travel_rs__minec': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__stationa.rts_chase_travel_rs__stationa': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/chase/rts_chase_travel_rs__stationb.rts_chase_travel_rs__stationb': 'Chase_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/eldorado/rts_eldorado_travel_rs__drop.rts_eldorado_travel_rs__drop': 'Eldorado_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/eldorado/rts_eldorado_travel_rs__loot.rts_eldorado_travel_rs__loot': 'Eldorado_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rs__boss.rts_experiment_travel_rs__boss': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rs__courta.rts_experiment_travel_rs__courta': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rs__courtb.rts_experiment_travel_rs__courtb': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rs__lab.rts_experiment_travel_rs__lab': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rs__land.rts_experiment_travel_rs__land': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rs__pipe.rts_experiment_travel_rs__pipe': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rs__secret.rts_experiment_travel_rs__secret': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rs__twist.rts_experiment_travel_rs__twist': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rt__lane.rts_experiment_travel_rt__lane': 'Experiment_P',
        '/game/patchdlc/alisma/gamedata/fasttravel/resurrecttravelstations/autogen/experiment/rts_experiment_travel_rt__ward.rts_experiment_travel_rt__ward': 'Experiment_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/fts_bloodyharvest.fts_bloodyharvest': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/lts_bloodyharvest_exit_sanctuary3.lts_bloodyharvest_exit_sanctuary3': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/lts_bloodyharvest_sanctuary3.lts_bloodyharvest_sanctuary3': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/lts_sanctuary3_bloodyharvest.lts_sanctuary3_bloodyharvest': 'Sanctuary3_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/leveltraveldata/lts_sanctuary3_bloodyharvest_exit.lts_sanctuary3_bloodyharvest_exit': 'Sanctuary3_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/resurrecttravelstations/autogen/bloodyharvest/rts_bloodyharvest_boss_2.rts_bloodyharvest_boss_2': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/resurrecttravelstations/autogen/bloodyharvest/rts_bloodyharvest_combat_0.rts_bloodyharvest_combat_0': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/resurrecttravelstations/autogen/bloodyharvest/rts_bloodyharvest_combat_2.rts_bloodyharvest_combat_2': 'BloodyHarvest_P',
        '/game/patchdlc/bloodyharvest/gamedata/fasttravel/resurrecttravelstations/autogen/bloodyharvest/rts_bloodyharvest_p_2.rts_bloodyharvest_p_2': 'BloodyHarvest_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_casinointro_dlc1_pod.fts_casinointro_dlc1_pod': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_core_dlc1.fts_core_dlc1': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_core_dlc1_boss.fts_core_dlc1_boss': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_impound_dlc1.fts_impound_dlc1': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_impound_dlc1_exit.fts_impound_dlc1_exit': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_impound_dlc1_lowgrav.fts_impound_dlc1_lowgrav': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_entrance.fts_strip_dlc1_entrance': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_hideout.fts_strip_dlc1_hideout': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_market.fts_strip_dlc1_market': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_tricksynickarea.fts_strip_dlc1_tricksynickarea': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_strip_dlc1_vice.fts_strip_dlc1_vice': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_towerlair_dlc1_lobby.fts_towerlair_dlc1_lobby': 'TowerLair_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_towerlair_dlc1_scrooge.fts_towerlair_dlc1_scrooge': 'TowerLair_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_trashtown_dlc1.fts_trashtown_dlc1': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/fts_trashtown_dlc1_town.fts_trashtown_dlc1_town': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_casinointro_strip.lts_casinointro_strip': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_core_strip.lts_core_strip': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_impound_strip.lts_impound_strip': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_casinointro.lts_strip_casinointro': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_core.lts_strip_core': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_impound.lts_strip_impound': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_towerlair.lts_strip_towerlair': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_strip_trashtown.lts_strip_trashtown': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_towerlair_strip.lts_towerlair_strip': 'TowerLair_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/leveltravelstations/lts_trashtown_strip.lts_trashtown_strip': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/lts_sanctuary3_dlc1.lts_sanctuary3_dlc1': 'Sanctuary3_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_011.rts_casino_travel_011': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_211.rts_casino_travel_211': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_311.rts_casino_travel_311': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_611.rts_casino_travel_611': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/casinointro/rts_casino_travel_711.rts_casino_travel_711': 'CasinoIntro_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_00.rts_core_travel_00': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_01.rts_core_travel_01': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_02.rts_core_travel_02': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_03.rts_core_travel_03': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_04.rts_core_travel_04': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_05.rts_core_travel_05': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_06.rts_core_travel_06': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_07.rts_core_travel_07': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/core/rts_core_travel_10.rts_core_travel_10': 'Core_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_01.rts_impound_travel_01': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_02.rts_impound_travel_02': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_03.rts_impound_travel_03': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_04.rts_impound_travel_04': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_05.rts_impound_travel_05': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_06.rts_impound_travel_06': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_08.rts_impound_travel_08': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/impound/rts_impound_travel_09.rts_impound_travel_09': 'Impound_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_compound.rts_strip_travel_resurrecttravel_compound': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_deathtowers.rts_strip_travel_resurrecttravel_deathtowers': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_fightpit.rts_strip_travel_resurrecttravel_fightpit': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_market.rts_strip_travel_resurrecttravel_market': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_spa.rts_strip_travel_resurrecttravel_spa': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_square.rts_strip_travel_resurrecttravel_square': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/strip/rts_strip_travel_resurrecttravel_suit.rts_strip_travel_resurrecttravel_suit': 'Strip_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/towerlair/rts_towerlair_travel_1.rts_towerlair_travel_1': 'TowerLair_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_2.rts_trashtown_travel_2': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_3.rts_trashtown_travel_3': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_claptrapcave.rts_trashtown_travel_claptrapcave': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_claptraptoescort.rts_trashtown_travel_claptraptoescort': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_escortstart.rts_trashtown_travel_escortstart': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_outsidetrashtown.rts_trashtown_travel_outsidetrashtown': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_pretrashtown.rts_trashtown_travel_pretrashtown': 'Trashtown_P',
        '/game/patchdlc/dandelion/gamedata/fasttravel/resurrecttravelstations/autogen/trashtown/rts_trashtown_travel_underbeam.rts_trashtown_travel_underbeam': 'Trashtown_P',
        '/game/patchdlc/event2/gamedata/fasttravel/leveltraveldata/fts_cartelhideout.fts_cartelhideout': 'Cartels_P',
        '/game/patchdlc/event2/gamedata/fasttravel/leveltraveldata/lts_cartelhideout_exit_sanct.lts_cartelhideout_exit_sanct': 'Cartels_P',
        '/game/patchdlc/event2/gamedata/fasttravel/leveltraveldata/lts_cartelhideout_sanct3.lts_cartelhideout_sanct3': 'Cartels_P',
        '/game/patchdlc/event2/gamedata/fasttravel/leveltraveldata/lts_sanct3_cartelhideout.lts_sanct3_cartelhideout': 'Sanctuary3_P',
        '/game/patchdlc/event2/gamedata/fasttravel/leveltraveldata/lts_sanct3_cartelhideout_exit.lts_sanct3_cartelhideout_exit': 'Sanctuary3_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_craterboss_dlc3.fts_craterboss_dlc3': 'CraterBoss_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_craterboss_dlc3_boss.fts_craterboss_dlc3_boss': 'CraterBoss_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_facility_dlc3.fts_facility_dlc3': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_facility_dlc3_mid.fts_facility_dlc3_mid': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_facility_dlc3_sendonly.fts_facility_dlc3_sendonly': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_forest_dlc3.fts_forest_dlc3': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_forest_dlc3_mid.fts_forest_dlc3_mid': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_frontier_dlc3_fort.fts_frontier_dlc3_fort': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_frontier_dlc3_garage.fts_frontier_dlc3_garage': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_frontier_dlc3_gasstation.fts_frontier_dlc3_gasstation': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_lodge_dlc3.fts_lodge_dlc3': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_lodge_dlc3_boss.fts_lodge_dlc3_boss': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_lodge_dlc3_mid.fts_lodge_dlc3_mid': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_town_dlc3.fts_town_dlc3': 'Town_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/fts_town_dlc3_pod.fts_town_dlc3_pod': 'Town_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_craterboss_frontier.lts_craterboss_frontier': 'CraterBoss_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_facility_frontier.lts_facility_frontier': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_forest_frontier.lts_forest_frontier': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_frontier_craterboss.lts_frontier_craterboss': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_frontier_facility.lts_frontier_facility': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_frontier_forest.lts_frontier_forest': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_frontier_lodge.lts_frontier_lodge': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_frontier_town.lts_frontier_town': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_lodge_frontier.lts_lodge_frontier': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/leveltravelstations/lts_town_frontier.lts_town_frontier': 'Town_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/lts_sanctuary3_dlc3.lts_sanctuary3_dlc3': 'Sanctuary3_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/craterboss/rts_craterboss_01_entrance.rts_craterboss_01_entrance': 'CraterBoss_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/craterboss/rts_craterboss_02_boss.rts_craterboss_02_boss': 'CraterBoss_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_01_bridge.rts_facility_01_bridge': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_02_meatman.rts_facility_02_meatman': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_03_meatman_02.rts_facility_03_meatman_02': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_04_entrance.rts_facility_04_entrance': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_05_lobby.rts_facility_05_lobby': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_06_elevator.rts_facility_06_elevator': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_07_train.rts_facility_07_train': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_08_lovebarsnone.rts_facility_08_lovebarsnone': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_09_lovebarsnone_02.rts_facility_09_lovebarsnone_02': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_10_lovebarsnone_03.rts_facility_10_lovebarsnone_03': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_11_revolver.rts_facility_11_revolver': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_12_rosebridge.rts_facility_12_rosebridge': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_13_tunnel.rts_facility_13_tunnel': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/facility/rts_facility_14_boss.rts_facility_14_boss': 'Facility_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/forest/rts_forest_01_grannyreveal.rts_forest_01_grannyreveal': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/forest/rts_forest_02_bloodandbeans.rts_forest_02_bloodandbeans': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/forest/rts_forest_03_trainstation.rts_forest_03_trainstation': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/forest/rts_forest_04_biobetsy.rts_forest_04_biobetsy': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/forest/rts_forest_05_mine.rts_forest_05_mine': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/forest/rts_forest_06_bridge.rts_forest_06_bridge': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/forest/rts_forest_07_boss.rts_forest_07_boss': 'Forest_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_01_ranch.rts_frontier_01_ranch': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_02_dealer.rts_frontier_02_dealer': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_03_craterentrance.rts_frontier_03_craterentrance': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_04_oilrigs.rts_frontier_04_oilrigs': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_05_moneybackentrance.rts_frontier_05_moneybackentrance': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_06_cavern.rts_frontier_06_cavern': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_07_upperarea.rts_frontier_07_upperarea': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_08_woodbuilding.rts_frontier_08_woodbuilding': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/frontier/rts_frontier_09_middle.rts_frontier_09_middle': 'Frontier_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_01_waterfall.rts_lodge_01_waterfall': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_02_corecave.rts_lodge_02_corecave': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_03_island.rts_lodge_03_island': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_04_titus.rts_lodge_04_titus': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_05_market.rts_lodge_05_market': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_06_mcsmugger_01.rts_lodge_06_mcsmugger_01': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_07_mcsmugger_02.rts_lodge_07_mcsmugger_02': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_08_mcsmugger_03.rts_lodge_08_mcsmugger_03': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_09_mcsmugger_04.rts_lodge_09_mcsmugger_04': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_10_mcsmugger_05.rts_lodge_10_mcsmugger_05': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_11_lodgeext.rts_lodge_11_lodgeext': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_12_spa.rts_lodge_12_spa': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_13_dirtydeeds.rts_lodge_13_dirtydeeds': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_14_bathhouse.rts_lodge_14_bathhouse': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/lodge/rts_lodge_15_boss.rts_lodge_15_boss': 'Lodge_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/town/rts_town_01_rose.rts_town_01_rose': 'Town_P',
        '/game/patchdlc/geranium/gamedata/fasttravel/resurrecttravelstations/town/rts_town_02_bridge.rts_town_02_bridge': 'Town_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_archive.fts_dlc2_archive': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_archives_oneway.fts_dlc2_archives_oneway': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_bar.fts_dlc2_bar': 'Bar_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_camp.fts_dlc2_camp': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_camp_oneway.fts_dlc2_camp_oneway': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_lake_amourette.fts_dlc2_lake_amourette': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_lake_droppod.fts_dlc2_lake_droppod': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_lake_excavation.fts_dlc2_lake_excavation': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_lake_gondola.fts_dlc2_lake_gondola': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_venue.fts_dlc2_venue': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_venue_mapstart.fts_dlc2_venue_mapstart': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_venue_oneway.fts_dlc2_venue_oneway': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_village_neararchives.fts_dlc2_village_neararchives': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_village_nearbar.fts_dlc2_village_nearbar': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_villagedistrict.fts_dlc2_villagedistrict': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_villagegardens.fts_dlc2_villagegardens': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/fts_dlc2_woods.fts_dlc2_woods': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_archive_village.lts_dlc2_archive_village': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_bar_lake.lts_dlc2_bar_lake': 'Bar_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_bar_village.lts_dlc2_bar_village': 'Bar_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_camp_lake.lts_dlc2_camp_lake': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_lake_bar.lts_dlc2_lake_bar': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_lake_camp.lts_dlc2_lake_camp': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_lake_woods.lts_dlc2_lake_woods': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_memories_woods.lts_dlc2_memories_woods': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_venue_village.lts_dlc2_venue_village': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_village_archive.lts_dlc2_village_archive': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_village_bar.lts_dlc2_village_bar': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_village_venue.lts_dlc2_village_venue': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_woods_lake.lts_dlc2_woods_lake': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/leveltravelstations/lts_dlc2_woods_memories.lts_dlc2_woods_memories': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/patchedleveltraveldata/lts_sanctuary3_dlc2.lts_sanctuary3_dlc2': 'Sanctuary3_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_1.rts_archive_1': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_2.rts_archive_2': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_3.rts_archive_3': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_4.rts_archive_4': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/archives/rts_archive_5.rts_archive_5': 'Archive_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_1.rts_camp_1': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_2.rts_camp_2': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_3.rts_camp_3': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_4.rts_camp_4': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_5.rts_camp_5': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_6.rts_camp_6': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/camp/rts_camp_7.rts_camp_7': 'Camp_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_1.rts_lake_1': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_2.rts_lake_2': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_3.rts_lake_3': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_4.rts_lake_4': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_5.rts_lake_5': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_6.rts_lake_6': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/lake/rts_lake_7.rts_lake_7': 'Lake_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_1.rts_venue_1': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_2.rts_venue_2': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_3.rts_venue_3': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_4.rts_venue_4': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/venue/rts_venue_5.rts_venue_5': 'Venue_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/village/rts_village_1.rts_village_1': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/village/rts_village_2.rts_village_2': 'Village_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_1.rts_woods_1': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_2.rts_woods_2': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_3.rts_woods_3': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_4.rts_woods_4': 'Woods_P',
        '/game/patchdlc/hibiscus/gamedata/fasttravel/resurrect/autogen/woods/rts_woods_5.rts_woods_5': 'Woods_P',
        '/game/patchdlc/ixora/gamedata/fasttravel/leveltravel/fts_gearupmap.fts_gearupmap': 'FrostSite_P',
        '/game/patchdlc/ixora/gamedata/fasttravel/leveltravel/fts_gearupmap_sendonly.fts_gearupmap_sendonly': 'FrostSite_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_eden6mystery.fts_ixora2_eden6mystery': 'Cabin_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_nekromystery.fts_ixora2_nekromystery': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_nekromystery_oneway.fts_ixora2_nekromystery_oneway': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_pandoramystery.fts_ixora2_pandoramystery': 'PandoraMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_promethea_oneway.fts_ixora2_promethea_oneway': 'Noir_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_prometheamystery.fts_ixora2_prometheamystery': 'Noir_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_sacrificeboss.fts_ixora2_sacrificeboss': 'SacrificeBoss_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_sacrificeboss_one.fts_ixora2_sacrificeboss_one': 'SacrificeBoss_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/fts_ixora2_sacrificeboss_oneway.fts_ixora2_sacrificeboss_oneway': 'PandoraMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_city_prometheamystery.lts_ixora2_city_prometheamystery': 'City_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_desert_pandoramystery.lts_ixora2_desert_pandoramystery': 'Desert_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_desolate_nekromystery.lts_ixora2_desolate_nekromystery': 'Desolate_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_eden6_oneway.lts_ixora2_eden6_oneway': 'Cabin_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_edenmystery_watership.lts_ixora2_edenmystery_watership': 'Cabin_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_nekromystery_desolate.lts_ixora2_nekromystery_desolate': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_nekromysteryboss_sanctuary.lts_ixora2_nekromysteryboss_sanctuary': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_pandoramystery_desert.lts_ixora2_pandoramystery_desert': 'PandoraMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_prometheamystery_city.lts_ixora2_prometheamystery_city': 'Noir_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_sacrifice_sacrificeboss.lts_ixora2_sacrifice_sacrificeboss': 'Sacrifice_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_sacrificeboss_sacrifice.lts_ixora2_sacrificeboss_sacrifice': 'SacrificeBoss_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/leveltravel/lts_ixora2_watership_edenmystery.lts_ixora2_watership_edenmystery': 'Watership_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/patchedleveltraveldata/lts_sanctuary3_ixora2.lts_sanctuary3_ixora2': 'Sanctuary3_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_cabin_huntingcabin_geo_2.rts_cabin_huntingcabin_geo_2': 'Cabin_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_cabin_interior_geo_2.rts_cabin_interior_geo_2': 'Cabin_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_cabin_p_2.rts_cabin_p_2': 'Cabin_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_nekromystery_gameplay_10.rts_nekromystery_gameplay_10': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_nekromystery_gameplay_14.rts_nekromystery_gameplay_14': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_nekromystery_gameplay_18.rts_nekromystery_gameplay_18': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_nekromystery_gameplay_2.rts_nekromystery_gameplay_2': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_nekromystery_gameplay_6.rts_nekromystery_gameplay_6': 'NekroMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_noir_p_0.rts_noir_p_0': 'Noir_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_noir_p_1.rts_noir_p_1': 'Noir_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_noir_p_2.rts_noir_p_2': 'Noir_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_noir_p_3.rts_noir_p_3': 'Noir_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_noir_p_4.rts_noir_p_4': 'Noir_P',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_pandoramystery_travel_2.rts_pandoramystery_travel_2': 'PandoraMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_pandoramystery_travel_6.rts_pandoramystery_travel_6': 'PandoraMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_pandoramystery_travel_asilo.rts_pandoramystery_travel_asilo': 'PandoraMystery_p',
        '/game/patchdlc/ixora2/gamedata/fasttravel/resurrecttravelstations/rts_pandoramystery_travel_bsilo.rts_pandoramystery_travel_bsilo': 'PandoraMystery_p',
        '/game/patchdlc/raid1/gamedata/fasttravel/leveltraveldata/fts_maliwantd_sendonly.fts_maliwantd_sendonly': 'Raid_P',
        '/game/patchdlc/raid1/gamedata/fasttravel/leveltraveldata/fts_raid1.fts_raid1': 'Raid_P',
        '/game/patchdlc/raid1/gamedata/fasttravel/leveltraveldata/fts_raid1droppod.fts_raid1droppod': 'Raid_P',
        '/game/patchdlc/raid1/gamedata/fasttravel/leveltraveldata/lts_sanctuary3_raid1.lts_sanctuary3_raid1': 'Sanctuary3_P',
        '/game/patchdlc/takedown2/gamedata/leveltravel/fts_guardiantd_sendonly_2.fts_guardiantd_sendonly_2': 'GuardianTakedown_P',
        '/game/patchdlc/takedown2/gamedata/leveltravel/fts_td2.fts_td2': 'GuardianTakedown_P',
        '/game/patchdlc/takedown2/gamedata/leveltravel/fts_td2droppod1.fts_td2droppod1': 'GuardianTakedown_P',
        '/game/patchdlc/takedown2/gamedata/leveltravel/lts_sanctuary3_td2.lts_sanctuary3_td2': 'Sanctuary3_P',
        }

