# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class SentEmailDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'user_id': 'str',
        'inbox_id': 'str',
        'to': 'list[str]',
        '_from': 'str',
        'reply_to': 'str',
        'cc': 'list[str]',
        'bcc': 'list[str]',
        'attachments': 'list[str]',
        'subject': 'str',
        'body_md5_hash': 'str',
        'body': 'str',
        'charset': 'str',
        'is_html': 'bool',
        'sent_at': 'datetime',
        'pixel_ids': 'list[str]',
        'message_id': 'str',
        'virtual_send': 'bool',
        'html': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'user_id': 'userId',
        'inbox_id': 'inboxId',
        'to': 'to',
        '_from': 'from',
        'reply_to': 'replyTo',
        'cc': 'cc',
        'bcc': 'bcc',
        'attachments': 'attachments',
        'subject': 'subject',
        'body_md5_hash': 'bodyMD5Hash',
        'body': 'body',
        'charset': 'charset',
        'is_html': 'isHTML',
        'sent_at': 'sentAt',
        'pixel_ids': 'pixelIds',
        'message_id': 'messageId',
        'virtual_send': 'virtualSend',
        'html': 'html'
    }

    def __init__(self, id=None, user_id=None, inbox_id=None, to=None, _from=None, reply_to=None, cc=None, bcc=None, attachments=None, subject=None, body_md5_hash=None, body=None, charset=None, is_html=None, sent_at=None, pixel_ids=None, message_id=None, virtual_send=None, html=None, local_vars_configuration=None):  # noqa: E501
        """SentEmailDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._user_id = None
        self._inbox_id = None
        self._to = None
        self.__from = None
        self._reply_to = None
        self._cc = None
        self._bcc = None
        self._attachments = None
        self._subject = None
        self._body_md5_hash = None
        self._body = None
        self._charset = None
        self._is_html = None
        self._sent_at = None
        self._pixel_ids = None
        self._message_id = None
        self._virtual_send = None
        self._html = None
        self.discriminator = None

        self.id = id
        self.user_id = user_id
        self.inbox_id = inbox_id
        if to is not None:
            self.to = to
        if _from is not None:
            self._from = _from
        if reply_to is not None:
            self.reply_to = reply_to
        if cc is not None:
            self.cc = cc
        if bcc is not None:
            self.bcc = bcc
        if attachments is not None:
            self.attachments = attachments
        if subject is not None:
            self.subject = subject
        if body_md5_hash is not None:
            self.body_md5_hash = body_md5_hash
        if body is not None:
            self.body = body
        if charset is not None:
            self.charset = charset
        if is_html is not None:
            self.is_html = is_html
        self.sent_at = sent_at
        if pixel_ids is not None:
            self.pixel_ids = pixel_ids
        if message_id is not None:
            self.message_id = message_id
        if virtual_send is not None:
            self.virtual_send = virtual_send
        if html is not None:
            self.html = html

    @property
    def id(self):
        """Gets the id of this SentEmailDto.  # noqa: E501

        ID of sent email  # noqa: E501

        :return: The id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SentEmailDto.

        ID of sent email  # noqa: E501

        :param id: The id of this SentEmailDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def user_id(self):
        """Gets the user_id of this SentEmailDto.  # noqa: E501

        User ID  # noqa: E501

        :return: The user_id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this SentEmailDto.

        User ID  # noqa: E501

        :param user_id: The user_id of this SentEmailDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user_id is None:  # noqa: E501
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def inbox_id(self):
        """Gets the inbox_id of this SentEmailDto.  # noqa: E501

        Inbox ID email was sent from  # noqa: E501

        :return: The inbox_id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._inbox_id

    @inbox_id.setter
    def inbox_id(self, inbox_id):
        """Sets the inbox_id of this SentEmailDto.

        Inbox ID email was sent from  # noqa: E501

        :param inbox_id: The inbox_id of this SentEmailDto.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and inbox_id is None:  # noqa: E501
            raise ValueError("Invalid value for `inbox_id`, must not be `None`")  # noqa: E501

        self._inbox_id = inbox_id

    @property
    def to(self):
        """Gets the to of this SentEmailDto.  # noqa: E501

        Recipients email was sent to  # noqa: E501

        :return: The to of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this SentEmailDto.

        Recipients email was sent to  # noqa: E501

        :param to: The to of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._to = to

    @property
    def _from(self):
        """Gets the _from of this SentEmailDto.  # noqa: E501


        :return: The _from of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """Sets the _from of this SentEmailDto.


        :param _from: The _from of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self.__from = _from

    @property
    def reply_to(self):
        """Gets the reply_to of this SentEmailDto.  # noqa: E501


        :return: The reply_to of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._reply_to

    @reply_to.setter
    def reply_to(self, reply_to):
        """Sets the reply_to of this SentEmailDto.


        :param reply_to: The reply_to of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._reply_to = reply_to

    @property
    def cc(self):
        """Gets the cc of this SentEmailDto.  # noqa: E501


        :return: The cc of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._cc

    @cc.setter
    def cc(self, cc):
        """Sets the cc of this SentEmailDto.


        :param cc: The cc of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._cc = cc

    @property
    def bcc(self):
        """Gets the bcc of this SentEmailDto.  # noqa: E501


        :return: The bcc of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._bcc

    @bcc.setter
    def bcc(self, bcc):
        """Sets the bcc of this SentEmailDto.


        :param bcc: The bcc of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._bcc = bcc

    @property
    def attachments(self):
        """Gets the attachments of this SentEmailDto.  # noqa: E501

        Array of IDs of attachments that were sent with this email  # noqa: E501

        :return: The attachments of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """Sets the attachments of this SentEmailDto.

        Array of IDs of attachments that were sent with this email  # noqa: E501

        :param attachments: The attachments of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._attachments = attachments

    @property
    def subject(self):
        """Gets the subject of this SentEmailDto.  # noqa: E501


        :return: The subject of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """Sets the subject of this SentEmailDto.


        :param subject: The subject of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._subject = subject

    @property
    def body_md5_hash(self):
        """Gets the body_md5_hash of this SentEmailDto.  # noqa: E501

        MD5 Hash  # noqa: E501

        :return: The body_md5_hash of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._body_md5_hash

    @body_md5_hash.setter
    def body_md5_hash(self, body_md5_hash):
        """Sets the body_md5_hash of this SentEmailDto.

        MD5 Hash  # noqa: E501

        :param body_md5_hash: The body_md5_hash of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._body_md5_hash = body_md5_hash

    @property
    def body(self):
        """Gets the body of this SentEmailDto.  # noqa: E501


        :return: The body of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """Sets the body of this SentEmailDto.


        :param body: The body of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._body = body

    @property
    def charset(self):
        """Gets the charset of this SentEmailDto.  # noqa: E501


        :return: The charset of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._charset

    @charset.setter
    def charset(self, charset):
        """Sets the charset of this SentEmailDto.


        :param charset: The charset of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._charset = charset

    @property
    def is_html(self):
        """Gets the is_html of this SentEmailDto.  # noqa: E501


        :return: The is_html of this SentEmailDto.  # noqa: E501
        :rtype: bool
        """
        return self._is_html

    @is_html.setter
    def is_html(self, is_html):
        """Sets the is_html of this SentEmailDto.


        :param is_html: The is_html of this SentEmailDto.  # noqa: E501
        :type: bool
        """

        self._is_html = is_html

    @property
    def sent_at(self):
        """Gets the sent_at of this SentEmailDto.  # noqa: E501


        :return: The sent_at of this SentEmailDto.  # noqa: E501
        :rtype: datetime
        """
        return self._sent_at

    @sent_at.setter
    def sent_at(self, sent_at):
        """Sets the sent_at of this SentEmailDto.


        :param sent_at: The sent_at of this SentEmailDto.  # noqa: E501
        :type: datetime
        """
        if self.local_vars_configuration.client_side_validation and sent_at is None:  # noqa: E501
            raise ValueError("Invalid value for `sent_at`, must not be `None`")  # noqa: E501

        self._sent_at = sent_at

    @property
    def pixel_ids(self):
        """Gets the pixel_ids of this SentEmailDto.  # noqa: E501


        :return: The pixel_ids of this SentEmailDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._pixel_ids

    @pixel_ids.setter
    def pixel_ids(self, pixel_ids):
        """Sets the pixel_ids of this SentEmailDto.


        :param pixel_ids: The pixel_ids of this SentEmailDto.  # noqa: E501
        :type: list[str]
        """

        self._pixel_ids = pixel_ids

    @property
    def message_id(self):
        """Gets the message_id of this SentEmailDto.  # noqa: E501


        :return: The message_id of this SentEmailDto.  # noqa: E501
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """Sets the message_id of this SentEmailDto.


        :param message_id: The message_id of this SentEmailDto.  # noqa: E501
        :type: str
        """

        self._message_id = message_id

    @property
    def virtual_send(self):
        """Gets the virtual_send of this SentEmailDto.  # noqa: E501


        :return: The virtual_send of this SentEmailDto.  # noqa: E501
        :rtype: bool
        """
        return self._virtual_send

    @virtual_send.setter
    def virtual_send(self, virtual_send):
        """Sets the virtual_send of this SentEmailDto.


        :param virtual_send: The virtual_send of this SentEmailDto.  # noqa: E501
        :type: bool
        """

        self._virtual_send = virtual_send

    @property
    def html(self):
        """Gets the html of this SentEmailDto.  # noqa: E501


        :return: The html of this SentEmailDto.  # noqa: E501
        :rtype: bool
        """
        return self._html

    @html.setter
    def html(self, html):
        """Sets the html of this SentEmailDto.


        :param html: The html of this SentEmailDto.  # noqa: E501
        :type: bool
        """

        self._html = html

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SentEmailDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SentEmailDto):
            return True

        return self.to_dict() != other.to_dict()
