# COSMIC
COSMIC (Compact Object Synthesis and Monte Carlo Investigation Code)

COSMIC is a rapid binary population synthesis suite with a special purpose of generating realistic compact binary populations. COSMIC can also be used to evolve binaries with BSE in a python environment.

COSMIC currently implements binary evolutionary processes using BSE (Hurley+2002). Several modifications have been applied to BSE to account for recent updates to binary evolution especially important to compact binary formation (e.g. metallicity-dependent stellar winds or black hole natal kick strengths). For a detailed discussion of these modifications, see [Breivik et al 2019](https://arxiv.org/abs/1911.00903)

<https://cosmic-popsynth.github.io/>

# Release Status

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.3561144.svg)](https://doi.org/10.5281/zenodo.3561144)


[![PyPI version](https://badge.fury.io/py/cosmic-popsynth.svg)](https://badge.fury.io/py/cosmic-popsynth)


# Installation

The easiest method to install cosmic is using pip directly:

```
pip install cosmic-popsynth
```

[![Build Status](https://travis-ci.com/COSMIC-PopSynth/COSMIC.svg?branch=develop)](https://travis-ci.com/COSMIC-PopSynth/COSMIC)

[![Coverage Status](https://coveralls.io/repos/github/COSMIC-PopSynth/COSMIC/badge.svg?branch=develop)](https://coveralls.io/github/COSMIC-PopSynth/COSMIC?branch=develop)

[![codecov](https://codecov.io/gh/COSMIC-PopSynth/COSMIC/branch/develop/graph/badge.svg)](https://codecov.io/gh/COSMIC-PopSynth/COSMIC)

