from .base_field_check import BaseFieldCheck
from django.db import models


class ReservedSQLKeywords(BaseFieldCheck):
    def perform_field_check(self):
        field = self.field_info.field
        sql_keywords = set(
            [
                "select",
                "from",
                "where",
                "join",
                "on",
                "group",
                "by",
                "having",
                "order",
                "limit",
                "insert",
                "into",
                "values",
                "update",
                "set",
                "delete",
                "truncate",
                "alter",
                "create",
                "drop",
                "primary",
                "key",
                "foreign",
                "unique",
                "index",
                "table",
                "view",
                "database",
                "transaction",
                "commit",
                "rollback",
                "savepoint",
                "and",
                "or",
                "not",
                "in",
                "between",
                "like",
                "null",
                "is",
                "as",
                "asc",
                "desc",
                "case",
                "when",
                "then",
                "else",
                "end",
                "cast",
                "collate",
                "constraint",
                "default",
                "exists",
                "union",
                "intersect",
                "except",
                "all",
                "any",
                "some",
                "outer",
                "inner",
                "left",
                "right",
                "full",
                "cross",
                "natural",
                "replace",
                "returning",
                "with",
                "recursive",
                "grant",
                "revoke",
                "deny",
                "schema",
                "cursor",
                "declare",
                "open",
                "fetch",
                "close",
                "deallocate",
                "execute",
                "prepare",
                "unprepare",
                "rowcount",
                "identity",
                "raise",
                "err",
                "print",
                "goto",
                "begin",
                "rollback",
                "top",
                "percent",
                "distinct",
                "date",
                "time",
                "timestamp",
                "interval",
                "year",
                "month",
                "day",
                "hour",
                "minute",
                "second",
                "escape",
                "connect",
                "start",
                "session",
                "set",
                "current",
                "isolation",
                "level",
                "read",
                "write",
                "only",
                "work",
                "option",
                "temporary",
                "rename",
                "add",
                "modify",
                "after",
                "before",
                "cascade",
                "restrict",
                "no",
                "action",
                "initially",
                "deferred",
                "immediate",
                "match",
                "full",
                "partial",
                "simple",
                "references",
                "check",
                "using",
                "comment",
                "lock",
                "mode",
                "audit",
                "row",
                "until",
                "whenever",
                "sqlstate",
                "assertion",
                "domain",
                "iterate",
                "leave",
                "loop",
                "repeat",
                "resignal",
                "signal",
                "truncate",
                "while",
                "do",
                "handler",
                "package",
                "pragma",
                "exception",
                "bit",
                "tinyint",
                "smallint",
                "mediumint",
                "int",
                "integer",
                "bigint",
                "real",
                "double",
                "float",
                "decimal",
                "numeric",
                "fixed",
                "char",
                "varchar",
                "binary",
                "varbinary",
                "tinyblob",
                "blob",
                "mediumblob",
                "longblob",
                "tinytext",
                "text",
                "mediumtext",
                "longtext",
                "enum",
                "set",
                "year",
                "geometry",
                "point",
                "linestring",
                "polygon",
                "multipoint",
                "multilinestring",
                "multipolygon",
                "geomcollection",
            ]
        )

        if field.name.lower() in sql_keywords:
            return {
                "severity": "High",
                "description": "Field name contains reserved SQL keyword.",
                "explanation": f"The field '{field.name}' is a reserved SQL keyword. Using reserved keywords as field names can lead to unexpected behavior or SQL syntax errors. To resolve this issue, rename the field to something that is not a reserved keyword.",
            }
        else:
            return None
