# generated by datamodel-codegen:
#   filename:  type/entityRelationship.json
#   timestamp: 2022-10-03T05:49:41+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, conint

from . import basic


class RelationshipType(Enum):
    contains = 'contains'
    createdBy = 'createdBy'
    repliedTo = 'repliedTo'
    isAbout = 'isAbout'
    addressedTo = 'addressedTo'
    mentionedIn = 'mentionedIn'
    testedBy = 'testedBy'
    uses = 'uses'
    owns = 'owns'
    parentOf = 'parentOf'
    has = 'has'
    follows = 'follows'
    joinedWith = 'joinedWith'
    upstream = 'upstream'
    appliedTo = 'appliedTo'
    relatedTo = 'relatedTo'
    reviews = 'reviews'
    reactedTo = 'reactedTo'


class EntityRelationship(BaseModel):
    class Config:
        extra = Extra.forbid

    fromId: Optional[basic.Uuid] = Field(
        None,
        description='Unique identifier that identifies the entity from which the relationship originates.',
    )
    fromFQN: Optional[str] = Field(
        None,
        description='Fully qualified name of the entity from which the relationship originates.',
    )
    fromEntity: str = Field(
        ...,
        description='Type of the entity from which the relationship originates. Examples: `database`, `table`, `metrics` ...',
    )
    toId: Optional[basic.Uuid] = Field(
        None,
        description='Unique identifier that identifies the entity towards which the relationship refers to.',
    )
    toFQN: Optional[str] = Field(
        None,
        description='Fully qualified name of the entity towards which the relationship refers to.',
    )
    toEntity: str = Field(
        ...,
        description='Type of the entity towards which the relationship refers to. Examples: `database`, `table`, `metrics` ...',
    )
    relation: Optional[conint(ge=0)] = Field(
        None,
        description='Describes relationship between the two entities as an integer.',
    )
    relationshipType: RelationshipType = Field(
        ...,
        description='Describes relationship between the two entities. Eg: Database --- Contains --> Table.',
    )
    deleted: Optional[bool] = Field(
        False, description='`true` indicates the relationship has been soft deleted.'
    )
