# generated by datamodel-codegen:
#   filename:  settings/eventPublisherJob.json
#   timestamp: 2022-10-03T05:49:41+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic


class Status2(Enum):
    ACTIVE = 'ACTIVE'
    RETRY = 'RETRY'
    ACTIVEWITHERROR = 'ACTIVEWITHERROR'
    IDLE = 'IDLE'
    COMPLETED = 'COMPLETED'


class FailureDetails1(BaseModel):
    class Config:
        extra = Extra.forbid

    lastFailedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedReason: Optional[str] = Field(
        None,
        description='Last non-successful activity response reason received during callback.',
    )


class Stats(BaseModel):
    class Config:
        extra = Extra.forbid

    success: Optional[int] = Field(0, description='Count of Success Record')
    failed: Optional[int] = Field(0, description='Count of Failed Records')
    total: Optional[int] = Field(0, description='Count of Failed Records')


class RunMode(Enum):
    stream = 'stream'
    batch = 'batch'


class PublisherType(Enum):
    elasticSearch = 'elasticSearch'
    kafka = 'kafka'


class EventPublisherResult(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(..., description='Name of the result')
    startedBy: Optional[str] = Field(None, description='Job started by')
    publisherType: PublisherType
    runMode: RunMode
    timestamp: basic.Timestamp
    startTime: Optional[basic.Timestamp] = None
    endTime: Optional[basic.Timestamp] = None
    status: Status2 = Field(..., description='This schema publisher run job status.')
    failureDetails: Optional[FailureDetails1] = Field(
        None, description='Failure details are set only when `status` is not `success`.'
    )
    stats: Optional[Stats] = None
    entities: Optional[List[str]] = Field(
        None, description='List of Entities to Reindex', unique_items=True
    )
