"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailSubscription = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("@aws-cdk/aws-sns");
/**
 * Use an email address as a subscription target
 *
 * Email subscriptions require confirmation.
 */
class EmailSubscription {
    constructor(emailAddress, props = {}) {
        this.emailAddress = emailAddress;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sns_subscriptions_EmailSubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * Returns a configuration for an email address to subscribe to an SNS topic
     */
    bind(_topic) {
        return {
            subscriberId: this.emailAddress,
            endpoint: this.emailAddress,
            protocol: this.props.json ? sns.SubscriptionProtocol.EMAIL_JSON : sns.SubscriptionProtocol.EMAIL,
            filterPolicy: this.props.filterPolicy,
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
}
exports.EmailSubscription = EmailSubscription;
_a = JSII_RTTI_SYMBOL_1;
EmailSubscription[_a] = { fqn: "@aws-cdk/aws-sns-subscriptions.EmailSubscription", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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