# generated by datamodel-codegen:
#   filename:  schema/metadataIngestion/workflow.json
#   timestamp: 2022-04-11T06:51:08+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional, Union

from pydantic import BaseModel, Extra, Field

from ..entity.services.connections import serviceConnection
from ..type import basic
from . import (
    dashboardServiceMetadataPipeline,
    databaseServiceMetadataPipeline,
    databaseServiceQueryUsagePipeline,
    messagingServiceMetadataPipeline,
)


class AzureSSOConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    clientSecret: str = Field(..., description='Azure SSO client secret key')
    authority: str = Field(..., description='Azure SSO Authority')
    clientId: str = Field(..., description='Azure Client ID.')
    scopes: List[str] = Field(..., description='Azure Client ID.')


class GoogleSSOConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    secretKey: str = Field(
        ..., description='Google SSO client secret key path or contents.'
    )
    audience: Optional[str] = Field(
        'https://www.googleapis.com/oauth2/v4/token',
        description='Google SSO audience URL',
    )


class OktaSSOConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    clientId: str = Field(..., description='Okta Client ID.')
    orgURL: str = Field(..., description='Okta org url.')
    privateKey: str = Field(..., description='Okta Private Key.')
    email: str = Field(..., description='Okta Service account Email.')
    scopes: Optional[List[str]] = Field(None, description='Okta client scopes.')


class Auth0SSOConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    clientId: str = Field(..., description='Auth0 Client ID.')
    secretKey: str = Field(..., description='Auth0 Client Secret Key.')
    domain: str = Field(..., description='Auth0 Domain.')


class CustomOidcSSOConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    clientId: str = Field(..., description='Custom OIDC Client ID.')
    secretKey: str = Field(..., description='Custom OIDC Client Secret Key.')
    tokenEndpoint: str = Field(..., description='Custom OIDC token endpoint.')


class AuthProvider(Enum):
    no_auth = 'no-auth'
    google = 'google'
    okta = 'okta'
    auth0 = 'auth0'
    custom_oidc = 'custom-oidc'


class OpenMetadataServerConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    hostPort: str = Field(
        ...,
        description='OpenMetadata Server Config. Must include API end point ex: http://localhost:8585/api',
    )
    authProvider: Optional[AuthProvider] = Field(
        AuthProvider.no_auth,
        description='OpenMetadata Server Authentication Provider. Make sure configure same auth providers as the one configured on OpenMetadaata server.',
    )
    securityConfig: Optional[
        Union[
            GoogleSSOConfig,
            OktaSSOConfig,
            Auth0SSOConfig,
            AzureSSOConfig,
            CustomOidcSSOConfig,
        ]
    ] = Field(None, description='OpenMetadata Client security configuration.')
    apiVersion: Optional[str] = Field(
        'v1', description='OpenMetadata server API version to use.'
    )


class ComponentConfig(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class Processor(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str = Field(..., description='Type of processor component ex: pii-processor')
    config: Optional[ComponentConfig] = None


class Stage(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str = Field(..., description='Type of stage component ex: table-usage')
    config: Optional[ComponentConfig] = None


class Sink(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str = Field(..., description='Type of sink component ex: metadata')
    config: Optional[ComponentConfig] = None


class BulkSink(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str = Field(..., description='Type of BulkSink component ex: metadata-usage')
    config: Optional[ComponentConfig] = None


class WorkflowConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    openMetadataServerConfig: OpenMetadataServerConfig
    config: Optional[ComponentConfig] = None


class SourceConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[
        Union[
            databaseServiceMetadataPipeline.DatabaseServiceMetadataPipeline,
            databaseServiceQueryUsagePipeline.DatabaseServiceQueryUsagePipeline,
            dashboardServiceMetadataPipeline.DashboardServiceMetadataPipeline,
            messagingServiceMetadataPipeline.MessagingServiceMetadataPipeline,
        ]
    ] = None


class Source(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str = Field(
        ...,
        description='Type of the source connector ex: mysql, snowflake, tableau etc..',
    )
    serviceName: str = Field(
        ...,
        description='Type of the source connector ex: mysql, snowflake, tableau etc..',
    )
    serviceConnection: serviceConnection.ServiceConnection = Field(
        ...,
        description='Connection configuration for the source. ex: mysql , tableau connection.',
    )
    sourceConfig: SourceConfig


class OpenMetadataWorkflowConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    source: Source
    processor: Optional[Processor] = None
    sink: Optional[Sink] = None
    stage: Optional[Stage] = None
    bulkSink: Optional[BulkSink] = None
    workflowConfig: WorkflowConfig


class MetadataWorkflow1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this pipeline.'
    )
    name: Optional[basic.EntityName] = Field(
        None, description='Name that identifies this pipeline instance uniquely.'
    )
    openMetadataWorkflowConfig: Optional[OpenMetadataWorkflowConfig] = Field(
        None, description='OpenMetadata Ingestion Workflow Config.'
    )


class MetadataWorkflow(BaseModel):
    class Config:
        extra = Extra.forbid

    __root__: Union[MetadataWorkflow1, Any, Any] = Field(
        ...,
        description='OpenMetadata Ingestion Framework definition.',
        title='MetadataWorkflow',
    )
