# generated by datamodel-codegen:
#   filename:  schema/entity/services/ingestionPipelines/ingestionPipeline.json
#   timestamp: 2022-04-11T06:51:08+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from ....metadataIngestion import workflow
from ....type import basic, entityHistory, entityReference


class PipelineType(Enum):
    metadata = 'metadata'
    usage = 'usage'


class AirflowConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    forceDeploy: Optional[bool] = Field(
        False,
        description='Deploy the pipeline by overwriting existing pipeline with the same name.',
    )
    pausePipeline: Optional[bool] = Field(
        False,
        description='pause the pipeline from running once the deploy is finished successfully.',
    )
    concurrency: Optional[int] = Field(1, description='Concurrency of the Pipeline.')
    startDate: basic.Date = Field(..., description='Start date of the pipeline.')
    endDate: Optional[basic.Date] = Field(None, description='End Date of the pipeline.')
    nextExecutionDate: Optional[basic.Date] = Field(
        None,
        description='Next execution date from the underlying pipeline platform once the pipeline scheduled.',
    )
    pipelineTimezone: Optional[str] = Field(
        'UTC', description='Timezone in which pipeline going to be scheduled.'
    )
    retries: Optional[int] = Field(3, description='Retry pipeline in case of failure.')
    retryDelay: Optional[int] = Field(
        300, description='Delay between retries in seconds.'
    )
    pipelineCatchup: Optional[bool] = Field(
        False, description='Run past executions if the start date is in the past.'
    )
    scheduleInterval: Optional[str] = Field(
        None, description='Scheduler Interval for the pipeline in cron format.'
    )
    pipelineTimeout: Optional[int] = Field(
        60, description='Timeout for the pipeline in seconds.'
    )
    maxActiveRuns: Optional[int] = Field(
        1, description='Maximum Number of active runs.'
    )
    workflowTimeout: Optional[int] = Field(
        60, description='Timeout for the workflow in seconds.'
    )
    workflowDefaultView: Optional[str] = Field(
        'tree', description='Default view in Airflow.'
    )
    workflowDefaultViewOrientation: Optional[str] = Field(
        'LR', description='Default view Orientation in Airflow.'
    )
    pythonOperatorLocation: Optional[str] = Field(
        None,
        description='File system directory path where managed python operator files are stored.',
    )
    slaMissCallback: Optional[str] = Field(
        None, description='python method call back on SLA miss.'
    )
    email: Optional[basic.Email] = Field(
        None, description='Email to notify workflow status.'
    )


class IngestionPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this pipeline.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this pipeline instance uniquely.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this Pipeline.'
    )
    description: Optional[str] = Field(None, description='Description of the Pipeline.')
    pipelineType: PipelineType
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Pipeline.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='Name that uniquely identifies a Pipeline.'
    )
    source: workflow.Source
    openMetadataServerConnection: workflow.OpenMetadataServerConfig
    airflowConfig: AirflowConfig
    service: Optional[entityReference.EntityReference] = Field(
        None,
        description='Link to the database service where this database is hosted in.',
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to this ingestion pipeline resource.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that led to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
