# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/trinoConnection.json
#   timestamp: 2022-04-11T06:51:08+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from . import connectionBasicType


class SupportedPipelineType19(Enum):
    Metadata = 'Metadata'


class TrinoType(Enum):
    Trino = 'Trino'


class TrinoScheme(Enum):
    trino = 'trino'


class TrinoConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TrinoType] = Field(TrinoType.Trino, description='Service Type')
    scheme: Optional[TrinoScheme] = Field(
        TrinoScheme.trino, description='SQLAlchemy driver scheme options.'
    )
    username: Optional[str] = Field(
        None,
        description='username to connect to Trino. This user should have privileges to read all the metadata in Trino.',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect  to the Trino.'
    )
    hostPort: Optional[str] = Field(
        None, description='Host and port of the data source.'
    )
    catalog: Optional[str] = Field(None, description='Catalog of the data source.')
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank , OpenMetadata Ingestion attempts to scan all the databases in the selected catalog in Trino.',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    proxies: Optional[Dict[str, Any]] = Field(
        None, description='Proxies for the connection to Trino data source'
    )
    params: Optional[Dict[str, Any]] = Field(
        None, description='URL parameters for connection to the Trino data source'
    )
    supportedPipelineTypes: Optional[List[SupportedPipelineType19]] = Field(
        ['Metadata'], description='Supported Metadata Extraction Pipelines.'
    )
